/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.SlaveInfo;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketview.GlobalSearchViewDefinition;
import com.inet.helpdesk.core.ticketview.SubViewGroupingDefinition;
import com.inet.helpdesk.core.ticketview.TicketListState;
import com.inet.helpdesk.core.ticketview.TicketListUpdateListener;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.core.ticketview.TicketViewManager;
import com.inet.helpdesk.core.ticketview.TicketViewSearchCommandFactory;
import com.inet.helpdesk.core.ticketview.TicketViewState;
import com.inet.helpdesk.core.ticketview.TicketViewVisibility;
import com.inet.helpdesk.core.ticketview.ViewUpdateListener;
import com.inet.helpdesk.ticketview.BaseTicketListChangeMonitor;
import com.inet.helpdesk.ticketview.TicketListChangeMonitor;
import com.inet.helpdesk.ticketview.TicketViewTicketEventListener;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.index.SearchResultListener;
import com.inet.thread.EventDispatcher;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketViewTree {
    public static final SearchCondition UNREAD_SUPPORTER = new SearchCondition("TicketUnreadForSupporter", SearchCondition.SearchTermOperator.Equals, (Object)"1");
    public static final SearchCondition UNREAD_ENDUSER = new SearchCondition("TicketUnreadForEnduser", SearchCondition.SearchTermOperator.Equals, (Object)"1");
    private final IndexSearchEngine<Integer> engine = TicketManager.getReader().getSearchEngine();
    private final IndexSearchEngine<SlaveInfo> slaveInfoEngine = TicketManager.getReader().getSlaveInfoEngine();
    private List<TicketViewFactory> viewFactories;
    private final List<ViewListener> viewListeners = new ArrayList<ViewListener>();
    private final Map<String, ViewUpdateListener> clients = new HashMap<String, ViewUpdateListener>();
    private final Map<String, BaseTicketListChangeMonitor> ticketLists = new HashMap<String, BaseTicketListChangeMonitor>();
    @Nonnull
    private final GUID accountID;
    private final TicketViewManager manager = TicketViewManager.getInstance();
    private boolean showBunId;
    private final EventDispatcher<TicketViewTree> eventDispatcher;

    TicketViewTree(@Nonnull GUID accountID) {
        this.accountID = accountID;
        this.eventDispatcher = new EventDispatcher(false, false);
        this.eventDispatcher.registerListener((Object)this);
    }

    @Nonnull
    GUID getAccountID() {
        return this.accountID;
    }

    @Nullable
    private TicketViewState getSearchState(@Nonnull String clientID) {
        BaseTicketListChangeMonitor changeMonitor = this.getChangeMonitor(clientID);
        if (changeMonitor == null) {
            return null;
        }
        return this.getSearchState(clientID, changeMonitor.getTicketListState().getSearchPhrase());
    }

    @Nullable
    private TicketViewState getSearchState(@Nonnull String clientID, final String phrase) {
        if (!StringFunctions.isEmpty((String)phrase)) {
            GlobalSearchViewDefinition def = GlobalSearchViewDefinition.INSTANCE;
            return new TicketViewState(def.getID(), -1, -1, def, 0){

                @Override
                public String getDisplayName() {
                    return super.getDisplayName() + " " + phrase;
                }
            };
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<TicketViewState> getStates(@Nonnull String clientID) {
        ArrayList<TicketViewState> list = new ArrayList<TicketViewState>();
        Map<String, ViewUpdateListener> map = this.clients;
        synchronized (map) {
            TicketViewState state = this.getSearchState(clientID);
            if (state != null) {
                list.add(state);
            }
            for (ViewListener listener : this.viewListeners) {
                state = listener.getState();
                if (listener.grouping == null) {
                    list.add(state);
                    continue;
                }
                list.addAll(state);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putViewUpdateListener(@Nonnull String clientID, @Nonnull ViewUpdateListener viewUpdateListener) {
        Map<String, ViewUpdateListener> map = this.clients;
        synchronized (map) {
            this.clients.put(clientID, viewUpdateListener);
            this.sendStructureChanged(clientID, viewUpdateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFactories(@Nonnull List<TicketViewFactory> factories, List<TicketViewVisibility> visibilities) {
        this.viewFactories = new ArrayList<TicketViewFactory>(factories);
        TicketViewTree.sortViews(factories, visibilities);
        this.showBunId = HDUsersAndGroups.isSupporter(this.accountID);
        boolean changed = false;
        boolean commandUpdated = false;
        boolean added = false;
        Map<String, Object> map = this.clients;
        synchronized (map) {
            int listenerIdx = 0;
            block6: for (TicketViewFactory ticketViewFactory : factories) {
                String id = ticketViewFactory.getID();
                for (int i = listenerIdx; i < this.viewListeners.size(); ++i) {
                    ViewListener listener = this.viewListeners.get(i);
                    if (!id.equals(listener.factory.getID())) continue;
                    SearchCommand searchCommand = ticketViewFactory.createSearchCommand(this.accountID, ClientLocale.getThreadLocale(), this.engine);
                    if (searchCommand == null) {
                        this.engine.removeSearchResultListener((SearchResultListener)listener);
                        this.viewListeners.remove(i);
                        changed = true;
                        continue block6;
                    }
                    if (i != listenerIdx) {
                        Collections.swap(this.viewListeners, i, listenerIdx);
                        changed = true;
                    }
                    if (listener.hasChanges(searchCommand) || !Objects.equals(listener.grouping, ticketViewFactory.getSubViewGrouping()) || !Objects.equals(listener.factory.getDisplayName(), ticketViewFactory.getDisplayName()) || !Objects.equals(listener.factory.getDescription(), ticketViewFactory.getDescription()) || listener.metaDataVersion != ticketViewFactory.getMetaDataVersion()) {
                        this.engine.removeSearchResultListener((SearchResultListener)listener);
                        this.viewListeners.remove(listenerIdx);
                        this.addFactoryAt(listenerIdx, ticketViewFactory, searchCommand);
                        commandUpdated = true;
                    }
                    ++listenerIdx;
                    continue block6;
                }
                SearchCommand searchCommand = ticketViewFactory.createSearchCommand(this.accountID, ClientLocale.getThreadLocale(), this.engine);
                if (searchCommand == null) continue;
                this.addFactoryAt(listenerIdx, ticketViewFactory, searchCommand);
                added = true;
                ++listenerIdx;
            }
            while (listenerIdx < this.viewListeners.size()) {
                ViewListener listener = this.viewListeners.get(listenerIdx);
                this.engine.removeSearchResultListener((SearchResultListener)listener);
                this.viewListeners.remove(listenerIdx);
                changed = true;
            }
            if (changed && !added) {
                this.sendStructureChanged();
            }
        }
        if (commandUpdated) {
            map = this.ticketLists;
            synchronized (map) {
                Iterator<BaseTicketListChangeMonitor> it = this.ticketLists.values().iterator();
                while (it.hasNext()) {
                    BaseTicketListChangeMonitor changeMonitor = it.next();
                    TicketViewSearchCommandFactory ticketViewSearchCommandFactory = this.getTicketViewSearchFactory(changeMonitor.getFactory().getID());
                    if (ticketViewSearchCommandFactory == null) {
                        it.remove();
                        TicketViewTree.unregisterChangeMonitor(changeMonitor);
                        continue;
                    }
                    changeMonitor.updateFactory(ticketViewSearchCommandFactory);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onPossibleChange() {
        ArrayList<ViewListener> changedListeners;
        Map<String, ViewUpdateListener> map = this.clients;
        synchronized (map) {
            changedListeners = new ArrayList<ViewListener>(this.viewListeners);
        }
        TicketViewTree.onPossibleChange(changedListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onPossibleChange(SubViewGroupingDefinition grouping) {
        ArrayList<ViewListener> changedListeners = new ArrayList<ViewListener>();
        Map<String, ViewUpdateListener> map = this.clients;
        synchronized (map) {
            for (ViewListener listener : this.viewListeners) {
                if (listener.grouping != grouping) continue;
                changedListeners.add(listener);
            }
        }
        TicketViewTree.onPossibleChange(changedListeners);
    }

    private static void onPossibleChange(@Nonnull List<ViewListener> changedListeners) {
        ForkJoinPool.commonPool().execute(() -> {
            for (ViewListener listener : changedListeners) {
                listener.onPossibleChange();
            }
        });
    }

    private static void sortViews(List<TicketViewFactory> views, List<TicketViewVisibility> order) {
        LinkedHashMap<String, ArrayList<TicketViewFactory>> map = new LinkedHashMap<String, ArrayList<TicketViewFactory>>();
        block0: for (TicketViewVisibility visibility : order) {
            String id = visibility.getId();
            Iterator<TicketViewFactory> it = views.iterator();
            while (it.hasNext()) {
                TicketViewFactory view = it.next();
                if (!Objects.equals(id, view.getID())) continue;
                if (visibility.isVisible()) {
                    ArrayList<TicketViewFactory> list = (ArrayList<TicketViewFactory>)map.get(view.getCategoryKey());
                    if (list == null) {
                        list = new ArrayList<TicketViewFactory>();
                        map.put(view.getCategoryKey(), list);
                    }
                    list.add(view);
                }
                it.remove();
                continue block0;
            }
        }
        Iterator<TicketViewFactory> it = views.iterator();
        while (it.hasNext()) {
            TicketViewFactory view = it.next();
            ArrayList<TicketViewFactory> list = (ArrayList<TicketViewFactory>)map.get(view.getCategoryKey());
            if (list == null) {
                list = new ArrayList<TicketViewFactory>();
                map.put(view.getCategoryKey(), list);
            }
            list.add(view);
            it.remove();
        }
        for (List list : map.values()) {
            views.addAll(list);
        }
    }

    private void addFactoryAt(int idx, TicketViewFactory factory, @Nonnull SearchCommand searchCommand) {
        SearchCommand unreadSearchCommandForPossibleChangeDetection = factory.createSearchCommand(this.accountID, ClientLocale.getThreadLocale(), this.engine);
        unreadSearchCommandForPossibleChangeDetection.getSearchExpression().add((SearchExpression)UNREAD_ENDUSER);
        if (HDUsersAndGroups.isSupporter()) {
            unreadSearchCommandForPossibleChangeDetection.getSearchExpression().add((SearchExpression)UNREAD_SUPPORTER);
        }
        ViewListener listener = new ViewListener(factory, searchCommand, unreadSearchCommandForPossibleChangeDetection);
        this.engine.addSearchResultListener((SearchResultListener)listener);
        this.viewListeners.add(idx, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeClient(@Nonnull String clientID) {
        this.unregisterTicketList(clientID);
        Map<String, ViewUpdateListener> map = this.clients;
        synchronized (map) {
            this.clients.remove(clientID);
            if (this.clients.size() == 0) {
                for (ViewListener listener : this.viewListeners) {
                    this.engine.removeSearchResultListener((SearchResultListener)listener);
                }
                this.viewListeners.clear();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerTicketList(@Nonnull String clientID, TicketListUpdateListener updateListener, TicketListState state) throws IllegalStateException {
        BaseTicketListChangeMonitor oldChangeMonitor;
        TicketViewSearchCommandFactory factory = this.getTicketViewSearchFactory(updateListener.getViewID());
        if (factory == null) {
            throw new IllegalStateException("Unknown view ID: " + updateListener.getViewID());
        }
        TicketListChangeMonitor newChangeMonitor = new TicketListChangeMonitor(clientID, updateListener, state, factory, this.engine, this.showBunId ? this.slaveInfoEngine : null);
        Map<String, BaseTicketListChangeMonitor> map = this.ticketLists;
        synchronized (map) {
            oldChangeMonitor = this.ticketLists.put(clientID, newChangeMonitor);
        }
        TicketViewTicketEventListener.getInstance().register(newChangeMonitor);
        TicketViewTree.unregisterChangeMonitor(oldChangeMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterTicketList(@Nonnull String clientID) {
        BaseTicketListChangeMonitor changeMonitor;
        Map<String, BaseTicketListChangeMonitor> map = this.ticketLists;
        synchronized (map) {
            changeMonitor = this.ticketLists.remove(clientID);
            if (changeMonitor != null && changeMonitor.getClass() == BaseTicketListChangeMonitor.class) {
                this.ticketLists.put(clientID, changeMonitor);
                return;
            }
        }
        TicketViewTree.unregisterChangeMonitor(changeMonitor);
    }

    private static void unregisterChangeMonitor(BaseTicketListChangeMonitor changeMonitor) {
        if (changeMonitor instanceof TicketListChangeMonitor) {
            TicketListChangeMonitor monitor = (TicketListChangeMonitor)changeMonitor;
            monitor.stop();
            TicketViewTicketEventListener.getInstance().unregister(monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    BaseTicketListChangeMonitor getChangeMonitor(@Nonnull String clientID) {
        Map<String, BaseTicketListChangeMonitor> map = this.ticketLists;
        synchronized (map) {
            return this.ticketLists.get(clientID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTicketListState(String clientID, TicketListState state) {
        ViewUpdateListener viewUpdateListener;
        String phrase;
        BaseTicketListChangeMonitor changeMonitor = this.getChangeMonitor(clientID);
        if (changeMonitor == null) {
            changeMonitor = new BaseTicketListChangeMonitor(new TicketListState("", 10, "", false), GlobalSearchViewDefinition.INSTANCE);
            Map<String, BaseTicketListChangeMonitor> map = this.ticketLists;
            synchronized (map) {
                this.ticketLists.put(clientID, changeMonitor);
            }
        }
        if (StringFunctions.isEmpty((String)(phrase = state.getSearchPhrase())) && changeMonitor.getFactory() == GlobalSearchViewDefinition.INSTANCE) {
            TicketViewTree.unregisterChangeMonitor(changeMonitor);
            changeMonitor = new BaseTicketListChangeMonitor(changeMonitor.getTicketListState(), GlobalSearchViewDefinition.INSTANCE);
            Map<String, BaseTicketListChangeMonitor> map = this.ticketLists;
            synchronized (map) {
                this.ticketLists.put(clientID, changeMonitor);
            }
        }
        TicketListState oldState = changeMonitor.getTicketListState();
        changeMonitor.setTicketListState(state);
        String oldPhrase = oldState.getSearchPhrase();
        if (Objects.equals(oldPhrase, phrase)) {
            return;
        }
        Map<String, ViewUpdateListener> map = this.clients;
        synchronized (map) {
            viewUpdateListener = this.clients.get(clientID);
        }
        if (viewUpdateListener == null) {
            HDLogger.debug("viewUpdateListener was null for " + clientID);
            return;
        }
        if (StringFunctions.isEmpty((String)phrase) || StringFunctions.isEmpty((String)oldPhrase)) {
            Collection<TicketViewState> states = this.getStates(clientID);
            this.eventDispatcher.dispatchEvent(() -> viewUpdateListener.viewStructureChanged(states));
        } else {
            TicketViewState viewState = this.getSearchState(clientID, phrase);
            this.eventDispatcher.dispatchEvent(() -> viewUpdateListener.viewContentChanged(viewState));
        }
    }

    @Nullable
    TicketViewSearchCommandFactory getTicketViewSearchFactory(String id) {
        if (id.equals("globalticketsearch")) {
            return GlobalSearchViewDefinition.INSTANCE;
        }
        for (TicketViewFactory factory : this.viewFactories) {
            if (id.equals(factory.getID())) {
                return factory;
            }
            SubViewGroupingDefinition grouping = factory.getSubViewGrouping();
            if (grouping == null || !id.startsWith(factory.getID() + ".")) continue;
            String subID = id.substring(factory.getID().length() + 1);
            return grouping.getSearchCommandFactory(factory, id, subID);
        }
        return null;
    }

    private boolean sendStructureChanged() {
        for (Map.Entry<String, ViewUpdateListener> entry : this.clients.entrySet()) {
            this.sendStructureChanged(entry.getKey(), entry.getValue());
        }
        return true;
    }

    private void sendStructureChanged(@Nonnull String clientID, @Nonnull ViewUpdateListener viewUpdateListener) {
        Collection<TicketViewState> states = this.getStates(clientID);
        this.eventDispatcher.dispatchEvent(() -> viewUpdateListener.viewStructureChanged(states));
    }

    class ViewListener
    extends SearchResultListener<Integer> {
        private final TicketViewFactory factory;
        private final SearchCommand searchCommand;
        private TicketViewState state;
        private final SubViewGroupingDefinition grouping;
        private final int metaDataVersion;
        private Locale locale;

        ViewListener(@Nonnull TicketViewFactory factory, @Nonnull SearchCommand command, SearchCommand unreadSearchCommand) {
            super(unreadSearchCommand);
            this.factory = factory;
            this.searchCommand = command;
            this.grouping = factory.getSubViewGrouping();
            this.metaDataVersion = factory.getMetaDataVersion();
            this.locale = ClientLocale.getThreadLocale();
        }

        boolean hasChanges(@Nonnull SearchCommand command) {
            return !command.getSearchExpression().equals((Object)this.searchCommand.getSearchExpression());
        }

        TicketViewState getState() {
            if (this.state != null) {
                return this.state;
            }
            this.state = new TicketViewState(this.factory.getID(), -1, -1, this.factory, this.metaDataVersion);
            return this.state;
        }

        protected void onPossibleChange() {
            Locale orig = ClientLocale.getThreadLocale();
            try {
                ClientLocale.setThreadLocale((Locale)this.locale);
                this.onPossibleChangeImpl();
            }
            finally {
                ClientLocale.setThreadLocale((Locale)orig);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onPossibleChangeImpl() {
            int totalUnreadCount;
            Set unreadResult;
            int totalCount;
            if (this.grouping == null) {
                this.searchCommand.setResultLimit(20000);
            }
            long time = System.currentTimeMillis();
            Set result = TicketViewTree.this.engine.simpleSearch(this.searchCommand);
            this.logSlowViews(time);
            if (TicketViewTree.this.showBunId && this.grouping == null) {
                TicketViewTree.this.manager.convertToBunIdsIfNeeded(TicketViewTree.this.slaveInfoEngine, result, TicketViewTree.this.accountID);
            }
            if ((totalCount = result.size()) == 0) {
                unreadResult = null;
                totalUnreadCount = 0;
            } else {
                if (this.grouping == null) {
                    this.searchCommand.setResultLimit(20000);
                }
                time = System.currentTimeMillis();
                unreadResult = TicketViewTree.this.engine.simpleSearch(new SearchCommand(this.locale, new SearchExpression[]{GlobalSearchViewDefinition.getExpressionForUnreadTickets(result, TicketViewTree.this.accountID, this.locale)}));
                this.logSlowViews(time);
                if (TicketViewTree.this.showBunId && this.grouping == null) {
                    TicketViewTree.this.manager.convertToBunIdsIfNeeded(TicketViewTree.this.slaveInfoEngine, unreadResult, TicketViewTree.this.accountID);
                }
                totalUnreadCount = unreadResult.size();
            }
            TicketViewState newState = new TicketViewState(this.factory.getID(), totalCount, totalUnreadCount, this.factory, this.metaDataVersion);
            if (totalCount > 0 && this.grouping != null) {
                this.grouping.appendSubViewStates(newState, this.factory, TicketViewTree.this.accountID, result, totalUnreadCount == 0 ? null : unreadResult, TicketViewTree.this.engine, TicketViewTree.this.showBunId ? TicketViewTree.this.slaveInfoEngine : null);
            }
            TicketViewState oldState = this.state;
            Map<String, ViewUpdateListener> map = TicketViewTree.this.clients;
            synchronized (map) {
                this.state = newState;
                this.sendEventsIfNeeded(oldState, newState, true);
            }
        }

        private boolean sendEventsIfNeeded(@Nullable TicketViewState oldState, @Nullable TicketViewState newState, boolean isRoot) {
            if (oldState == null) {
                if (newState == null) {
                    return false;
                }
                return TicketViewTree.this.sendStructureChanged();
            }
            if (newState == null) {
                return TicketViewTree.this.sendStructureChanged();
            }
            if (newState.hasChanges(oldState) && (!isRoot || this.grouping == null)) {
                for (Map.Entry entry : TicketViewTree.this.clients.entrySet()) {
                    ViewUpdateListener listener = (ViewUpdateListener)entry.getValue();
                    TicketViewTree.this.eventDispatcher.dispatchEvent(() -> listener.viewContentChanged(newState));
                }
            }
            block1: for (TicketViewState ticketViewState : oldState) {
                String oldId = ticketViewState.getID();
                for (TicketViewState newSubState : newState) {
                    if (!oldId.equals(newSubState.getID())) continue;
                    if (!this.sendEventsIfNeeded(ticketViewState, newSubState, false)) continue block1;
                    return true;
                }
                return TicketViewTree.this.sendStructureChanged();
            }
            block3: for (TicketViewState ticketViewState : newState) {
                String newId = ticketViewState.getID();
                for (TicketViewState oldSubState : oldState) {
                    if (!newId.equals(oldSubState.getID())) continue;
                    continue block3;
                }
                return TicketViewTree.this.sendStructureChanged();
            }
            return false;
        }

        private void logSlowViews(long startTime) {
            long time2;
            if (IndexSearchEngine.LOGGER.isWarning() && (time2 = System.currentTimeMillis()) - startTime > 5000L) {
                UserAccount userAccount = UserManager.getInstance().getUserAccount(TicketViewTree.this.accountID);
                IndexSearchEngine.LOGGER.warn((Object)("Slow search took " + (time2 - startTime) + "ms for view: " + String.valueOf(this.factory) + (String)(userAccount != null ? " for user '" + userAccount.getDisplayName() + "'" : "")));
            }
        }
    }
}

