/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager;

import com.inet.config.ConfigValue;
import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.config.EmailAccount;
import com.inet.helpdesk.config.EmailAccountList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.ServerOptions;
import com.inet.helpdesk.core.data.TicketDataConnector;
import com.inet.helpdesk.core.model.ticket.EmailReceiverAdder;
import com.inet.helpdesk.core.model.ticket.Ticket;
import com.inet.helpdesk.core.ticketmanager.ReaStepEmailAddresses;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReaderForSystem;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.ChangedTicketVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEvent;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.mail.reader.EmailReader_Main;
import com.inet.helpdesk.shared.model.DataField;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.shared.model.general.ContextType;
import com.inet.helpdesk.shared.model.user.User;
import com.inet.helpdesk.ticketmanager.TicketReaderImpl;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.UserModelConverter;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroups.user.search.SearchTagActive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class NewTicketDataConnectorImpl
implements TicketDataConnector {
    private static final ConfigValue<String> SPERRLIST = new ConfigValue(HDConfigKeys.SPERRLIST);
    private static TicketReaderImpl ticketReader;
    private ServerPluginManager spm;
    private UserManager userManager;
    protected VersionHandler versionHandler;

    public static void setReaderImpl(TicketReaderImpl reader) {
        ticketReader = reader;
    }

    public void init(UserManager userManager, ServerPluginManager spm) {
        this.userManager = userManager;
        this.spm = spm;
    }

    @Override
    public Ticket getTicket(ContextType context, int ticketId, TicketDataConnector.TicketText ticketText) throws ServerDataException {
        TicketVO cachedTicket = this.getReaderForSystem().getTicket(ticketId);
        if (cachedTicket == null) {
            return null;
        }
        Ticket ticket = this.cachedTicketToTicket(cachedTicket, ticketText == TicketDataConnector.TicketText.INQUIRY);
        if (ticketText == TicketDataConnector.TicketText.LASTSTEP) {
            this.setNewestReastepContentForPreview(context, ticket);
        }
        return ticket;
    }

    private TicketReaderForSystem getReaderForSystem() {
        return TicketManager.getReaderForSystem();
    }

    private Ticket cachedTicketToTicket(TicketVO cachedTicket, boolean includeAuftragsText) {
        Long termin;
        Long timestamp;
        UserAccount editorAccount;
        UserAccount userAccount;
        int ticketId = cachedTicket.getID();
        String subject = cachedTicket.getSubject();
        ReaStepTextVO auftragsText = ticketReader.getReaStepText(cachedTicket.getInitialReaStepID());
        boolean htmlContent = auftragsText.hasHtmlContent();
        String aufText = "";
        if (includeAuftragsText) {
            aufText = auftragsText.getText();
            aufText = aufText != null && aufText.length() > 0 ? (htmlContent ? HtmlConverter.getCompactHtmlText((String)aufText, null) : aufText.trim()) : "";
        }
        if ((subject == null || subject.trim().length() == 0) && aufText.length() > 0) {
            if (htmlContent) {
                subject = HtmlConverter.html2text((String)aufText);
                subject = subject.substring(0, Math.min(50, subject.length()));
            } else {
                subject = aufText.substring(0, Math.min(50, aufText.length()));
            }
        }
        if (subject == null) {
            subject = "";
        } else {
            subject = subject.replace("\r", "").replace("\n", " ").replace("\t", " ").replaceAll("\\s+", " ");
            subject = subject.trim();
        }
        int ticketVersion = this.getVersionHandler().getTicketVersion(ticketId);
        Long lastModifiedDate = cachedTicket.getLastChanged();
        if (ticketVersion < 0) {
            ticketVersion = (int)(lastModifiedDate / 1000L);
        }
        int resID = 0;
        UserGroupInfo resource = null;
        GUID resUUID = cachedTicket.getResourceID();
        if (resUUID != null && (resource = UserGroupManager.getInstance().getGroup(resUUID)) != null) {
            resID = (Integer)resource.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID);
        }
        int prioId = cachedTicket.getPriorityID();
        Ticket ticket = new Ticket(ticketVersion, ticketId, resID, subject, new Date(lastModifiedDate), cachedTicket.getStatusID(), prioId);
        Integer category = cachedTicket.getCategoryID();
        if (category == null) {
            ticket.addData(Field.TICKETDATA_CATEGORYID, 0);
        } else {
            ticket.addData(Field.TICKETDATA_CATEGORYID, category);
        }
        ticket.addData(Field.TICKETDATA_INQUIRYDATE, cachedTicket.getInquiryDate());
        ticket.setHtmlContent(htmlContent);
        ticket.addData(Field.TICKETDATA_PREVIEW, aufText);
        User ticketOwner = null;
        GUID userID = cachedTicket.getOwnerID();
        UserAccount userAccount2 = userAccount = userID == null ? null : UserManager.getInstance().getUserAccount(userID);
        if (userAccount == null) {
            ticketOwner = new User();
            ticketOwner.addData(new DataField(Field.USERDATA_USERID, (Object)-1));
            ticketOwner.addData(new DataField(Field.USERDATA_USERNAME, (Object)"Admin"));
            ticketOwner.addData(new DataField(Field.USERDATA_DISPLAYNAME, (Object)"Admin"));
        } else {
            ticketOwner = UserModelConverter.convertUserAccount(userAccount);
        }
        ticket.addData(Field.TICKETDATA_OWNER, ticketOwner);
        GUID editor = cachedTicket.getLastEditorID();
        String lastEditor = null;
        if (editor != null && (editorAccount = this.userManager.getUserAccount(editor)) != null) {
            lastEditor = editorAccount.getDisplayName();
        }
        if (lastEditor == null && ticketOwner != null) {
            lastEditor = ticketOwner.getDisplayName();
        }
        ticket.addData(Field.TICKETDATA_LASTTEXTEDITOR, lastEditor);
        ticket.addData(Field.TICKETDATA_REQUESTMAILACCOUNT, cachedTicket.getEmailEingang());
        int sumTimes = cachedTicket.getSumTime();
        if (sumTimes > 0) {
            ticket.addData(Field.TICKETDATA_SUMTIMES, sumTimes);
        }
        ticket.addData(Field.TICKETDATA_TICKETFIELD1, cachedTicket.getCustom1());
        ticket.addData(Field.TICKETDATA_TICKETFIELD2, cachedTicket.getCustom2());
        ticket.addData(Field.TICKETDATA_TICKETFIELD3, cachedTicket.getCustom3());
        ticket.addData(Field.TICKETDATA_TICKETFIELD4, cachedTicket.getCustom4());
        ticket.addData(Field.TICKETDATA_TICKETFIELD5, cachedTicket.getCustom5());
        ticket.addData(Field.TICKETDATA_TICKETFIELD6, cachedTicket.getCustom6());
        ticket.addData(Field.TICKETDATA_TICKETFIELD7, cachedTicket.getCustom7());
        ticket.addData(Field.TICKETDATA_SPECIALFIELD, cachedTicket.getIdentifier());
        ticket.addData(Field.TICKETDATA_CLASSIFICATIONID, cachedTicket.getClassificationID());
        ticket.addData(Field.TICKETDATA_ITILID, cachedTicket.getItilID());
        if (resource != null) {
            ticket.addData(Field.TICKETDATA_RESOURCEID_DISPLAYNAME, resource.getDisplayName());
        } else {
            ticket.addData(Field.TICKETDATA_RESOURCEID_DISPLAYNAME, "");
        }
        Integer dueTime = cachedTicket.getTargetTime();
        if (dueTime != null) {
            ticket.addData(Field.TICKETDATA_DUETIME, dueTime);
        }
        if ((timestamp = cachedTicket.getDeadline()) != null) {
            ticket.addData(Field.TICKETDATA_DEADLINE, new Date(timestamp));
        }
        if ((termin = cachedTicket.getAttribute(Tickets.ATTRIBUTE_TERMINVEREINBARUNG)) != null) {
            ticket.addData(Field.TICKETDATA_TERMINVEREINBARUNG, new Date(termin));
        }
        ticket.addData(Field.TICKETDATA_HASATTACHMENTS, cachedTicket.hasAttachments());
        ticket.addData(Field.TICKETDATA_MASTERTICKET, cachedTicket.isMasterInBundle() || cachedTicket.isUnbundled());
        ticket.addData(Field.TICKETDATA_HASSUBTICKETS, cachedTicket.isMasterInBundle() && !cachedTicket.isUnbundled());
        return ticket;
    }

    private void setNewestReastepContentForPreview(ContextType context, List<Ticket> tickets) throws ServerDataException {
        for (Ticket ticket : tickets) {
            this.setNewestReastepContentForPreview(context, ticket);
        }
    }

    private void setNewestReastepContentForPreview(ContextType context, Ticket ticket) throws ServerDataException {
        ReaStepTextVO auftragsText;
        String subject;
        int ticketID = ticket.getId();
        Function<ReaStepVO, Boolean> statusFilter = reaStep -> {
            int actionID = reaStep.getActionID();
            ActionVO action = (ActionVO)ActionManager.getInstance().get(actionID);
            return action.getStatusID() == 0 || action.getStatusID() >= 100;
        };
        List<ReaStepVO> steps = this.findReaSteps(ticketID, statusFilter, context);
        Collections.sort(steps, (o1, o2) -> o2.getID() - o1.getID());
        TicketVO cachedTicket = this.getReaderForSystem().getTicket(ticket.getId());
        int anfReaId = cachedTicket.getInitialReaStepID();
        boolean hasPreviewText = false;
        Object reaStepContent = null;
        for (ReaStepVO cachedReaStep : steps) {
            ReaStepTextVO reaStepText = ticketReader.getReaStepText(cachedReaStep.getID());
            reaStepContent = reaStepText.getText();
            boolean isHtml = reaStepText.hasHtmlContent();
            if (reaStepText.isEmpty() && cachedReaStep.getID() != anfReaId) continue;
            if (cachedReaStep.getID() == anfReaId) {
                ReaStepTextVO auftragsText2 = ticketReader.getReaStepText(cachedTicket.getInitialReaStepID());
                reaStepContent = auftragsText2.getText();
                isHtml = auftragsText2.hasHtmlContent();
            }
            ticket.setHtmlContent(isHtml);
            if (reaStepContent == null) {
                reaStepContent = "";
            }
            if (isHtml && ((String)reaStepContent).length() < 10000) {
                reaStepContent = HtmlConverter.getCompactHtmlText((String)reaStepContent, null);
            }
            if (isHtml) {
                int styleTagStart = ((String)reaStepContent).indexOf("<style>");
                int styleTagEnd = ((String)reaStepContent).indexOf("</style>", styleTagStart);
                if (styleTagStart >= 0 && styleTagEnd >= 0) {
                    String prefix = ((String)reaStepContent).substring(0, styleTagStart);
                    String styleTag = ((String)reaStepContent).substring(styleTagStart, styleTagEnd);
                    String suffix = ((String)reaStepContent).substring(styleTagEnd);
                    styleTag = styleTag.replaceAll("\t", " ");
                    styleTag = styleTag.replaceAll("\n", " ");
                    styleTag = styleTag.replaceAll("\r", " ");
                    reaStepContent = prefix + styleTag + suffix;
                }
            }
            ticket.setData(Field.TICKETDATA_PREVIEW, reaStepContent);
            hasPreviewText = true;
            ArrayList<DataField> data = ticket.getData();
            if (!data.stream().noneMatch(d -> d.getField() == Field.TICKETDATA_LASTTEXTEDITOR)) break;
            GUID userID = cachedReaStep.getUserID();
            if (userID != null) {
                UserAccount account = UserManager.getInstance().getUserAccount(userID);
                if (account == null) break;
                ticket.setData(Field.TICKETDATA_LASTTEXTEDITOR, account.getDisplayName());
                break;
            }
            if (!StringFunctions.isEmpty((String)cachedReaStep.getDisplayName())) {
                ticket.setData(Field.TICKETDATA_LASTTEXTEDITOR, cachedReaStep.getDisplayName());
                break;
            }
            ticket.setData(Field.TICKETDATA_LASTTEXTEDITOR, Tickets.MSG.getMsg("lasteditor.automated", new Object[0]));
            break;
        }
        if (!hasPreviewText) {
            ReaStepTextVO auftragsText3 = ticketReader.getReaStepText(cachedTicket.getInitialReaStepID());
            reaStepContent = auftragsText3.getText();
            boolean htmlContent = auftragsText3.hasHtmlContent();
            ticket.setHtmlContent(htmlContent);
            if (reaStepContent == null) {
                reaStepContent = "";
            }
            if (htmlContent && ((String)reaStepContent).length() < 10000) {
                reaStepContent = HtmlConverter.getCompactHtmlText((String)reaStepContent, null);
            }
            reaStepContent = ((String)reaStepContent).replaceAll("\t", " ");
            reaStepContent = ((String)reaStepContent).replaceAll("\n", " ");
            reaStepContent = ((String)reaStepContent).replaceAll("\r", " ");
            ticket.setData(Field.TICKETDATA_PREVIEW, reaStepContent);
            GUID textEditor = cachedTicket.getLastEditorID();
            if (textEditor != null) {
                UserAccount userAccount = this.userManager.getUserAccount(textEditor);
                ticket.setData(Field.TICKETDATA_LASTTEXTEDITOR, userAccount.getDisplayName());
            }
        }
        if (((subject = ticket.getValue(Field.TICKETDATA_SUBJECT, String.class)) == null || subject.trim().length() == 0) && reaStepContent != null && ((String)reaStepContent).length() > 0 && (auftragsText = ticketReader.getReaStepText(cachedTicket.getInitialReaStepID())) != null) {
            subject = this.generateSubjectFromAuftragsText(auftragsText.getText(), auftragsText.hasHtmlContent());
            ticket.setData(Field.TICKETDATA_SUBJECT, subject);
        }
    }

    private String generateSubjectFromAuftragsText(String text, boolean isHtml) {
        String subject;
        if (isHtml) {
            subject = HtmlConverter.html2text((String)text);
            subject = subject.substring(0, Math.min(50, subject.length()));
        } else {
            subject = text.substring(0, Math.min(50, text.length()));
        }
        subject = subject.replace("\r", "").replace("\n", " ").replace("\t", " ").replaceAll("\\s+", " ");
        subject = subject.trim();
        return subject;
    }

    private List<ReaStepVO> findReaSteps(int ticketId, Function<ReaStepVO, Boolean> filter, ContextType context) throws ServerDataException {
        if (!TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticketId).hasAnyAccessToTicket()) {
            return Collections.emptyList();
        }
        boolean includeSystemSteps = context == ContextType.supporter;
        try {
            List<ReaStepVO> steps = TicketManager.getReader().getReaStepsForTicket(ticketId, BundleStepsFilter.WITH_BUNDLE_STEPS);
            steps.removeIf(stepVo -> (Boolean)filter.apply((ReaStepVO)stepVo) == false);
            if (!includeSystemSteps) {
                steps.removeIf(s -> ((ActionVO)ActionManager.getInstance().get(s.getActionID())).isHidden());
            }
            return steps;
        }
        catch (AccessDeniedException | IllegalArgumentException ex) {
            throw new ServerDataException((Exception)ex);
        }
    }

    private UserAccount getCurrentUserAccountOrThrow() throws ServerDataException {
        UserAccount account = UserManager.getInstance().getCurrentUserAccount();
        if (account == null) {
            throw new ServerDataException(new IllegalStateException("No user is logged in."));
        }
        return account;
    }

    private String @Nonnull [] convertMailsToAddressArray(String mailString) {
        if (mailString != null && mailString.length() > 0) {
            if (mailString.indexOf(59) > -1) {
                StringTokenizer emailTokens = new StringTokenizer(mailString, ";");
                Vector<String> allAdresses = new Vector<String>();
                while (emailTokens.hasMoreTokens()) {
                    allAdresses.addElement(emailTokens.nextToken().trim());
                }
                if (allAdresses.size() > 0) {
                    return allAdresses.toArray(new String[allAdresses.size()]);
                }
            } else {
                mailString = mailString.trim();
                return new String[]{mailString};
            }
        }
        return new String[0];
    }

    private EmailAccountList getMailAccounts() throws ServerDataException {
        return (EmailAccountList)EmailReader_Main.MAIL_ACCOUNTS.get();
    }

    @Override
    public ArrayList<User> getReceivers(Ticket ticket, TicketDataConnector.RECEIVERTYP receiverType, boolean answerAll) throws ServerDataException {
        String email;
        Integer resourceIDValue;
        int resourceId;
        UserGroupInfo res;
        EmailAccountList mailAccounts;
        ArrayList<User> receivers = new ArrayList<User>();
        List adders = this.spm.get(EmailReceiverAdder.class);
        for (EmailReceiverAdder adder : adders) {
            adder.addReceivers(receivers, ticket, receiverType.ordinal(), answerAll);
        }
        if (receiverType == TicketDataConnector.RECEIVERTYP.CC && !answerAll) {
            return receivers;
        }
        if (ServerOptions.isOptionSet(524288)) {
            return receivers;
        }
        HashSet<String> usedAddresses = new HashSet<String>();
        User ticketOwner = ticket.getValue(Field.TICKETDATA_OWNER, User.class);
        String[] emails = ticketOwner.getValue(Field.USERDATA_EMAIL, String[].class);
        if (emails != null && emails.length > 0) {
            boolean firstEmailAdded = false;
            for (String firstMail : emails) {
                if (firstMail.isEmpty()) continue;
                usedAddresses.add(firstMail.toLowerCase());
                if (firstEmailAdded) continue;
                firstEmailAdded = true;
                receivers.add(ticketOwner);
            }
        }
        if (!answerAll) {
            return receivers;
        }
        List<ReaStepEmailAddresses> reaStepReceivers = ticketReader.getReaStepEmailAddresses(ticket.getId());
        for (ReaStepEmailAddresses receiver : reaStepReceivers) {
            if (receiverType == TicketDataConnector.RECEIVERTYP.TO || receiverType == TicketDataConnector.RECEIVERTYP.ALL) {
                this.checkAndAddEmailAddresses(receivers, usedAddresses, receiver.getEmailIn());
                this.checkAndAddEmailAddresses(receivers, usedAddresses, receiver.getEmailAn());
                continue;
            }
            if (receiverType != TicketDataConnector.RECEIVERTYP.CC && receiverType != TicketDataConnector.RECEIVERTYP.ALL) continue;
            this.checkAndAddEmailAddresses(receivers, usedAddresses, receiver.getEmailCC());
        }
        ArrayList<String> blockedList = new ArrayList<String>();
        String blockedMails = (String)SPERRLIST.get();
        this.addMailList(blockedList, blockedMails);
        UserAccount account = this.getCurrentUserAccountOrThrow();
        User currentUser = UserModelConverter.convertUserAccount(account);
        String[] userEmails = currentUser.getValue(Field.USERDATA_EMAIL, String[].class);
        if (userEmails != null && userEmails.length > 0) {
            for (String supporterMail : userEmails) {
                if (supporterMail == null || supporterMail.trim().length() <= 0) continue;
                blockedList.add(supporterMail.trim().toLowerCase());
            }
        }
        if ((mailAccounts = this.getMailAccounts()) != null && mailAccounts.size() > 0) {
            for (EmailAccount mAccount : mailAccounts) {
                this.addMailList(blockedList, mAccount.getFrom());
            }
        }
        if ((res = HDUsersAndGroups.getResource(resourceId = (resourceIDValue = ticket.getValue(Field.TICKETDATA_RESOURCEID, Integer.class)) == null ? 0 : resourceIDValue)) != null && (email = (String)res.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_EMAIL)) != null && email.length() > 0) {
            User user = new User();
            user.addData(Field.USERDATA_USERNAME, res.getDisplayName());
            user.addData(Field.USERDATA_DISPLAYNAME, res.getDisplayName());
            String[] mails = this.convertMailsToAddressArray(email);
            if (mails != null) {
                for (String mail : mails) {
                    blockedList.add(mail.trim().toLowerCase());
                }
            }
        }
        if (blockedList.size() > 0) {
            receivers = this.filterReceivers(receivers, blockedList, ticketOwner);
        }
        return receivers;
    }

    private void checkAndAddEmailAddresses(ArrayList<User> receivers, HashSet<String> usedAddresses, String emailAddress) throws ServerDataException {
        if (emailAddress != null && emailAddress.length() > 5) {
            String[] adressen;
            for (String currentAddress : adressen = this.convertMailsToAddressArray(emailAddress)) {
                if (currentAddress == null || currentAddress.length() <= 5 || usedAddresses.contains(currentAddress.toLowerCase())) continue;
                User user = this.findUserForEmail(currentAddress);
                if (user == null) {
                    String displayname = currentAddress;
                    String email = currentAddress;
                    String uname = currentAddress;
                    int indexOf = email.indexOf(60);
                    if (indexOf >= 0) {
                        displayname = email.substring(0, indexOf).trim();
                        int lastIndex = email.lastIndexOf(62);
                        if (lastIndex > indexOf) {
                            if (usedAddresses.contains((email = email.substring(indexOf + 1, lastIndex).trim()).toLowerCase())) continue;
                            user = this.findUserForEmail(email);
                        }
                    }
                    if ((indexOf = email.indexOf(64)) > 0) {
                        uname = email.substring(0, indexOf);
                        if (email.equals(displayname)) {
                            displayname = uname;
                        }
                    }
                    if (user == null) {
                        user = new User();
                        user.addData(Field.USERDATA_USERNAME, uname);
                        user.addData(Field.USERDATA_DISPLAYNAME, displayname);
                        user.addData(Field.USERDATA_EMAIL, new String[]{email});
                        usedAddresses.add(email.toLowerCase());
                    }
                }
                receivers.add(user);
                usedAddresses.add(currentAddress.toLowerCase());
            }
        }
    }

    private User findUserForEmail(String currentAddress) {
        AndSearchExpression and = new AndSearchExpression();
        SearchCondition emailCond = new SearchCondition("email", SearchCondition.SearchTermOperator.Equals, (Object)currentAddress.toLowerCase());
        SearchCondition validCond = new SearchCondition("active", SearchCondition.SearchTermOperator.Equals, (Object)("" + SearchTagActive.valueAsInt((boolean)true)));
        and.add((SearchExpression)emailCond);
        and.add((SearchExpression)validCond);
        SearchResult results = UserManager.getInstance().search("", (List)and, new ArrayList(), 100, null);
        List resultEntries = results.getEntries();
        if (resultEntries.size() == 0) {
            return null;
        }
        SearchResultEntry userEntry = (SearchResultEntry)resultEntries.get(0);
        UserAccount userAccount = UserManager.getInstance().getUserAccount((GUID)userEntry.getId());
        return UserModelConverter.convertUserAccount(userAccount);
    }

    private ArrayList<User> filterReceivers(ArrayList<User> receivers, List<String> blockedList, User ticketOwner) {
        if (blockedList == null || blockedList.size() == 0) {
            return receivers;
        }
        ArrayList<User> filteredReceivers = new ArrayList<User>();
        for (User emailUser : receivers) {
            String[] emails = emailUser.getValue(Field.USERDATA_EMAIL, String[].class);
            ArrayList<String> filteredMailAddresses = new ArrayList<String>();
            Integer emailUserID = emailUser.getValue(Field.USERDATA_USERID, Integer.class);
            if (ticketOwner != null && emailUserID != null && emailUserID.intValue() == ticketOwner.getUserID()) {
                for (String email : emails) {
                    filteredMailAddresses.add(email);
                }
                if (filteredMailAddresses.size() <= 0) continue;
                emailUser.setData(Field.USERDATA_EMAIL, filteredMailAddresses.toArray(new String[filteredMailAddresses.size()]));
                filteredReceivers.add(emailUser);
                continue;
            }
            for (String email : emails) {
                boolean blocked = false;
                for (String blockedPart : blockedList) {
                    String quotedPattern = Pattern.quote(blockedPart.toLowerCase());
                    quotedPattern = quotedPattern.replace("*", "\\E.*\\Q");
                    if (!email.toLowerCase().matches("^" + quotedPattern + "$")) continue;
                    blocked = true;
                    break;
                }
                if (blocked) continue;
                filteredMailAddresses.add(email);
            }
            if (filteredMailAddresses.size() <= 0) continue;
            emailUser.setData(Field.USERDATA_EMAIL, filteredMailAddresses.toArray(new String[filteredMailAddresses.size()]));
            filteredReceivers.add(emailUser);
        }
        return filteredReceivers;
    }

    private void addMailList(List<String> blockedList, String blockedMails) {
        if (blockedMails != null && blockedMails.length() > 0) {
            String[] parts;
            for (String part : parts = blockedMails.split(";")) {
                if ((part = part.trim()).length() <= 0) continue;
                blockedList.add(part.trim().toLowerCase());
            }
        }
    }

    public TicketEventListener getTicketEventListener() {
        return this.getVersionHandler();
    }

    private VersionHandler getVersionHandler() {
        if (this.versionHandler == null) {
            this.versionHandler = new VersionHandler();
        }
        return this.versionHandler;
    }

    private class VersionHandler
    implements TicketEventListener {
        private Map<Integer, Long> checkedVersions = new HashMap<Integer, Long>();

        private VersionHandler() {
        }

        @Override
        public void handleEvent(TicketEvent event) {
            for (ChangedTicketVO changed : event.getChangedTickets()) {
                this.checkedVersions.put(changed.getTicketID(), System.currentTimeMillis());
            }
        }

        private int getTicketVersion(int ticketId) {
            Long value = this.checkedVersions.get(ticketId);
            if (value != null) {
                return (int)(value / 1000L);
            }
            return 0;
        }
    }
}

