/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.argcontainers;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class DuplicateRange {
    private int from;
    private int to;
    private Set<Integer> ids;
    private GUID uid;

    private DuplicateRange() {
    }

    public DuplicateRange(int from, int to, Set<Integer> ids, @Nullable GUID uid) {
        this.from = from;
        this.to = to;
        this.ids = ids;
        this.uid = uid;
    }

    public GUID getUid() {
        return this.uid;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    @Nonnull
    public HashSet<Integer> getIds() {
        return new HashSet<Integer>(this.ids != null ? this.ids : Collections.emptySet());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.from;
        result = 31 * result + (this.ids == null ? 0 : this.ids.hashCode());
        result = 31 * result + this.to;
        result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DuplicateRange other = (DuplicateRange)obj;
        if (this.from != other.from) {
            return false;
        }
        if (this.ids == null ? other.ids != null : !this.ids.equals(other.ids)) {
            return false;
        }
        if (this.to != other.to) {
            return false;
        }
        return !(this.uid == null ? other.uid != null : !this.uid.equals((Object)other.uid));
    }
}

