/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fields.usergroup;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.GenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassVO;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class UserClassManager
extends GenericFieldsManager<UserClassVO> {
    private static final String LIST_SUPERVISORS = "SELECT UsrID, BgrID, ImpName FROM tblBGSuperUser";
    private static final String REMOVE_SUPERVISOR_FROM_LIST = "DELETE FROM tblBGSuperUser WHERE UsrID = ? AND BgrID = ?";
    private static final String UPDATE_SUPERVISOR_SOURCE = "UPDATE tblBGSuperUser SET ImpName = ? WHERE UsrID = ? AND BgrID = ?";
    private static final String INSERT_SUPERVISOR = "INSERT INTO tblBGSuperUser(UsrID,BgrID,ImpName) VALUES(?, ?, ?)";
    private static UserClassManager manager = new UserClassManager();
    private Map<Integer, List<SupervisorMemberShip>> supervisorToGroup = new HashMap<Integer, List<SupervisorMemberShip>>();

    UserClassManager() {
        super(UserClassVO.class, "tblBenutzerGruppe");
    }

    public static UserClassManager getInstance() {
        return manager;
    }

    @Override
    protected void addDefaultData(Map<Integer, UserClassVO> map) {
        super.addDefaultData(map);
        HashMap<Integer, List<SupervisorMemberShip>> newSupervisorToGroup = new HashMap<Integer, List<SupervisorMemberShip>>();
        ConnectionFactory factory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        try (Connection con = factory.getConnection();
             Statement stm = con.createStatement();
             ResultSet rs = stm.executeQuery(LIST_SUPERVISORS);){
            while (rs.next()) {
                int userID = rs.getInt(1);
                int groupID = rs.getInt(2);
                String importName = rs.getString(3);
                ArrayList<SupervisorMemberShip> groups = (ArrayList<SupervisorMemberShip>)newSupervisorToGroup.get(userID);
                if (groups == null) {
                    groups = new ArrayList<SupervisorMemberShip>();
                    newSupervisorToGroup.put(userID, groups);
                }
                groups.add(new SupervisorMemberShip(userID, groupID, importName));
            }
        }
        catch (SQLException e1) {
            throw new IllegalStateException(e1);
        }
        this.supervisorToGroup = newSupervisorToGroup;
    }

    @Nonnull
    public List<UserClassVO> getTeamsWhereUserIsSupervisor(GUID userID) {
        return this.getTeamsWhereUserIsSupervisor(HDUsersAndGroups.getUserID(userID));
    }

    @Nonnull
    public List<UserClassVO> getTeamsWhereUserIsSupervisor(int userID) {
        this.checkInitialization();
        List<SupervisorMemberShip> groupMemberShips = this.supervisorToGroup.get(userID);
        if (groupMemberShips == null) {
            return new ArrayList<UserClassVO>(0);
        }
        return groupMemberShips.stream().map(gms -> (UserClassVO)this.get(gms.getTeamID())).filter(g -> g != null && !g.isDeleted()).collect(Collectors.toList());
    }

    @Override
    public URL getIcon(int id, int size) {
        UserClassVO userGroup = (UserClassVO)this.get(id);
        if (userGroup == null || userGroup.isDeleted()) {
            return this.resolveImageURL("delete_16.gif", size);
        }
        return this.resolveImageURL("benutzergr_16.gif", size);
    }

    public List<SupervisorMemberShip> getAllSupervisorMemberShips() {
        ArrayList<SupervisorMemberShip> supervisorGroupMemberShips = new ArrayList<SupervisorMemberShip>();
        for (Map.Entry<Integer, List<SupervisorMemberShip>> userMemberShips : this.supervisorToGroup.entrySet()) {
            supervisorGroupMemberShips.addAll((Collection<SupervisorMemberShip>)userMemberShips.getValue());
        }
        return supervisorGroupMemberShips;
    }

    public void addOrUpdateSupervisorMemberShip(int userID, int teamID, String source) {
        List<SupervisorMemberShip> userSupervisorMemberShips = this.supervisorToGroup.get(userID);
        if (userSupervisorMemberShips == null) {
            userSupervisorMemberShips = new ArrayList<SupervisorMemberShip>();
            this.supervisorToGroup.put(userID, userSupervisorMemberShips);
        }
        for (SupervisorMemberShip sms : userSupervisorMemberShips) {
            if (sms.getTeamID() != teamID || sms.getUserID() != userID) continue;
            if (!UserClassManager.empty(source) && source.equals(sms.getSource()) || UserClassManager.empty(source) && UserClassManager.empty(sms.getSource())) {
                HDLogger.warn("Supervisor Membership already defined " + userID + " from group " + teamID + " source " + source);
            } else {
                ConnectionFactory factory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
                try (Connection con = factory.getConnection();
                     PreparedStatement pst = con.prepareStatement(UPDATE_SUPERVISOR_SOURCE);){
                    pst.setString(1, source);
                    pst.setInt(2, userID);
                    pst.setInt(3, teamID);
                    pst.execute();
                    sms.source = source;
                }
                catch (SQLException e1) {
                    throw new IllegalStateException(e1);
                }
            }
            return;
        }
        ConnectionFactory factory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        try (Connection con = factory.getConnection();
             PreparedStatement pst = con.prepareStatement(INSERT_SUPERVISOR);){
            pst.setInt(1, userID);
            pst.setInt(2, teamID);
            pst.setString(3, source);
            pst.execute();
            userSupervisorMemberShips.add(new SupervisorMemberShip(userID, teamID, source));
        }
        catch (SQLException e1) {
            throw new IllegalStateException(e1);
        }
    }

    public void removeSupervisorMemberShip(int userID, int teamID) {
        List<SupervisorMemberShip> userSupervisorMemberShips = this.supervisorToGroup.get(userID);
        if (userSupervisorMemberShips != null) {
            for (SupervisorMemberShip sms : userSupervisorMemberShips) {
                if (sms.getTeamID() != teamID) continue;
                ConnectionFactory factory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
                try (Connection con = factory.getConnection();
                     PreparedStatement pst = con.prepareStatement(REMOVE_SUPERVISOR_FROM_LIST);){
                    pst.setInt(1, userID);
                    pst.setInt(2, teamID);
                    pst.execute();
                    userSupervisorMemberShips.remove(sms);
                }
                catch (SQLException e1) {
                    throw new IllegalStateException(e1);
                }
                return;
            }
        }
        HDLogger.error("Could not remove Supervisor " + userID + " from team " + teamID);
    }

    private static boolean empty(String value) {
        return value == null || value.length() == 0;
    }

    public Map<Integer, String> getAllDisplayNames(boolean onlyActiveEntries) {
        return this.getAll(onlyActiveEntries).stream().collect(Collectors.toMap(g -> g.getId(), FieldVO::getDisplayValue));
    }

    public List<SupervisorMemberShip> getSupervisorsOf(int teamId) {
        this.checkInitialization();
        ArrayList<SupervisorMemberShip> result = new ArrayList<SupervisorMemberShip>();
        for (Map.Entry<Integer, List<SupervisorMemberShip>> userMemberShips : this.supervisorToGroup.entrySet()) {
            for (SupervisorMemberShip m : userMemberShips.getValue()) {
                if (m.getTeamID() != teamId) continue;
                result.add(m);
            }
        }
        return result;
    }

    public void cleanUpSuperVisors(int userID) {
        if (userID == -1) {
            return;
        }
        List<UserClassVO> list = this.getTeamsWhereUserIsSupervisor(userID);
        list.stream().forEach(team -> this.removeSupervisorMemberShip(userID, team.getId()));
    }

    public class SupervisorMemberShip {
        private int userID;
        private int teamID;
        private String source;

        private SupervisorMemberShip(int userID, int teamID, String source) {
            this.userID = userID;
            this.teamID = teamID;
            this.source = source;
        }

        public int getUserID() {
            return this.userID;
        }

        public int getTeamID() {
            return this.teamID;
        }

        public String getSource() {
            return this.source;
        }
    }
}

