/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketfieldsettings.config;

import com.inet.annotations.JsonData;
import com.inet.config.ConfigValue;
import com.inet.config.structure.model.BooleanConfigProperty;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.SelectConfigProperty;
import com.inet.config.structure.model.TableConfigProperty;
import com.inet.config.structure.provider.ConditionGenerator2;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.fieldsettings.api.AbstractFieldSettingsManager;
import com.inet.fieldsettings.api.FieldSettingsStructureInfo;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.fieldsettings.structure.GenericFieldSettingsProperty;
import com.inet.fieldsettings.user.model.UserFieldDefinitionNature;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.ticketfieldsettings.ConfigurableMandatoryField;
import com.inet.helpdesk.core.ticketfieldsettings.RegisteredTicketNature;
import com.inet.helpdesk.core.ticketfieldsettings.SqlQuerySelectValueProvider;
import com.inet.helpdesk.core.ticketfieldsettings.TicketFieldSettings;
import com.inet.helpdesk.core.ticketfieldsettings.TicketFieldSettingsManager;
import com.inet.helpdesk.core.ticketmanager.fields.MandatoryFieldVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.SessionStore;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@JsonData
public class TicketFieldSettingsProperty
extends GenericFieldSettingsProperty {
    public static final String PROP_CLASS_LINK_LABEL = "classLink";
    public static final String PROP_CAT_LINK_LABEL = "catLink";
    public static final String PROP_ITIL_LINK_LABEL = "itilLink";
    public static final String PROP_PRIO_LINK_LABEL = "prioLink";
    public static final String PROP_VISIBILITY = "ticketFieldVisibility";
    public static final String PROP_CAN_SET_MANDATORY = "ticketFieldMandatoryAllowed";
    public static final String PROP_EDITABLE_ENDUSER = "ticketFieldEnduserEditable";
    public static final String PROP_EDITABLE_ENDUSER_DEFAULTCHANGE = "ticketFieldEnduserEditableXDefaultChange";
    public static final String PROP_MANDATORY_RESOURCE = "ticketFieldMandatorySupporter";
    public static final String PROP_MANDATORY_DISPATCHER = "ticketFieldMandatoryDispatcher";
    public static final String PROP_DEFAULT_MUST_BE_CHANGED_RESOURCE = "ticketFieldMandatorySupporterDefaultMustbeChanged";
    public static final String PROP_DEFAULT_MUST_BE_CHANGED_DISPATCHER = "ticketFieldMandatoryDispatcherDefaultMustbeChanged";
    private static ConfigValue<String> CONF_IDENTIFIER_SELECTION = new ConfigValue(HDConfigKeys.DEFAULT_IDENTIFIER_SELECTION);

    public TicketFieldSettingsProperty(String key, ConfigStructureSettings settings, AbstractFieldSettingsManager<?, ?> manager) {
        super(key, settings, manager, "TicketFieldSettingsRenderer");
        this.setDuplicatePossible(true);
        this.setManuallySortable(false);
    }

    protected List<Map<String, String>> createListValue(ConfigStructureSettings settings, AbstractFieldSettingsManager<?, ?> manager) {
        List list = super.createListValue(settings, manager);
        Collator collator = Collator.getInstance(ClientLocale.getThreadLocale());
        Collections.sort(list, (m1, m2) -> {
            String source = (String)m1.get("fieldLabel");
            String target = (String)m2.get("fieldLabel");
            return collator.compare(source == null ? "" : source, target == null ? "" : target);
        });
        return list;
    }

    public Map<String, String> createRowPropertiesFor(GenericFieldSetting setting, AbstractFieldSettingsManager<?, ?> manager) {
        Map rowProps = super.createRowPropertiesFor(setting, manager);
        rowProps.put(PROP_CAN_SET_MANDATORY, String.valueOf(setting.isCustom() ? true : ((RegisteredTicketNature)setting.getNature()).getDefinition() instanceof ConfigurableMandatoryField));
        rowProps.putIfAbsent(PROP_VISIBILITY, TicketFieldDefinition.FIELD_VISIBILITY.SUPPORTER.name());
        if (rowProps.containsKey(PROP_EDITABLE_ENDUSER)) {
            rowProps.putIfAbsent(PROP_EDITABLE_ENDUSER_DEFAULTCHANGE, (String)rowProps.get(PROP_EDITABLE_ENDUSER));
        }
        rowProps.putIfAbsent(PROP_EDITABLE_ENDUSER, MandatoryFieldVO.MandatoryType.HIDDEN.name());
        rowProps.putIfAbsent(PROP_EDITABLE_ENDUSER_DEFAULTCHANGE, MandatoryFieldVO.MandatoryType.HIDDEN.name());
        rowProps.putIfAbsent(PROP_MANDATORY_DISPATCHER, "false");
        rowProps.putIfAbsent(PROP_MANDATORY_RESOURCE, "false");
        rowProps.putIfAbsent(PROP_DEFAULT_MUST_BE_CHANGED_RESOURCE, "false");
        rowProps.putIfAbsent(PROP_DEFAULT_MUST_BE_CHANGED_DISPATCHER, "false");
        rowProps.putIfAbsent(PROP_PRIO_LINK_LABEL, this.getPrioSettingsURL());
        rowProps.putIfAbsent(PROP_ITIL_LINK_LABEL, this.getItilSettingsURL());
        rowProps.putIfAbsent(PROP_CAT_LINK_LABEL, this.getCategorySettingsURL());
        rowProps.putIfAbsent(PROP_CLASS_LINK_LABEL, this.getClassificationSettingsURL());
        rowProps.putIfAbsent(HDConfigKeys.DEFAULT_IDENTIFIER_SELECTION.getKey(), "");
        if (setting.getKey().equals(Tickets.FIELD_IDENTIFIER.getKey())) {
            rowProps.put(HDConfigKeys.DEFAULT_IDENTIFIER_SELECTION.getKey(), (String)CONF_IDENTIFIER_SELECTION.get());
        }
        if (TicketFieldSettings.isOpenFieldKey(setting.getKey())) {
            rowProps.put("disableDeleteButton", "true");
        }
        return rowProps;
    }

    protected ConfigRowAction[] createRowActions(ConfigStructureSettings settings, AbstractFieldSettingsManager<?, ?> manager) {
        ConfigRowAction[] rowActions = super.createRowActions(settings, manager);
        FieldSettingsStructureInfo structureInfo = manager.getFieldSettingsStructureInfo();
        List propertyList = (List)rowActions[0].getProperties().get("field.new.group");
        ArrayList conditions = rowActions[0].getConditions();
        ConfigCondition fieldIsPrioOrItilOrBool = ConditionGenerator2.prop((String)"fieldsettingsKey").equalTo((Object)Tickets.FIELD_PRIORITY_ID.getKey()).or(ConditionGenerator2.prop((String)"fieldsettingsKey").equalTo((Object)Tickets.FIELD_ITIL_ID.getKey())).or(ConditionGenerator2.prop((String)"type").equalTo((Object)FieldSettingsType.TYPE_BOOLEAN));
        ConfigCondition isNotResourceId = ConditionGenerator2.not((ConfigCondition)ConditionGenerator2.prop((String)"fieldsettingsKey").equalTo((Object)Tickets.FIELD_RESOURCE_GUID.getKey()));
        ConfigCondition hasDefaultValueSet = new ConfigCondition(ConfigCondition.Operation.Or, new Object[]{ConditionGenerator2.prop((String)"type").equalTo((Object)FieldSettingsType.TYPE_BOOLEAN), ConditionGenerator2.prop((String)"type").equalTo((Object)FieldSettingsType.TYPE_CURRENCY).and(ConditionGenerator2.not((ConfigCondition)ConditionGenerator2.prop((String)"fieldsettingsDefaultValueCurrency").equalTo((Object)""))), ConditionGenerator2.prop((String)"type").equalTo((Object)FieldSettingsType.TYPE_DOUBLE).and(ConditionGenerator2.not((ConfigCondition)ConditionGenerator2.prop((String)"fieldsettingsDefaultValueDouble").equalTo((Object)""))), ConditionGenerator2.prop((String)"type").equalTo((Object)FieldSettingsType.TYPE_MULTILINE_TEXT).and(ConditionGenerator2.not((ConfigCondition)ConditionGenerator2.prop((String)"fieldsettingsDefaultValueTextMulti").equalTo((Object)""))), ConditionGenerator2.prop((String)"type").equalTo((Object)FieldSettingsType.TYPE_NUMBER).and(ConditionGenerator2.not((ConfigCondition)ConditionGenerator2.prop((String)"fieldsettingsDefaultValueInt").equalTo((Object)""))), ConditionGenerator2.prop((String)"type").equalTo((Object)FieldSettingsType.TYPE_TEXT).and(ConditionGenerator2.not((ConfigCondition)ConditionGenerator2.prop((String)"fieldsettingsDefaultValueText").equalTo((Object)""))), ConditionGenerator2.prop((String)"type").equalTo((Object)FieldSettingsType.TYPE_SELECT).and(ConditionGenerator2.not((ConfigCondition)ConditionGenerator2.prop((String)"fieldsettingsDefaultValueSelect").equalTo((Object)"")))});
        ConfigCondition isTypeLink = ConditionGenerator2.prop((String)"type").equalTo((Object)FieldSettingsType.TYPE_LINK.toString());
        conditions.add(ConditionGenerator2.prop((String)PROP_EDITABLE_ENDUSER).visibleIf(ConditionGenerator2.prop((String)PROP_CAN_SET_MANDATORY).equalTo((Object)"true").and(ConditionGenerator2.not((ConfigCondition)isTypeLink)).and(ConditionGenerator2.not((ConfigCondition)hasDefaultValueSet)).and(ConditionGenerator2.not((ConfigCondition)ConditionGenerator2.prop((String)"fieldsettingsKey").equalTo((Object)"ownerid")))));
        conditions.add(ConditionGenerator2.prop((String)PROP_EDITABLE_ENDUSER_DEFAULTCHANGE).visibleIf(ConditionGenerator2.prop((String)PROP_CAN_SET_MANDATORY).equalTo((Object)"true").and(ConditionGenerator2.not((ConfigCondition)isTypeLink)).and(hasDefaultValueSet)));
        conditions.add(ConditionGenerator2.prop((String)PROP_MANDATORY_DISPATCHER).visibleIf(ConditionGenerator2.prop((String)PROP_CAN_SET_MANDATORY).equalTo((Object)"true").and(ConditionGenerator2.not((ConfigCondition)fieldIsPrioOrItilOrBool)).and(ConditionGenerator2.not((ConfigCondition)isTypeLink).and(isNotResourceId))));
        conditions.add(ConditionGenerator2.prop((String)PROP_MANDATORY_RESOURCE).visibleIf(ConditionGenerator2.prop((String)PROP_CAN_SET_MANDATORY).equalTo((Object)"true").and(ConditionGenerator2.not((ConfigCondition)fieldIsPrioOrItilOrBool)).and(ConditionGenerator2.not((ConfigCondition)isTypeLink)).and(isNotResourceId)));
        conditions.add(ConditionGenerator2.prop((String)PROP_DEFAULT_MUST_BE_CHANGED_DISPATCHER).visibleIf(ConditionGenerator2.prop((String)PROP_CAN_SET_MANDATORY).equalTo((Object)"true").and(ConditionGenerator2.not((ConfigCondition)isTypeLink).and(isNotResourceId))));
        conditions.add(ConditionGenerator2.prop((String)PROP_DEFAULT_MUST_BE_CHANGED_RESOURCE).visibleIf(ConditionGenerator2.prop((String)PROP_CAN_SET_MANDATORY).equalTo((Object)"true").and(ConditionGenerator2.not((ConfigCondition)isTypeLink).and(isNotResourceId))));
        conditions.add(ConditionGenerator2.prop((String)PROP_EDITABLE_ENDUSER).enableIf(ConditionGenerator2.not((ConfigCondition)ConditionGenerator2.prop((String)PROP_VISIBILITY).equalTo((Object)TicketFieldDefinition.FIELD_VISIBILITY.HIDDEN.name()))));
        conditions.add(ConditionGenerator2.prop((String)PROP_EDITABLE_ENDUSER_DEFAULTCHANGE).enableIf(ConditionGenerator2.not((ConfigCondition)ConditionGenerator2.prop((String)PROP_VISIBILITY).equalTo((Object)TicketFieldDefinition.FIELD_VISIBILITY.HIDDEN.name()))));
        conditions.add(ConditionGenerator2.prop((String)PROP_MANDATORY_DISPATCHER).enableIf(ConditionGenerator2.not((ConfigCondition)ConditionGenerator2.prop((String)PROP_VISIBILITY).equalTo((Object)TicketFieldDefinition.FIELD_VISIBILITY.HIDDEN.name()))));
        conditions.add(ConditionGenerator2.prop((String)PROP_MANDATORY_RESOURCE).enableIf(ConditionGenerator2.not((ConfigCondition)ConditionGenerator2.prop((String)PROP_VISIBILITY).equalTo((Object)TicketFieldDefinition.FIELD_VISIBILITY.HIDDEN.name()))));
        conditions.add(ConditionGenerator2.prop((String)PROP_DEFAULT_MUST_BE_CHANGED_DISPATCHER).enableIf(ConditionGenerator2.not((ConfigCondition)ConditionGenerator2.prop((String)PROP_VISIBILITY).equalTo((Object)TicketFieldDefinition.FIELD_VISIBILITY.HIDDEN.name())).and(hasDefaultValueSet)));
        conditions.add(ConditionGenerator2.prop((String)PROP_DEFAULT_MUST_BE_CHANGED_RESOURCE).enableIf(ConditionGenerator2.not((ConfigCondition)ConditionGenerator2.prop((String)PROP_VISIBILITY).equalTo((Object)TicketFieldDefinition.FIELD_VISIBILITY.HIDDEN.name())).and(hasDefaultValueSet)));
        conditions.add(ConditionGenerator2.prop((String)HDConfigKeys.DEFAULT_IDENTIFIER_SELECTION.getKey()).visibleIf(ConditionGenerator2.prop((String)"fieldsettingsKey").equalTo((Object)Tickets.FIELD_IDENTIFIER.getKey())));
        conditions.add(ConditionGenerator2.prop((String)PROP_PRIO_LINK_LABEL).visibleIf(ConditionGenerator2.prop((String)"fieldsettingsKey").equalTo((Object)Tickets.FIELD_PRIORITY_ID.getKey())));
        conditions.add(ConditionGenerator2.prop((String)PROP_ITIL_LINK_LABEL).visibleIf(ConditionGenerator2.prop((String)"fieldsettingsKey").equalTo((Object)Tickets.FIELD_ITIL_ID.getKey())));
        conditions.add(ConditionGenerator2.prop((String)PROP_CAT_LINK_LABEL).visibleIf(ConditionGenerator2.prop((String)"fieldsettingsKey").equalTo((Object)Tickets.FIELD_CATEGORY_ID.getKey())));
        conditions.add(ConditionGenerator2.prop((String)PROP_CLASS_LINK_LABEL).visibleIf(ConditionGenerator2.prop((String)"fieldsettingsKey").equalTo((Object)Tickets.FIELD_CLASSIFICATION_ID.getKey())));
        Optional<ConfigProperty> first = propertyList.stream().filter(cp -> cp.getKey().equals("selectstaticoptions")).findFirst();
        int index = propertyList.size();
        if (first.isPresent()) {
            index = propertyList.indexOf(first.get());
            propertyList.remove(index);
        }
        ConfigAction[] emailReadActions = new ConfigAction[]{new ConfigAction(structureInfo.translate("fields.row.selectvalues.add", new Object[0]))};
        List<LocalizedKey> optionsForSelect = List.of(new LocalizedKey("selectForSupporterAndEnduser", TicketFieldSettingsManager.MSG.getMsg("fields.selectOptions.forSupporterAndEnduser", new Object[0])), new LocalizedKey("selectOnlyForSupporter", TicketFieldSettingsManager.MSG.getMsg("fields.selectOptions.forSupporterOnly", new Object[0])));
        TableConfigProperty tableconfig = new TableConfigProperty(1255, "selectstaticoptions", "SimpleTextReloadSelectInputs", structureInfo.translate("fields.row.selectvalues", new Object[0]), "", Collections.emptyList(), new ConfigProperty[]{new ConfigProperty(0, "", "SimpleText", null, null, null, ""), new SelectConfigProperty(0, "", "SimpleText", null, (Object)"selectForSupporterAndEnduser", "", optionsForSelect)}, new int[]{40, 60}, emailReadActions, null);
        tableconfig.setSortable(true);
        propertyList.add(index, tableconfig);
        conditions.add(ConditionGenerator2.prop((String)PROP_EDITABLE_ENDUSER).setValueActionIf(hasDefaultValueSet.and(ConditionGenerator2.prop((String)PROP_EDITABLE_ENDUSER_DEFAULTCHANGE).equalTo((Object)MandatoryFieldVO.MandatoryType.HIDDEN.name())), MandatoryFieldVO.MandatoryType.HIDDEN.name()));
        conditions.add(ConditionGenerator2.prop((String)PROP_EDITABLE_ENDUSER).setValueActionIf(hasDefaultValueSet.and(ConditionGenerator2.prop((String)PROP_EDITABLE_ENDUSER_DEFAULTCHANGE).equalTo((Object)MandatoryFieldVO.MandatoryType.REQUIRED.name())), MandatoryFieldVO.MandatoryType.REQUIRED.name()));
        conditions.add(ConditionGenerator2.prop((String)PROP_EDITABLE_ENDUSER).setValueActionIf(hasDefaultValueSet.and(ConditionGenerator2.prop((String)PROP_EDITABLE_ENDUSER_DEFAULTCHANGE).equalTo((Object)MandatoryFieldVO.MandatoryType.VISIBLE.name())), MandatoryFieldVO.MandatoryType.VISIBLE.name()));
        conditions.add(ConditionGenerator2.prop((String)PROP_EDITABLE_ENDUSER_DEFAULTCHANGE).setValueActionIf(ConditionGenerator2.not((ConfigCondition)hasDefaultValueSet).and(ConditionGenerator2.prop((String)PROP_EDITABLE_ENDUSER).equalTo((Object)MandatoryFieldVO.MandatoryType.HIDDEN.name())), MandatoryFieldVO.MandatoryType.HIDDEN.name()));
        conditions.add(ConditionGenerator2.prop((String)PROP_EDITABLE_ENDUSER_DEFAULTCHANGE).setValueActionIf(ConditionGenerator2.not((ConfigCondition)hasDefaultValueSet).and(ConditionGenerator2.prop((String)PROP_EDITABLE_ENDUSER).equalTo((Object)MandatoryFieldVO.MandatoryType.REQUIRED.name())), MandatoryFieldVO.MandatoryType.REQUIRED.name()));
        conditions.add(ConditionGenerator2.prop((String)PROP_EDITABLE_ENDUSER_DEFAULTCHANGE).setValueActionIf(ConditionGenerator2.not((ConfigCondition)hasDefaultValueSet).and(ConditionGenerator2.prop((String)PROP_EDITABLE_ENDUSER).equalTo((Object)MandatoryFieldVO.MandatoryType.VISIBLE.name())), MandatoryFieldVO.MandatoryType.VISIBLE.name()));
        SqlQuerySelectValueProvider.structure_addPropertiesAndConditionsInRowAction(conditions, propertyList);
        List options = Arrays.stream(TicketFieldDefinition.FIELD_VISIBILITY.values()).map(type -> new LocalizedKey(type.name(), TicketFieldSettingsManager.MSG.getMsg("fields.visibility." + type.name(), new Object[0]))).collect(Collectors.toList());
        propertyList.add(new SelectConfigProperty(0, PROP_VISIBILITY, "SimpleText", TicketFieldSettingsManager.MSG.getMsg("fields.visibility", new Object[0]), (Object)TicketFieldDefinition.FIELD_VISIBILITY.SUPPORTER.name(), "", options));
        List enduseropts = Arrays.stream(MandatoryFieldVO.MandatoryType.values()).map(type -> new LocalizedKey(type.name(), TicketFieldSettingsManager.MSG.getMsg("fields.endusereditable." + type.name(), new Object[0]))).collect(Collectors.toCollection(ArrayList::new));
        propertyList.add(new SelectConfigProperty(0, PROP_EDITABLE_ENDUSER, "SimpleText", TicketFieldSettingsManager.MSG.getMsg("fields.endusereditable", new Object[0]), (Object)MandatoryFieldVO.MandatoryType.HIDDEN.name(), "", enduseropts));
        List enduseropts2 = Arrays.stream(MandatoryFieldVO.MandatoryType.values()).map(type -> new LocalizedKey(type.name(), TicketFieldSettingsManager.MSG.getMsg("fields.endusereditable." + type.name() + (type == MandatoryFieldVO.MandatoryType.REQUIRED ? ".default" : ""), new Object[0]))).collect(Collectors.toCollection(ArrayList::new));
        propertyList.add(new SelectConfigProperty(0, PROP_EDITABLE_ENDUSER_DEFAULTCHANGE, "SimpleText", TicketFieldSettingsManager.MSG.getMsg("fields.endusereditable", new Object[0]), (Object)MandatoryFieldVO.MandatoryType.HIDDEN.name(), "", enduseropts2));
        propertyList.add(new BooleanConfigProperty(0, PROP_MANDATORY_DISPATCHER, TicketFieldSettingsManager.MSG.getMsg("fields.mandatorydispatcher", new Object[0]), null, null, (Object)"false"));
        propertyList.add(new BooleanConfigProperty(0, PROP_MANDATORY_RESOURCE, TicketFieldSettingsManager.MSG.getMsg("fields.mandatoryresource", new Object[0]), null, null, (Object)"false"));
        propertyList.add(new BooleanConfigProperty(0, PROP_DEFAULT_MUST_BE_CHANGED_DISPATCHER, TicketFieldSettingsManager.MSG.getMsg("fields.mandatorydispatcherXMustBeChanged", new Object[0]), null, null, (Object)"false"));
        propertyList.add(new BooleanConfigProperty(0, PROP_DEFAULT_MUST_BE_CHANGED_RESOURCE, TicketFieldSettingsManager.MSG.getMsg("fields.mandatoryresourceXMustBeChanged", new Object[0]), null, null, (Object)"false"));
        propertyList.add(TicketFieldSettingsProperty.propWith((String)"Hidden", (String)"", (String)PROP_CAN_SET_MANDATORY, (String)"true"));
        propertyList.add(TicketFieldSettingsProperty.propWith((String)"Hidden", (String)"", (String)"ticketCustom3", (String)"false"));
        ArrayList<LocalizedKey> identifierOptions = new ArrayList<LocalizedKey>();
        identifierOptions.add(new LocalizedKey("", "-- " + TicketFieldSettingsManager.MSG.getMsg("identifier.selection.none", new Object[0]) + " --"));
        for (UserField field : DynamicExtensionManager.getInstance().get(UserField.class)) {
            UserFieldDefinition definition = UsersAndGroups.getUserFieldDefinitionByKey((String)field.getKey());
            if (definition == null) continue;
            try {
                UserFieldDefinitionNature.getTypeForDefinition((UserFieldDefinition)definition);
                identifierOptions.add(new LocalizedKey(field.getKey(), field.getLabel()));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        options.sort((lk1, lk2) -> lk1.getDisplayName().compareToIgnoreCase(lk2.getDisplayName()));
        propertyList.add(new SelectConfigProperty(0, HDConfigKeys.DEFAULT_IDENTIFIER_SELECTION.getKey(), "SimpleText", TicketFieldSettingsManager.MSG.getMsg(HDConfigKeys.DEFAULT_IDENTIFIER_SELECTION.getKey(), new Object[0]), (Object)"", "", identifierOptions));
        propertyList.add(new ConfigProperty(0, PROP_PRIO_LINK_LABEL, "Link", TicketFieldSettingsManager.MSG.getMsg("prioLabel", new Object[0]), (Object)"", null, TicketFieldSettingsManager.MSG.getMsg(PROP_PRIO_LINK_LABEL, new Object[0])));
        propertyList.add(new ConfigProperty(0, PROP_ITIL_LINK_LABEL, "Link", TicketFieldSettingsManager.MSG.getMsg("prioLabel", new Object[0]), (Object)"", null, TicketFieldSettingsManager.MSG.getMsg(PROP_ITIL_LINK_LABEL, new Object[0])));
        propertyList.add(new ConfigProperty(0, PROP_CAT_LINK_LABEL, "Link", TicketFieldSettingsManager.MSG.getMsg("prioLabel", new Object[0]), (Object)"", null, TicketFieldSettingsManager.MSG.getMsg(PROP_CAT_LINK_LABEL, new Object[0])));
        propertyList.add(new ConfigProperty(0, PROP_CLASS_LINK_LABEL, "Link", TicketFieldSettingsManager.MSG.getMsg("prioLabel", new Object[0]), (Object)"", null, TicketFieldSettingsManager.MSG.getMsg(PROP_CLASS_LINK_LABEL, new Object[0])));
        return rowActions;
    }

    private String getSettingsURL(String key) {
        String targetURL = "configmanager/page/configuration.ticket.ticketvalues/dialog/" + key;
        String rootURL = SessionStore.getRootURL();
        targetURL = rootURL != null ? rootURL + targetURL : "../" + targetURL;
        return targetURL;
    }

    private String getPrioSettingsURL() {
        return this.getSettingsURL("helpdesk.main.priorities");
    }

    private String getCategorySettingsURL() {
        return this.getSettingsURL("helpdesk.main.categories");
    }

    private String getClassificationSettingsURL() {
        return this.getSettingsURL("helpdesk.main.classifications");
    }

    private String getItilSettingsURL() {
        return this.getSettingsURL("helpdesk.main.itil");
    }
}

