/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.helpdesk.config.StatusList;
import com.inet.helpdesk.config.TicketValueIconConfigProperty;
import com.inet.helpdesk.config.Translator;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusManager;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusVO;
import com.inet.lib.json.Json;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

@JsonData
public class StatusListConfigProperty
extends ItemListConfigProperty {
    public StatusListConfigProperty(ConnectionFactory factory, ConfigStructureSettings settings, Translator translator) {
        super(0, "Statuses", "STATUSES", StatusListConfigProperty.getObjectListValue(factory, settings), null, StatusListConfigProperty.createRowActions(settings, translator));
        this.setDeleteDisabledCondition(new ConfigCondition(ConfigCondition.Operation.Equals, new Object[]{"hide", "true"}));
        this.setReloadAfterRowDeletion(true);
    }

    static Object getObjectListValue(ConnectionFactory connectionFactory, ConfigStructureSettings settings) {
        List changedValueRaw = (List)settings.getChangedValue("Statuses", List.class);
        if (changedValueRaw != null) {
            List idList = changedValueRaw.stream().map(map -> (String)map.get("id")).collect(Collectors.toList());
            changedValueRaw.forEach(m -> {
                ArrayList idListWithoutMyId = new ArrayList(idList);
                idListWithoutMyId.remove(m.get("id"));
                String idListJson = new Json().toJson(idListWithoutMyId);
                m.put("allids", idListJson);
            });
            return changedValueRaw.stream().sorted(Comparator.comparing(e -> Integer.valueOf((String)e.get("id")))).collect(Collectors.toList());
        }
        List list = StatusManager.getInstance().getAll(true).stream().sorted(Comparator.comparing(FieldVO::getDisplayValue)).collect(Collectors.toList());
        List idList = list.stream().map(p -> "" + p.getId()).collect(Collectors.toList());
        String allIds = new Json().toJson(idList);
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        for (StatusVO status : list) {
            HashMap<String, String> entry = StatusListConfigProperty.convertToHashmap(status);
            entry.put("isNewlyCreated", "false");
            if (status.isInternal()) {
                entry.put("hide", "true");
            }
            entry.put("allids", allIds);
            result.add(entry);
        }
        return result;
    }

    private static HashMap<String, String> convertToHashmap(StatusVO status) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("StatusBezeichnung", status.getDisplayValue());
        result.put("StaImage", status.getImageName());
        result.put("intern", "" + status.isInternal());
        result.put("id", "" + status.getId());
        result.put("hide", "false");
        TicketValueIconConfigProperty.prepareConfigValueMapForIcons(result);
        return result;
    }

    public static List<StatusVO> convertToList(HashMap<String, String>[] result) {
        ArrayList<StatusVO> map = new ArrayList<StatusVO>();
        for (HashMap<String, String> status : result) {
            StatusVO info = StatusListConfigProperty.convertToEntry(status);
            map.add(info);
        }
        return map;
    }

    private static StatusVO convertToEntry(HashMap<String, String> statusMap) {
        String id = statusMap.get("id");
        if (id == null) {
            id = "-1";
        }
        int idNum = Integer.parseInt(id);
        return new StatusVO(idNum, statusMap.get("StatusBezeichnung"), statusMap.get("StaImage"), false, Boolean.parseBoolean(statusMap.get("intern")));
    }

    private static ConfigRowAction[] createRowActions(ConfigStructureSettings settings, Translator translator) {
        List allids = null;
        List changedValueRaw = (List)settings.getChangedValue("Statuses", List.class);
        if (changedValueRaw != null) {
            allids = changedValueRaw.stream().map(map -> (String)map.get("id")).collect(Collectors.toList());
        } else {
            String statusesOrigValue = settings.getValue("Statuses");
            if (statusesOrigValue != null) {
                StatusList statuses = (StatusList)new Json().fromJson(statusesOrigValue, StatusList.class);
                allids = statuses.stream().map(p -> "" + p.getId()).collect(Collectors.toList());
            } else {
                allids = StatusManager.getInstance().getAll(true).stream().map(s -> "" + s.getId()).collect(Collectors.toList());
            }
        }
        int defaultStatus = 220;
        while (allids.contains("" + defaultStatus)) {
            ++defaultStatus;
        }
        String myId = settings.getValue("id");
        if (myId != null) {
            allids.remove(myId);
        }
        ConfigAction action = new ConfigAction("status.new", translator.translate("AddStatus"));
        ConfigCategory category = new ConfigCategory(0, "status.new", translator.translate("Status"), "ticket.settings.statuses");
        ArrayList<ConfigPropertyGroup> propertyGroups = new ArrayList<ConfigPropertyGroup>();
        propertyGroups.add(new ConfigPropertyGroup(0, "status.new.group", ""));
        HashMap properties = new HashMap();
        ArrayList<Object> propertyList = new ArrayList<Object>();
        properties.put("status.new.group", propertyList);
        ArrayList<ConfigConditionAction> conditions = new ArrayList<ConfigConditionAction>();
        ConditionGenerator g = new ConditionGenerator();
        conditions.add(g.enableActionFor(g.createCondition().property("isNewlyCreated").equals().value((Object)"true"), "id"));
        ConfigRowAction rowAction = new ConfigRowAction(action, null, category, propertyGroups, properties, conditions);
        propertyList.add(StatusListConfigProperty.propWith("FixNumber", translator.translate("StatusID"), "id", "" + defaultStatus));
        propertyList.add(StatusListConfigProperty.propWith("SimpleText", translator.translate("StatusBezeichnung"), "StatusBezeichnung", ""));
        propertyList.add((Object)new TicketValueIconConfigProperty(0, translator.translate("StaImage"), 0));
        propertyList.add(StatusListConfigProperty.propWith("Hidden", "isNewlyCreated", "isNewlyCreated", "true"));
        propertyList.add(StatusListConfigProperty.propWith("Hidden", "intern", "intern", "false"));
        propertyList.add(StatusListConfigProperty.propWith("Hidden", "allids", "allids", new Json().toJson(allids)));
        return new ConfigRowAction[]{rowAction};
    }

    private static ConfigProperty propWith(String type, String label, String keyName, String value) {
        return new ConfigProperty(0, keyName, type, label, (Object)value, null, null);
    }
}

