/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.dbconnection.DBConnection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DatabaseInfosMsAccess
extends DatabaseInfos {
    public DatabaseInfosMsAccess(DBConnection dbcon) {
        super(dbcon);
    }

    @Override
    public String getDestDataType(int datatype, int size, int scale, String originalName, boolean identity) throws SQLException {
        if (identity) {
            return "counter";
        }
        switch (datatype) {
            case -6: {
                return "byte";
            }
            case -5: {
                return "double";
            }
            case 8: {
                return "float";
            }
            case -1: 
            case 2005: {
                return "longchar";
            }
            case -4: 
            case 2004: {
                return "longbinary";
            }
            case -8: {
                return "char(" + size + ")";
            }
            case -9: {
                return "varchar(" + size + ")";
            }
            case -10: {
                return "longchar";
            }
        }
        return super.getDestDataType(datatype, size, scale, originalName, identity);
    }

    @Override
    protected String getNumericDataType(String defaultDataType, int size, int scale, String originalName) {
        if (scale == 4 && size <= 19) {
            return "currency";
        }
        if (scale == 0 && size <= 3) {
            return "byte";
        }
        if (scale == 0 && size <= 5) {
            return "smallint";
        }
        return "double";
    }

    @Override
    public int getSupportedDataType(int sourceDataType) {
        switch (sourceDataType) {
            case -5: {
                return 8;
            }
            case -3: 
            case -2: {
                return 12;
            }
            case -4: 
            case 2004: {
                return -1;
            }
            case 3: {
                return 2;
            }
            case 6: {
                return 8;
            }
        }
        return super.getSupportedDataType(sourceDataType);
    }

    @Override
    public boolean supportsDefaultInCreateTable() {
        return false;
    }

    @Override
    public String readView(String cat, String schema, String name) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE VIEW ");
        sql.append(this.getQuoteIdentiferIfNeeded(name));
        sql.append(" AS\n");
        PreparedStatement pr = this.getDBConnection().prepareStatement("Select MSysQueries.* from MSysObjects inner join MSysQueries on MSysObjects.id = MSysQueries.ObjectId Where Type = 5 and Name = ?");
        pr.setString(1, name);
        Hashtable<String, String> joins = new Hashtable<String, String>();
        ResultSet rs = pr.executeQuery();
        boolean isFirst5 = true;
        boolean isFirst6 = true;
        boolean isFirst9 = true;
        boolean isFirst11 = true;
        boolean isFrom = false;
        String union = null;
        int type = 0;
        while (rs.next()) {
            int attribute = rs.getInt("Attribute");
            String expression = rs.getString("Expression");
            if (attribute > 7 && !isFrom && type != 9) {
                isFrom = true;
                sql.append("\nFROM ");
                Enumeration elements = joins.elements();
                Vector<String> isUsed = new Vector<String>();
                boolean isFirst = true;
                while (elements.hasMoreElements()) {
                    String join = (String)elements.nextElement();
                    if (isUsed.contains(join)) continue;
                    if (!isFirst) {
                        sql.append(", ");
                    }
                    isFirst = false;
                    isUsed.add(join);
                    sql.append(join);
                }
            }
            block0 : switch (attribute) {
                case 1: {
                    type = rs.getInt("Flag");
                    switch (type) {
                        case 1: {
                            sql.append("SELECT ");
                            break block0;
                        }
                        case 2: {
                            sql.append("SELECT ");
                            break block0;
                        }
                        case 3: {
                            sql.append("INSERT INTO ");
                            break block0;
                        }
                        case 4: {
                            sql.append("UPDATE ");
                            break block0;
                        }
                        case 5: {
                            sql.append("DELETE ");
                            break block0;
                        }
                        case 6: {
                            sql.append("TRANSFORM ");
                            break block0;
                        }
                        case 7: {
                            sql.append(expression);
                            break block0;
                        }
                        case 8: {
                            sql.append(expression);
                            break block0;
                        }
                        case 9: {
                            break block0;
                        }
                    }
                    throw new SQLException("Unknown SQL type:" + type + " in " + name);
                }
                case 3: {
                    int rowOption = rs.getInt("Flag");
                    switch (type) {
                        case 1: {
                            if ((rowOption & 2) > 0) {
                                sql.append("DISTINCT ");
                            }
                            if ((rowOption & 8) > 0) {
                                sql.append("DISTINCTROW ");
                            }
                            if ((rowOption & 0x10) == 16) {
                                sql.append("TOP ").append(rs.getString("Name1"));
                            }
                            if ((rowOption & 1) <= 0) break;
                            sql.append("*, ");
                            break block0;
                        }
                        case 9: {
                            union = rowOption == 1 ? "UNION ALL " : "UNION ";
                        }
                    }
                    break;
                }
                case 5: {
                    switch (type) {
                        case 1: {
                            String tableName = rs.getString("Name1");
                            joins.put(tableName, tableName);
                            break block0;
                        }
                        case 9: {
                            if (!isFirst5) {
                                sql.append(union);
                            }
                            isFirst5 = false;
                            sql.append(expression);
                        }
                    }
                    break;
                }
                case 6: {
                    if (!isFirst6) {
                        sql.append(", ");
                    }
                    isFirst6 = false;
                    sql.append(expression);
                    break;
                }
                case 7: {
                    String right;
                    String table1 = rs.getString("Name1");
                    String table2 = rs.getString("Name2");
                    String left = (String)joins.get(table1);
                    if (left == null) {
                        left = table1;
                        joins.put(table1, table1);
                    }
                    if ((right = (String)joins.get(table2)) == null) {
                        right = table2;
                        joins.put(table2, table2);
                    }
                    StringBuilder join = new StringBuilder();
                    join.append('(').append(left);
                    int joinOperation = rs.getInt("Flag");
                    switch (joinOperation) {
                        case 1: {
                            join.append(" INNER JOIN ");
                            break;
                        }
                        case 2: {
                            join.append(" LEFT JOIN ");
                            break;
                        }
                        case 3: {
                            join.append(" RIGHT JOIN ");
                            break;
                        }
                        default: {
                            throw new SQLException("Unknown JOIN :" + joinOperation + " in View " + name);
                        }
                    }
                    join.append(right);
                    join.append(" ON ");
                    join.append(expression);
                    join.append(')');
                    String joinStr = join.toString();
                    joins.put(table1, left);
                    Enumeration keys = joins.keys();
                    while (keys.hasMoreElements()) {
                        String obj = (String)keys.nextElement();
                        Object value = joins.get(obj);
                        if (value != left && value != right) continue;
                        joins.put(obj, joinStr);
                    }
                    break;
                }
                case 8: {
                    sql.append("\nWHERE ").append(expression);
                    break;
                }
                case 9: {
                    if (isFirst9) {
                        sql.append("\nGroup By ");
                    } else {
                        sql.append(", ");
                    }
                    isFirst9 = false;
                    sql.append(expression);
                    break;
                }
                case 10: {
                    sql.append("\nHAVING ").append(expression);
                    break;
                }
                case 11: {
                    if (isFirst11) {
                        sql.append("\nORDER BY ");
                    } else {
                        sql.append(", ");
                    }
                    isFirst11 = false;
                    sql.append(expression);
                }
            }
        }
        return sql.toString();
    }

    @Override
    public boolean isNotNullable(int dbMetaNullabale, int rsMetaNullable, int datatype) {
        if (datatype == -7) {
            return false;
        }
        return super.isNotNullable(dbMetaNullabale, rsMetaNullable, datatype);
    }

    @Override
    public boolean isPrimaryKey(String cat, String schema, String name, String keyName) {
        return "PrimaryKey".equalsIgnoreCase(keyName);
    }

    @Override
    public ResultSet getForeignKeys(String catalog, String schema, String table) throws SQLException {
        PreparedStatement pr = this.getDBConnection().prepareStatement("SELECT szReferencedColumn as PKCOLUMN_NAME, szReferencedObject as PKTABLE_NAME, szColumn as FKCOLUMN_NAME, szRelationship as FK_NAME, icolumn+1 as KEY_SEQ FROM MSysRelationships WHERE szObject=?");
        pr.setString(1, table);
        ResultSet rs = pr.executeQuery();
        this.getDBConnection().close(pr);
        return rs;
    }

    @Override
    public ResultSet getSequences() throws SQLException {
        return null;
    }

    @Override
    public String getDBMSTypeName() {
        return "Access";
    }

    @Override
    public int getTypeID() {
        return 2;
    }
}

