/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.ticket.step;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.webapi.HelpDeskTicketWebAPIExtension;
import com.inet.helpdesk.webapi.data.step.AttachmentResponseData;
import com.inet.helpdesk.webapi.data.step.TicketStepDetailedEntryResponseData;
import com.inet.helpdesk.webapi.util.HelpDeskWebAPIAttachmentsHelper;
import com.inet.helpdesk.webapi.util.HelpDeskWebAPIHelper;
import com.inet.http.ClientMessageException;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.webapi.api.PathTokenizer;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@Tag(name="Tickets", description="Operations for managing HelpDesk tickets")
@InternalApi
public class HelpDeskTicketStepIdHandler
extends RequestHandler.WithCurrentPathToken<Void, ReaStepVO, Integer> {
    public static final String INLINE_REASTEP_IMAGES = "inlineImages";

    public HelpDeskTicketStepIdHandler() {
        super(new String[]{"stepId"});
    }

    public Integer typeFor(String token) {
        try {
            return Integer.valueOf(token);
        }
        catch (NumberFormatException e) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.step.idNotInteger", new Object[]{token}));
        }
    }

    public String getHelpPageKey() {
        return "webapi.ticket.id.step.id";
    }

    @Operation(summary="Get ticket step details", description="Retrieves detailed information about a specific reaction step in a ticket, including text content and attachments", responses={@ApiResponse(responseCode="200", description="Step details retrieved successfully", content={@Content(schema=@Schema(implementation=TicketStepDetailedEntryResponseData.class), examples={@ExampleObject(name="Welcome Ticket Step Details", value="{\"id\":1,\"actionID\":4,\"userGUID\":null,\"lastModified\":1737991110000,\"text\":\"<html><head></body></html>\",\"htmlContent\":true,\"actionDisplayName\":\"Anfrage erzeugen\",\"attributes\":{\"bundle_visible\":false,\"reastepactionid\":4,\"reasteporgbunid\":1,\"reastephastext\":true,\"reastepbunid\":1,\"reasteplumpsum\":0,\"reastephourlyrate\":0},\"fields\":{\"attachments\":[{\"name\":\"Ticketsystem_fuer_unterwegs.png\",\"lastModified\":1737991110750,\"attachmentType\":\"EmbeddedImage\",\"fileLength\":693368,\"url\":\"Attachments/ticket/1/1/Ticketsystem_fuer_unterwegs.png\"}],\"reastepprocessingtime\":{\"start\":1737991110000,\"end\":1737991110000}}}")})}), @ApiResponse(responseCode="400", description="Invalid ticket ID or step ID format"), @ApiResponse(responseCode="401", description="User not authorized to view step details"), @ApiResponse(responseCode="404", description="Step not found or step does not belong to specified ticket")})
    public ReaStepVO handle(HttpServletRequest request, HttpServletResponse response, @Nullable Void inputObject, @Nullable Integer stepId, boolean previewModeEnabled) throws IOException {
        boolean requiresChecksum;
        List pathToTokens = PathTokenizer.convertPathToTokens((String)request.getPathInfo());
        if (pathToTokens.size() < 2) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.notATicketId", new Object[]{request.getPathInfo()}));
        }
        String ticketIdToken = (String)pathToTokens.get(1);
        int ticketID = Tickets.decodeTicketID(ticketIdToken, requiresChecksum = HelpDeskWebAPIHelper.requestRequiresEncodedTicketId());
        if (ticketID == -1) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.notATicketId", new Object[]{ticketIdToken}));
        }
        stepId = HelpDeskWebAPIHelper.checkReaStepReadAccessOrThrow(stepId, response);
        ReaStepVO reaStep = TicketManager.getReader().getReaStep(stepId);
        if (reaStep == null) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.step.notAStepId", new Object[]{stepId}));
        }
        if (reaStep.getOrgBunID() != ticketID) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.step.idNotForTicket", new Object[]{stepId, ticketIdToken}));
        }
        HelpDeskWebAPIHelper.checkReaStepReadAccessOrThrow(stepId, response);
        List<String> requestedFields = HelpDeskWebAPIHelper.getRequestedFields(request, fields -> {
            fields.addAll(reaStep.getIncludedAttributes().parallelStream().map(a -> a.getKey()).collect(Collectors.toList()));
            fields.addAll(reaStep.getIncludedFields().parallelStream().map(a -> a.getKey()).collect(Collectors.toList()));
        });
        ReaStepTextVO reaStepText = TicketManager.getReader().getReaStepText(stepId);
        List<AttachmentResponseData> attachments = null;
        if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
            attachments = HelpDeskWebAPIAttachmentsHelper.getAttachmentResponseDataForTicket(ticketID);
            attachments.removeIf(a -> a.getStepId().intValue() != reaStep.getID());
        }
        ResponseWriter.json((HttpServletResponse)response, (Object)TicketStepDetailedEntryResponseData.from(ticketID, reaStep, reaStepText, request.getAttribute(INLINE_REASTEP_IMAGES) != null, requestedFields, attachments));
        return reaStep;
    }

    public boolean shouldSendJsonResponse() {
        return false;
    }
}

