/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.shared.util;

import java.util.ArrayList;
import java.util.Arrays;

public class TypespecificIntMap<V> {
    private static final int MINIMUM_SIZE = 11;
    private transient Entry<V>[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public TypespecificIntMap(int initialCapacity, float loadFactor) {
        this.loadFactor = loadFactor;
        if (initialCapacity < 11) {
            initialCapacity = 11;
        }
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
        this.count = 0;
    }

    public TypespecificIntMap(int size) {
        this(size, 1.95f);
    }

    public TypespecificIntMap() {
        this(11);
    }

    public synchronized int arraySize() {
        return this.table.length;
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized void clear() {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = null;
        }
        this.count = 0;
    }

    public synchronized V remove(int key) {
        Entry<V> prev;
        int i = TypespecificIntMap.indexFor(key, this.table.length);
        Entry<V> e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (key == e.key) {
                --this.count;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                return e.value;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    public synchronized V get(int key) {
        Entry<V>[] tab = this.table;
        int index = TypespecificIntMap.indexFor(key, tab.length);
        Entry<V> e = tab[index];
        while (e != null) {
            if (key == e.key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    private static int indexFor(int key, int length) {
        return key & length - 1;
    }

    public synchronized void put(int key, V value) {
        if (value == null) {
            return;
        }
        int index = TypespecificIntMap.indexFor(key, this.table.length);
        Entry<V> e = this.table[index];
        while (e != null) {
            if (key == e.key) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        this.table[index] = new Entry<V>(key, value, this.table[index]);
        if (this.count++ >= this.threshold) {
            this.rehash();
        }
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Entry<V>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry<V> old = oldMap[i];
            while (old != null) {
                Entry<V> e = old;
                old = old.next;
                int index = TypespecificIntMap.indexFor(e.key, newCapacity);
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public synchronized int[] getAllKeys() {
        int[] allKeys = new int[this.count];
        if (this.count > 0) {
            int n;
            int writePos = 0;
            Entry<V>[] entryArray = this.table;
            int n2 = entryArray.length;
            for (n = 0; n < n2; ++n) {
                Entry<V> element;
                Entry<V> e = element = entryArray[n];
                while (e != null && writePos < allKeys.length) {
                    allKeys[writePos++] = e.key;
                    e = e.next;
                }
            }
            if (writePos != allKeys.length) {
                int testCounter = 0;
                Entry<V>[] entryArray2 = this.table;
                n = entryArray2.length;
                for (int i = 0; i < n; ++i) {
                    Entry<V> element;
                    Entry<V> e = element = entryArray2[i];
                    while (e != null) {
                        ++testCounter;
                        e = e.next;
                    }
                }
                if (testCounter != this.count) {
                    this.count = testCounter;
                }
                return this.getAllKeys();
            }
        }
        return allKeys;
    }

    public int[] getSortetKeys() {
        int[] keys = this.getAllKeys();
        Arrays.sort(keys);
        return keys;
    }

    public synchronized ArrayList<V> getValueList() {
        ArrayList list = new ArrayList();
        if (this.count > 0) {
            Entry<V>[] entryArray = this.table;
            int n = entryArray.length;
            for (int i = 0; i < n; ++i) {
                Entry<V> element;
                Entry<V> e = element = entryArray[i];
                while (e != null) {
                    list.add(e.value);
                    e = e.next;
                }
            }
        }
        return list;
    }

    private static class Entry<V> {
        private final int key;
        private V value;
        private Entry<V> next;

        private Entry(int key, V value, Entry<V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

