/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugin;

import com.inet.authentication.LoginListener;
import com.inet.classloader.I18nMessages;
import com.inet.collaboration.bot.BotCommand;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationChangeListener;
import com.inet.config.ConfigurationManager;
import com.inet.config.ConfigurationMigrator;
import com.inet.config.recovery.RecoveryLauncher;
import com.inet.config.structure.model.ConfigPage;
import com.inet.config.structure.provider.ConfigStructureProvider;
import com.inet.fieldsettings.api.FieldSettingsSelectValueProvider;
import com.inet.fieldsettings.user.UserFieldSettingsManagerFactory;
import com.inet.fieldsettings.user.extension.UserFieldSettingsPropertyExtension;
import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner;
import com.inet.helpdesk.attachmentdisplay.AttachmentDisplay;
import com.inet.helpdesk.attachmentdisplay.CalendarAttachmentDisplayProvider;
import com.inet.helpdesk.attachmentdisplay.ClearReportsAttachmentDisplayProvider;
import com.inet.helpdesk.attachmentdisplay.HtmlTextAttachmentDisplayProvider;
import com.inet.helpdesk.attachmentdisplay.ImageAttachmentDisplayProvider;
import com.inet.helpdesk.attachmentdisplay.MailAttachmentDisplayProvider;
import com.inet.helpdesk.attachmentdisplay.PDFAttachmentDisplayProvider;
import com.inet.helpdesk.attachmentdisplay.PlainTextAttachmentDisplayProvider;
import com.inet.helpdesk.attachmentdisplay.VCardPackageAttachmentDisplayProvider;
import com.inet.helpdesk.attachmentdisplay.VideoAttachmentDisplayProvider;
import com.inet.helpdesk.attachmentdisplay.ZipAttachmentDisplayProvider;
import com.inet.helpdesk.bot.TicketCreationMultiCommand;
import com.inet.helpdesk.bot.TicketInfoBotCommand;
import com.inet.helpdesk.bot.TicketSearchBotCommand;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.HDConfigStructureProvider;
import com.inet.helpdesk.config.HDConfigStructureProviderTicketSettings;
import com.inet.helpdesk.config.HDConfigStructureProviderTicketValues;
import com.inet.helpdesk.config.HelpDeskInstanceName;
import com.inet.helpdesk.config.ITILConfigStructureProvider;
import com.inet.helpdesk.config.LogoFileMigrator;
import com.inet.helpdesk.config.PWAPromptFilterSupporter;
import com.inet.helpdesk.config.ScaledTicketValueIcon;
import com.inet.helpdesk.config.autotext.AutoTextConfigPage;
import com.inet.helpdesk.config.autotext.AutoTextHelpPageContentPatcher;
import com.inet.helpdesk.config.autotext.handler.AutoTextIcon;
import com.inet.helpdesk.config.autotext.handler.CreateOrEditAutoText;
import com.inet.helpdesk.config.autotext.handler.DeleteAutoText;
import com.inet.helpdesk.config.autotext.handler.LoadAvailableAutoTexts;
import com.inet.helpdesk.config.autotext.handler.SaveAutoText;
import com.inet.helpdesk.config.mailtemplates.MailTemplatesConfigPage;
import com.inet.helpdesk.config.mailtemplates.handler.CreateSetHandler;
import com.inet.helpdesk.config.mailtemplates.handler.DeleteLangHandler;
import com.inet.helpdesk.config.mailtemplates.handler.DeleteMailTemplateHandler;
import com.inet.helpdesk.config.mailtemplates.handler.DeleteSetHandler;
import com.inet.helpdesk.config.mailtemplates.handler.LoadDefaultMailTemplatesHandler;
import com.inet.helpdesk.config.mailtemplates.handler.LoadMailConfigSettings;
import com.inet.helpdesk.config.mailtemplates.handler.LoadMailTemplates;
import com.inet.helpdesk.config.mailtemplates.handler.LoadMailTemplatesEditor;
import com.inet.helpdesk.config.mailtemplates.handler.LoadMailTemplatesSettings;
import com.inet.helpdesk.config.mailtemplates.handler.LoadTemplateDataHandler;
import com.inet.helpdesk.config.mailtemplates.handler.MoveMailTemplateHandler;
import com.inet.helpdesk.config.mailtemplates.handler.SaveMailConfigSettings;
import com.inet.helpdesk.config.mailtemplates.handler.SaveMailTemplatesEditor;
import com.inet.helpdesk.config.migrator.EnduserEmailFilterMigrator;
import com.inet.helpdesk.config.pages.TemplatesConfigPage;
import com.inet.helpdesk.config.pages.TicketConfigPage;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ai.rewrite.GetRewriteTextWithAI;
import com.inet.helpdesk.core.ai.workingpanel.CancelExecutor;
import com.inet.helpdesk.core.attachmentdisplay.AttachmentDisplayProvider;
import com.inet.helpdesk.core.data.ActionCreationNotificator;
import com.inet.helpdesk.core.data.AdditionalFieldSetting;
import com.inet.helpdesk.core.data.ConnectionCreationListener;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.DBUpdateBackdoor;
import com.inet.helpdesk.core.data.DataImportConnector;
import com.inet.helpdesk.core.data.ImagesConnector;
import com.inet.helpdesk.core.data.ItilLinkManager;
import com.inet.helpdesk.core.data.LocalizationBundle;
import com.inet.helpdesk.core.data.MaintenanceConnector;
import com.inet.helpdesk.core.data.ServerInitializerStatus;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.data.TicketAccessInformationsProvider;
import com.inet.helpdesk.core.data.TicketDataConnector;
import com.inet.helpdesk.core.mailtemplates.DefaultMailTemplates;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketfieldsettings.SqlQuerySelectValueProvider;
import com.inet.helpdesk.core.ticketfieldsettings.TicketFieldSettingsManager;
import com.inet.helpdesk.core.ticketfieldsettings.config.TicketFieldSettingsStructureProvider;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.PluggableTicketSearchTag;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketManagerFactory;
import com.inet.helpdesk.core.ticketmanager.TicketManagerVetoPower;
import com.inet.helpdesk.core.ticketmanager.event.TicketRelatedChangeEventDispatcher;
import com.inet.helpdesk.core.ticketmanager.extension.CreateTicketExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.UpdateReaStepTextExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.UpdateTicketDataExtension;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionForTicketOwner;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTicketOwnerGroupId;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTicketOwnerLanguage;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTicketOwnerLocationId;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTicketOwnerLocationInfo;
import com.inet.helpdesk.core.ticketmanager.fields.DefaultValuesManager;
import com.inet.helpdesk.core.ticketmanager.fields.MandatoryFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassManager;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextManager;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepAttribute;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.SearchTagTicketTags;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.additionalaccess.AccessSearchTag;
import com.inet.helpdesk.core.ticketmanager.timeline.TimelineDataHandler;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.core.ticketview.SubViewGroupingDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewCategory;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.core.ticketview.TicketViewManager;
import com.inet.helpdesk.core.ticketview.subview.TicketFieldSubViewGrouping;
import com.inet.helpdesk.data.ActionCreationNotificatorImpl;
import com.inet.helpdesk.data.ConnectionFactoryImpl;
import com.inet.helpdesk.data.DBUpdateComponent;
import com.inet.helpdesk.data.DataImportConnectorImpl;
import com.inet.helpdesk.data.ImagesConnectorImpl;
import com.inet.helpdesk.data.LocalizationBundleImpl;
import com.inet.helpdesk.data.MaintenanceConnectorImpl;
import com.inet.helpdesk.data.ServerValuesConnectorImpl;
import com.inet.helpdesk.data.itil.GeneratedAttributeItilCountEventListener;
import com.inet.helpdesk.data.itil.ItilChangedTicketEventListener;
import com.inet.helpdesk.data.itil.ItilLinkManagerImpl;
import com.inet.helpdesk.logging.EventLogTicketEventListener;
import com.inet.helpdesk.logging.MailErrorEventLogDescription;
import com.inet.helpdesk.logging.TemplateEventLogDescription;
import com.inet.helpdesk.logging.TicketEventLogDescription;
import com.inet.helpdesk.login.ComputerNameSetter;
import com.inet.helpdesk.mail.AutoMailerFactoryImpl;
import com.inet.helpdesk.mail.reader.EmailAccountIdConfigMigrator;
import com.inet.helpdesk.notification.EmailErrorNotificationGroup;
import com.inet.helpdesk.notification.ResourceNotificationGroup;
import com.inet.helpdesk.plugin.HdStandaloneConfiguration;
import com.inet.helpdesk.plugin.HelpDeskRequestFilter;
import com.inet.helpdesk.plugin.HelpdeskApplicationDescription;
import com.inet.helpdesk.plugin.PluginsIdMigrator;
import com.inet.helpdesk.plugin.TicketIdUidConfigMigrator;
import com.inet.helpdesk.plugin.adhoc.LocalConfigChangeListener;
import com.inet.helpdesk.plugin.adhoc.structure.HDAdhocStructureProvider;
import com.inet.helpdesk.plugins.reporting.server.ReportingServerPluginRegistration;
import com.inet.helpdesk.servlets.ImagesServlet;
import com.inet.helpdesk.servlets.MulticastServlet;
import com.inet.helpdesk.theme.HelpDeskThemeService;
import com.inet.helpdesk.ticketmanager.NewTicketDataConnectorImpl;
import com.inet.helpdesk.ticketmanager.TicketManagerFactoryImpl;
import com.inet.helpdesk.ticketmanager.dupcontent.DuplicatedContentExtensionFactory;
import com.inet.helpdesk.ticketmanager.extensions.AppointmentTimeActionExtensionFactory;
import com.inet.helpdesk.ticketmanager.extensions.BundleTicketActionExtensionFactory;
import com.inet.helpdesk.ticketmanager.extensions.CloseTicketActionExtensionFactory;
import com.inet.helpdesk.ticketmanager.extensions.CreateTicketFromMailExtension;
import com.inet.helpdesk.ticketmanager.extensions.DeadlineMahnenTicketActionExtensionFactory;
import com.inet.helpdesk.ticketmanager.extensions.DeadlineUpdateExtensionFactory;
import com.inet.helpdesk.ticketmanager.extensions.EscalateOrAuthorizeTicketActionExtensionFactory;
import com.inet.helpdesk.ticketmanager.extensions.ReactivateTicketActionExtensionFactory;
import com.inet.helpdesk.ticketmanager.extensions.ReopenTicketActionExtensionFactory;
import com.inet.helpdesk.ticketmanager.extensions.UnbundleTicketActionExtensionFactory;
import com.inet.helpdesk.ticketmanager.init.DefaultValueInitializer;
import com.inet.helpdesk.ticketmanager.internal.DefaultValueManagerImpl;
import com.inet.helpdesk.ticketmanager.internal.MandatoryFieldsManagerImpl;
import com.inet.helpdesk.ticketmanager.trigger.StatusAndItilChangeTrigger;
import com.inet.helpdesk.ticketview.ItilMasterSubViewGroupingEventListener;
import com.inet.helpdesk.ticketview.TicketViewGroupEventListener;
import com.inet.helpdesk.ticketview.TicketViewManagerImpl;
import com.inet.helpdesk.ticketview.TicketViewTicketEventListener;
import com.inet.helpdesk.ticketview.TicketViewUserEventListener;
import com.inet.helpdesk.ticketview.UserFieldsWithClientSettingsForTicketList;
import com.inet.helpdesk.ticketview.standardviews.InquiryTicketViewDefinition;
import com.inet.helpdesk.ticketview.standardviews.LastEditorTicketViewDefinition;
import com.inet.helpdesk.ticketview.standardviews.OpenTicketViewDefinition;
import com.inet.helpdesk.ticketview.standardviews.OwnTicketViewDefinition;
import com.inet.helpdesk.ticketview.standardviews.SharedWithMeTicketViewDefinition;
import com.inet.helpdesk.ticketview.standardviews.SupervisorTicketViewDefinition;
import com.inet.helpdesk.ticketview.standardviews.UnreadTicketViewDefinition;
import com.inet.helpdesk.ticketview.subview.CategorySubViewGrouping;
import com.inet.helpdesk.ticketview.subview.ItilMasterSubViewGrouping;
import com.inet.helpdesk.ticketview.subview.ItilSubViewGrouping;
import com.inet.helpdesk.ticketview.subview.MyResourceSubViewGrouping;
import com.inet.helpdesk.ticketview.subview.PrioritySubViewGrouping;
import com.inet.helpdesk.ticketview.subview.ResourceSubViewGrouping;
import com.inet.helpdesk.ticketview.subview.SupervisorSubViewGrouping;
import com.inet.helpdesk.ticketview.subview.UserFieldSubViewGrouping;
import com.inet.helpdesk.userfields.HDUserFieldSettingPropertyExtension;
import com.inet.helpdesk.userfields.HDUserFieldsConfigStructureProvider;
import com.inet.helpdesk.userfields.UserFieldSettingManagerHD;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.helpdesk.usersandgroups.HDUserImportFieldValueModifier;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.LocaleFilter;
import com.inet.helpdesk.usersandgroups.UnchangeableParentFieldValueModifier;
import com.inet.helpdesk.usersandgroups.groups.HelpDeskUserGroupManagerFactory;
import com.inet.helpdesk.usersandgroups.ui.HDUserOrGroupAdditionalDetailProvider;
import com.inet.helpdesk.usersandgroups.ui.MaxUserDetails;
import com.inet.helpdesk.usersandgroups.ui.NamedUserDetails;
import com.inet.helpdesk.usersandgroups.ui.ResetAndSetAsDefaultGUIPreferencesCustomUserAction;
import com.inet.helpdesk.usersandgroups.ui.ResourceGroupDeletionHandler;
import com.inet.helpdesk.usersandgroups.ui.ResourcesPermissionPatcher;
import com.inet.helpdesk.usersandgroups.ui.SetAsDefaultGUIPreferencesCustomUserAction;
import com.inet.helpdesk.usersandgroups.ui.SupportersPermissionPatcher;
import com.inet.helpdesk.usersandgroups.ui.UserFieldsWithClientSettings;
import com.inet.helpdesk.usersandgroups.ui.effectiveactions.EffectiveActionsHandler;
import com.inet.helpdesk.usersandgroups.ui.fieldgroups.AllowedActionsFieldPanelDefinition;
import com.inet.helpdesk.usersandgroups.ui.fieldgroups.GeneralResourcesGroupFieldPanelDefinition;
import com.inet.helpdesk.usersandgroups.ui.fieldgroups.LumpSumUserFieldPanelDefinition;
import com.inet.helpdesk.usersandgroups.ui.fieldgroups.MembersResourcesGroupFieldPanelDefinition;
import com.inet.helpdesk.usersandgroups.ui.fieldgroups.NotificationSettingsResourcesGroupFieldPanelDefinition;
import com.inet.helpdesk.usersandgroups.ui.fieldgroups.PermissionsGroupFieldPanelDefinition;
import com.inet.helpdesk.usersandgroups.ui.fieldgroups.ResourcesGuestFieldPanelDefinition;
import com.inet.helpdesk.usersandgroups.ui.fieldgroups.ResourcesMasterFieldPanelDefinition;
import com.inet.helpdesk.usersandgroups.ui.fieldgroups.ResourcesStandardUserFieldPanelDefinition;
import com.inet.helpdesk.usersandgroups.ui.fieldgroups.WorkingHoursResourcesGroupFieldPanelDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.group.AllowedActionsGroupFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.group.EscalationGroupFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.group.OtherResourcesGroupFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.group.ResHourRangeGroupFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.group.ResNotificationSettingsGroupFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.group.ResSettingsGroupFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.user.AllowedActionsUserFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.user.HDLoginsUserFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.user.HDStringUserFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.user.ImportedHintUserFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.user.LanguageUserFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.user.LocationUserFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.user.LumpSumUserFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.user.UserClassUserFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.filter.DispatcherUserFilter;
import com.inet.helpdesk.usersandgroups.ui.filter.EndUserFilter;
import com.inet.helpdesk.usersandgroups.ui.filter.NamedUserFilter;
import com.inet.helpdesk.usersandgroups.ui.filter.ResourceGroupsFilter;
import com.inet.helpdesk.usersandgroups.ui.filter.SupporterUserFilter;
import com.inet.helpdesk.usersandgroups.user.HelpDeskUserManagerFactory;
import com.inet.helpdesk.usersandgroups.user.UserSearchFilterHD;
import com.inet.helpdesk.webapi.HelpDeskTicketWebAPIExtension;
import com.inet.helpdesk.webapi.ticket.HelpDeskTicketSearchHandler;
import com.inet.http.MDNSServletService;
import com.inet.http.PluginServlet;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.CoreLoggers;
import com.inet.mail.api.PGPPublicKeyFoundListener;
import com.inet.notification.NotificationGroup;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.CoreServerPlugin;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.Executable;
import com.inet.plugin.HelpProviderContainer;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.ServerPluginManagerListener;
import com.inet.plugin.help.ConfigHelpProvider;
import com.inet.plugin.help.HelpPage;
import com.inet.plugin.help.HelpProvider;
import com.inet.plugin.help.HelpProviderImpl;
import com.inet.plugin.veto.VetoPower;
import com.inet.plugin.veto.VetoSemaphore;
import com.inet.plugin.veto.VetoType;
import com.inet.remote.gui.angular.PWAPromptFilter;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.report.plugins.config.server.ConfigAngularApplicationServlet;
import com.inet.shared.statistics.eventlog.EventLogDescription;
import com.inet.theme.server.ThemeResource;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.FieldAndGroupTypeAssociation;
import com.inet.usersandgroups.api.FieldValueModifier;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.UserGroupManagerFactory;
import com.inet.usersandgroups.api.UserManagerFactory;
import com.inet.usersandgroups.api.groups.GroupTypeDef;
import com.inet.usersandgroups.api.groups.PredefinedUserGroup;
import com.inet.usersandgroups.api.groups.UserGroupEventListener;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.CustomUserAction;
import com.inet.usersandgroups.api.ui.GroupDeletionHandler;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.ui.details.StatisticalUserDetails;
import com.inet.usersandgroups.api.ui.details.UserOrGroupAdditionalDetailProvider;
import com.inet.usersandgroups.api.ui.fieldgroups.FieldPanelDefinition;
import com.inet.usersandgroups.api.ui.fields.FieldDefinition;
import com.inet.usersandgroups.api.ui.fields.PermissionPatcher;
import com.inet.usersandgroups.api.ui.fields.group.CurrencyGroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.group.EmailGroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.group.GroupNameFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.group.MembersGroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.group.ParentIdGroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.group.PermissionGroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.HintUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.LoginsUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.MembershipsUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.UF_Editability;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import com.inet.usersandgroups.api.ui.filter.UserOrGroupFilter;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserEventAdapter;
import com.inet.usersandgroups.api.user.UserEventListener;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroups.api.user.UserSearchFilter;
import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpSessionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.SQLException;
import java.time.DayOfWeek;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import srv.ConfigurationInitializer;
import srv.ServerInitializer;
import srv.ServerInterface;
import srv.controller.TicketAccessController;
import srv.controller.ticket.timeline.TimelineDataHandlerImpl;

@PluginInfo(id="helpdesk", version="25.10.322", dependencies="reporting;mail;htmlengine;fieldsettings;remotegui", optionalDependencies="theme;statistics;webapi.core;attachments;configuration;ticketlist;collaboration;oauth.connection;inventory;adhoc;help;ai", packages="com.inet.helpdesk.plugin;com.inet.helpdesk.core;com.inet.helpdesk.shared;com.inet.helpdesk.theme;com.inet.helpdesk.config;com.inet.dbupdater;com.inet.helpdesk.usersandgroups;com.inet.helpdesk.webapi", group="system;tickets;webapi", flags="core", internal="rhino.jar", icon="com/inet/helpdesk/images/user/helpdesk_64.png")
public class HelpdeskServerPlugin
implements ServerPlugin,
CoreServerPlugin {
    public static final String PLUGIN_ID = "helpdesk";
    public static final VetoType HD_SERVER_START = new VetoType("HD Server Start", 200);
    public static final I18nMessages MSG_CLIENT = new I18nMessages("com.inet.helpdesk.plugin.helpdeskconfig.i18n.LanguageResources", HelpdeskServerPlugin.class);
    public static final I18nMessages MSG_CONFIG = new I18nMessages("com.inet.helpdesk.config.i18n.ConfigStructure", HelpdeskServerPlugin.class);
    public static final I18nMessages MSG_SERVER = new I18nMessages("com.inet.helpdesk.i18n.LanguageResources", HelpdeskServerPlugin.class);
    public static final ConfigPage CONFIG_PAGE_AUTOTEXT = new AutoTextConfigPage();
    public static final ConfigPage CONFIG_PAGE_MAILTEMPLATE = new MailTemplatesConfigPage();
    private ServerValuesConnectorImpl serverValuesConnector;
    private ConnectionFactory connectionFactory;
    private ServerInitializer serverInitializer;
    private NewTicketDataConnectorImpl ticketDataConnector;
    private TimelineDataHandlerImpl timelineDataHandler;
    private DefaultValueManagerImpl defaultValueManagerImpl;
    private static UserEventAdapter REMOVE_USERREFERENCES_ON_DELETE;

    public void preInit(ServerPluginDescription spd) {
        ConfigurationManager.getInstance().addConfigurationMigrator((ConfigurationMigrator)new PluginsIdMigrator());
        try {
            new File(System.getProperty("java.io.tmpdir")).mkdirs();
        }
        catch (Throwable e2) {
            HDLogger.error(e2);
        }
        ConfigurationInitializer.setDefaultProperties();
        Thread.UncaughtExceptionHandler handler = (t, e) -> {
            try {
                FileOutputStream out = new FileOutputStream("fatalError.txt", true);
                PrintStream p = new PrintStream(out);
                e.printStackTrace(p);
                p.println();
                e.printStackTrace(System.err);
            }
            catch (FileNotFoundException e1) {
                HDLogger.error(e1);
                e1.printStackTrace(System.err);
            }
        };
        Thread.currentThread().setUncaughtExceptionHandler(handler);
        Thread.setDefaultUncaughtExceptionHandler(handler);
    }

    public void registerHelp(HelpProviderContainer container) {
        final Map<String, String> includedPluginHelpPages = Map.of("knowledgebase", "knowledgebase", "tickets", "ticketlist", "inventory", "inventory");
        container.add((HelpProvider)new HelpProviderImpl("manuals", 1000, new Permission[]{null}){

            public boolean isVisible(@Nonnull HelpPage helpPage) {
                if (!StringFunctions.isEmpty((String)helpPage.getKey()) && includedPluginHelpPages.keySet().contains(helpPage.getKey().toLowerCase())) {
                    return ServerPluginManager.getInstance().isPluginLoaded((String)includedPluginHelpPages.get(helpPage.getKey()));
                }
                return true;
            }
        }, new String[0]);
        final List<String> templateDefinitionPermissionPageKeys = Arrays.asList("configuration", "configuration.autotext", "configuration.autotext.placeholders");
        container.add((HelpProvider)new ConfigHelpProvider("configuration", 9100, new Permission[]{Permission.CONFIGURATION}){

            public boolean isVisible(@Nonnull HelpPage helpPage) {
                if (!StringFunctions.isEmpty((String)helpPage.getKey()) && templateDefinitionPermissionPageKeys.contains(helpPage.getKey().toLowerCase())) {
                    UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
                    if (currentUserAccount == null) {
                        return false;
                    }
                    if (HDUsersAndGroups.isSupporter(currentUserAccount)) {
                        return true;
                    }
                    return SystemPermissionChecker.hasAnyPermission((UserAccount)currentUserAccount, (Permission[])new Permission[]{Permission.CONFIGURATION, HdPermissions.TEMPLATE_DEFINITION});
                }
                return super.isVisible(helpPage);
            }
        }, new String[]{"configuration"});
        container.add((HelpProvider)new HelpProviderImpl("fieldsettings", 9335, new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER}){}, new String[]{"fieldsettings"});
        container.add((HelpProvider)new HelpProviderImpl("templates", 9111, new Permission[]{Permission.CONFIGURATION, HdPermissions.TEMPLATE_DEFINITION}){}, new String[]{"configuration"});
        container.add((HelpProvider)new HelpProviderImpl("usersandgroupsmanager", 9211, new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_CREATEUSERS}){

            public boolean isVisible(@Nonnull HelpPage helpPage) {
                boolean visible = super.isVisible(helpPage);
                if (!visible) {
                    return visible;
                }
                switch (helpPage.getKey()) {
                    case "usersandgroups.permissions": 
                    case "usersandgroups.userpermissions.ticket": 
                    case "usersandgroups.userpermissions.itil": 
                    case "helpdesk.abrechnungen": 
                    case "usersandgroups.helpdesk.panel.actions": 
                    case "usersandgroups.group.members": {
                        return SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN);
                    }
                }
                return true;
            }
        }, new String[]{"usersandgroupsmanager"});
        container.add((HelpProvider)new HelpProviderImpl("webapi", 9212, new Permission[]{Permission.valueOfExistingOrCreate((String)"webapi.core")}){}, new String[]{"webapi.core"});
        final ServerPluginManager spm = ServerPluginManager.getInstance();
        spm.runIfPluginLoaded("help", () -> new Executable(){

            public void execute() {
                AutoTextHelpPageContentPatcher.registerHelp(spm);
            }
        });
    }

    public void registerExtension(final ServerPluginManager spm) {
        if (PLUGIN_ID.equals(spm.getCorePluginId())) {
            spm.register(ApplicationDescription.class, (Object)this.getApplicationDescription());
        }
        spm.register(ImagesConnector.class, (Object)new ImagesConnectorImpl());
        if (ConfigurationManager.isHelpCenterMode()) {
            return;
        }
        new ServerInterface();
        this.serverInitializer = ServerInitializer.getInstance();
        CoreLoggers.addLoggers((String[])new String[]{"HelpDesk", "Reporting", "Mail", "Config", "Attachments", "helpdeskserverstart"});
        this.connectionFactory = new ConnectionFactoryImpl();
        spm.register(ConfigStructureProvider.class, (Object)new HDConfigStructureProvider(this.connectionFactory));
        spm.register(ConfigStructureProvider.class, (Object)new HDConfigStructureProviderTicketValues(this.connectionFactory));
        spm.register(ConfigStructureProvider.class, (Object)new HDConfigStructureProviderTicketSettings(this.connectionFactory));
        spm.register(ConfigStructureProvider.class, (Object)new ITILConfigStructureProvider());
        spm.register(ConfigStructureProvider.class, (Object)new TicketFieldSettingsStructureProvider());
        spm.register(ConfigPage.class, (Object)new TicketConfigPage());
        spm.runIfPluginLoaded("remotegui", () -> new Executable(){

            public void execute() {
                if (spm.isPluginLoaded("ticketlist")) {
                    spm.register(ConfigPage.class, (Object)new TemplatesConfigPage());
                    spm.register(ConfigPage.class, (Object)CONFIG_PAGE_AUTOTEXT);
                    spm.register(ConfigPage.class, (Object)CONFIG_PAGE_MAILTEMPLATE);
                }
            }
        });
        spm.register(ServerInitializerStatus.class, (Object)ServerInitializer.getInstance());
        spm.register(ServerPluginManagerListener.class, (Object)ServerInitializer.getInstance());
        spm.register(VetoPower.class, (Object)this.serverInitializer);
        this.serverValuesConnector = new ServerValuesConnectorImpl();
        this.ticketDataConnector = new NewTicketDataConnectorImpl();
        spm.register(ServerValuesConnector.class, (Object)this.serverValuesConnector);
        spm.register(ConnectionFactory.class, (Object)this.connectionFactory);
        spm.register(TicketDataConnector.class, (Object)this.ticketDataConnector);
        spm.register(TicketEventListener.class, (Object)this.ticketDataConnector.getTicketEventListener());
        spm.register(TicketEventListener.class, (Object)TicketRelatedChangeEventDispatcher.getInstance());
        this.timelineDataHandler = new TimelineDataHandlerImpl();
        spm.register(TimelineDataHandler.class, (Object)this.timelineDataHandler);
        spm.register(DataImportConnector.class, (Object)new DataImportConnectorImpl());
        MaintenanceConnectorImpl maintenanceConnector = new MaintenanceConnectorImpl(this.connectionFactory);
        spm.register(MaintenanceConnector.class, (Object)maintenanceConnector);
        spm.register(LocalizationBundle.class, (Object)new LocalizationBundleImpl());
        TicketAccessController accessController = new TicketAccessController();
        spm.register(TicketAccessInformationsProvider.class, (Object)accessController);
        spm.register(TicketEventListener.class, (Object)accessController);
        spm.register(PGPPublicKeyFoundListener.class, (Object)new AutoMailerFactoryImpl());
        spm.register(DBUpdateBackdoor.class, (Object)new DBUpdateComponent());
        spm.register(PluginServlet.class, (Object)new ImagesServlet());
        spm.register(MDNSServletService.class, (Object)new MulticastServlet());
        spm.register(FieldValueModifier.class, (Object)new HDUserImportFieldValueModifier());
        spm.register(FieldValueModifier.class, (Object)new UnchangeableParentFieldValueModifier());
        spm.register(GroupDeletionHandler.class, (Object)new ResourceGroupDeletionHandler());
        spm.runIfPluginLoaded("remotegui", () -> new Executable(){

            public void execute() {
                FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugin/helpdeskconfig/helpdeskconfig.js");
                combinedFile.addMessages(MSG_CLIENT);
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "configAppExtras.js", combinedFile));
                combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                combinedFile.addMessages(new I18nMessages("com.inet.helpdesk.plugin.i18n.Application", (Object)this));
                combinedFile.addMessages(new I18nMessages("com.inet.helpdesk.core.ai.workingpanel.i18n.LanguageResources", (Object)this));
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/core/ai/workingpanel/aiworkingpanel.js");
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 200, "remotegui.lib.js", combinedFile));
                combinedFile = new FileCombiner.CombinedFile("text/html", new URL[0]);
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/config/pages/configuration.templates.html");
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "configuration.templates.html", combinedFile));
                spm.register(PWAPromptFilter.class, (Object)new PWAPromptFilterSupporter());
                spm.register(ServiceMethod.class, (Object)new CancelExecutor());
                spm.runIfPluginLoaded("usersandgroupsmanager", () -> new Executable(){

                    public void execute() {
                        FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                        combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/usersandgroups/ui/js/renderer.js");
                        combinedFile.addMessages(new I18nMessages("com.inet.helpdesk.usersandgroups.ui.i18n.ClientResources", (Object)this));
                        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 200, "remotegui.lib.js", combinedFile));
                        combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                        combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/usersandgroups/ui/js/predeletionhandler.js");
                        combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/usersandgroups/ui/js/setdefaultguipreferencesaction.js");
                        combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/usersandgroups/ui/js/usersandgroupsreports.js");
                        combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/usersandgroups/ui/js/effectiveactionscontroller.js");
                        combinedFile.addMessages(HDFieldDisplayNameProvider.MSG);
                        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 200, "usersandgroupsmanager.js", combinedFile));
                        FileCombiner.CombinedFile effectionActionsDialoghtml = new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[0]);
                        effectionActionsDialoghtml.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/usersandgroups/ui/client/effectiveactionsdialog.html");
                        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 100, "effectiveactionsdialog.html", effectionActionsDialoghtml));
                        spm.register(ServiceMethod.class, (Object)new EffectiveActionsHandler());
                    }
                });
                spm.runIfPluginLoaded("configuration", () -> new Executable(){

                    public void execute() {
                        FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("text/html", new URL[0]);
                        combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/config/autotext/configuration.autotext.html");
                        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "configuration.autotext.html", combinedFile));
                        combinedFile = new FileCombiner.CombinedFile("text/html", new URL[0]);
                        combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/config/autotext/configuration.autotext.edit.html");
                        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "configuration.autotext.edit.html", combinedFile));
                        combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                        combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/config/autotext/configuration.autotext.js");
                        combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/config/autotext/configuration.autotext.edit.js");
                        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "configAppExtras.js", combinedFile));
                        combinedFile = new FileCombiner.CombinedFile("text/html", new URL[0]);
                        combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/config/mailtemplates/configuration.mailtemplates.html");
                        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "configuration.mailtemplates.html", combinedFile));
                        combinedFile = new FileCombiner.CombinedFile("text/html", new URL[0]);
                        combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/config/mailtemplates/configuration.mailtemplates.edit.html");
                        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "configuration.mailtemplates.edit.html", combinedFile));
                        combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                        combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/config/mailtemplates/configuration.mailtemplates.js");
                        combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/config/mailtemplates/configuration.mailtemplates.edit.js");
                        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "configAppExtras.js", combinedFile));
                    }
                });
                spm.runIfPluginLoaded("theme", () -> new Executable(){

                    public void execute() {
                        spm.register(ThemeResource.class, (Object)new ThemeResource("remotegui", ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/attachmentdisplay/css/attachmentdisplay.less")));
                        spm.register(ThemeResource.class, (Object)new ThemeResource("remotegui", ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/core/ai/workingpanel/aiworkingpanel.less")));
                        spm.register(ThemeResource.class, (Object)new ThemeResource("remotegui", ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/config/autotext/css/autotext.less")));
                        spm.register(ThemeResource.class, (Object)new ThemeResource("remotegui", ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/config/autotext/css/autotext-sprites.less")));
                        spm.register(ThemeResource.class, (Object)new ThemeResource("remotegui", ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/config/mailtemplates/css/mailtemplates.less")));
                        spm.register(ThemeResource.class, (Object)new ThemeResource("remotegui", ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/config/mailtemplates/css/mailtemplates-sprites.less")));
                    }
                });
            }
        });
        HdPermissions.TEMPLATE_DEFINITION.getKey();
        spm.register(Filter.class, (Object)new HelpDeskRequestFilter());
        spm.runIfPluginLoaded("theme", () -> new Executable(){

            public void execute() {
                try {
                    HelpDeskThemeService.registerResources(spm);
                }
                catch (Throwable e) {
                    HDLogger.error(e);
                }
            }
        });
        FileCombiner.CombinedFile cssFile = new FileCombiner.CombinedFile("text/css; charset=utf-8", new URL[0]);
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 100, "defaulttheme.css", cssFile));
        cssFile.add(this.getClass(), "/com/inet/helpdesk/theme/css/helpdeskremote.css");
        cssFile.add(this.getClass(), "/com/inet/helpdesk/theme/css/helpdeskremote_sprites.css");
        cssFile.add(this.getClass(), "/com/inet/helpdesk/attachmentdisplay/css/attachmentdisplay.css");
        cssFile.add(this.getClass(), "/com/inet/helpdesk/core/ai/workingpanel/aiworkingpanel.css");
        cssFile.add(this.getClass(), "/com/inet/helpdesk/config/autotext/css/autotext.css");
        cssFile.add(this.getClass(), "/com/inet/helpdesk/config/autotext/css/autotext-sprites.css");
        cssFile.add(this.getClass(), "/com/inet/helpdesk/config/mailtemplates/css/mailtemplates.css");
        cssFile.add(this.getClass(), "/com/inet/helpdesk/config/mailtemplates/css/mailtemplates-sprites.css");
        cssFile.add(this.getClass(), "/com/inet/helpdesk/ticketfieldsettings/config/css/ticketfields-sprites.css");
        ConfigurationManager.getInstance().addConfigurationMigrator((ConfigurationMigrator)new TicketIdUidConfigMigrator());
        ConfigurationManager.getInstance().addConfigurationMigrator((ConfigurationMigrator)new EmailAccountIdConfigMigrator());
        ConfigurationManager.getInstance().addConfigurationMigrator((ConfigurationMigrator)new LogoFileMigrator());
        ConfigurationManager.getInstance().addConfigurationMigrator(new ConfigurationMigrator(){

            public void migrate(Configuration config) {
                boolean isSupporterSet;
                String clientStartOption = config.get(HDConfigKeys.CLIENT_START_OPTION);
                Integer clientStartOptionInt = Integer.valueOf(clientStartOption);
                boolean bl = isSupporterSet = (clientStartOptionInt & 0x10000000) != 0;
                if (isSupporterSet) {
                    config.put(HDConfigKeys.MAIL_SENDER_ORDER, "04");
                }
                config.put(HDConfigKeys.CLIENT_START_OPTION, "" + (clientStartOptionInt & 0xEFFFFFFF));
            }
        });
        ConfigurationManager.getInstance().addConfigurationMigrator((ConfigurationMigrator)new EnduserEmailFilterMigrator());
        StatusAndItilChangeTrigger.registerTriggerAsListener(spm);
        spm.register(ConnectionCreationListener.class, () -> TicketManager.getReader());
        this.defaultValueManagerImpl = new DefaultValueManagerImpl();
        spm.register(DefaultValuesManager.class, (Object)this.defaultValueManagerImpl);
        spm.register(MandatoryFieldsManager.class, (Object)new MandatoryFieldsManagerImpl());
        HDUsersAndGroups.getUserFieldsForRegistration().forEach(field -> spm.register(UserField.class, field));
        HDUsersAndGroups.getGroupFieldsForRegistration().forEach(field -> spm.register(UserGroupField.class, field));
        HDUsersAndGroups.getFieldAndGroupTypeAssociationsForRegistration().forEach(entry -> spm.register(FieldAndGroupTypeAssociation.class, entry));
        HDUsersAndGroups.getGroupTypeDefinitionsForRegistration().forEach(def -> spm.register(GroupTypeDef.class, def));
        HDUsersAndGroups.getPredefinedUserGroupsForRegistration().forEach(group -> spm.register(PredefinedUserGroup.class, group));
        spm.register(AdditionalFieldSetting.class, (Object)new AdditionalFieldSetting(){

            @Override
            public String getImageName(String fieldName, int typeId, int id, String stringKey) {
                if (typeId == 47123) {
                    return stringKey.endsWith("deleted") ? "delete_16.gif" : "resources_16.gif";
                }
                return null;
            }
        });
        spm.register(ConnectionCreationListener.class, () -> {
            BiConsumer<Object, Object> notifyManagers = (manager, recEnabledManager) -> {
                if (manager instanceof ConnectionCreationListener) {
                    ((ConnectionCreationListener)manager).connectionCreated();
                }
                if (recEnabledManager != manager && recEnabledManager instanceof ConnectionCreationListener) {
                    ((ConnectionCreationListener)recEnabledManager).connectionCreated();
                }
            };
            notifyManagers.accept(UserManager.getInstance(), UserManager.getRecoveryEnabledInstance());
            notifyManagers.accept(UserGroupManager.getInstance(), UserGroupManager.getRecoveryEnabledInstance());
        });
        spm.register(Filter.class, (Object)new LocaleFilter());
        spm.register(UserManagerFactory.class, (Object)new HelpDeskUserManagerFactory());
        spm.register(UserGroupManagerFactory.class, (Object)new HelpDeskUserGroupManagerFactory());
        spm.register(UserSearchFilter.class, (Object)new UserSearchFilterHD());
        spm.register(UserOrGroupFilter.class, (Object)new DispatcherUserFilter());
        spm.register(UserOrGroupFilter.class, (Object)new EndUserFilter());
        spm.register(UserOrGroupFilter.class, (Object)new NamedUserFilter());
        spm.register(UserOrGroupFilter.class, (Object)new ResourceGroupsFilter());
        spm.register(UserOrGroupFilter.class, (Object)new SupporterUserFilter());
        spm.runIfPluginLoaded("collaboration", () -> new Executable(){

            public void execute() {
                spm.register(BotCommand.class, (Object)new TicketInfoBotCommand());
                spm.register(BotCommand.class, (Object)new TicketSearchBotCommand());
                TicketCreationMultiCommand multiCommand = new TicketCreationMultiCommand();
                spm.register(BotCommand.class, (Object)multiCommand);
            }
        });
        spm.runIfPluginLoaded("ai", () -> new Executable(){

            public void execute() {
                spm.register(ServiceMethod.class, (Object)new GetRewriteTextWithAI());
            }
        });
        DynamicExtensionManager dem = DynamicExtensionManager.getInstance();
        dem.register(FieldDefinition.class, (Object)new ImportedHintUserFieldDefinition("user.masterdata", 0));
        LocationUserFieldDefinition location = new LocationUserFieldDefinition(120){};
        dem.register(FieldDefinition.class, (Object)location);
        dem.register(TicketFieldDefinition.class, (Object)new TicketFieldDefinitionTicketOwnerLocationId((UserFieldDefinition<?>)location, 350));
        dem.register(TicketFieldDefinition.class, (Object)new TicketFieldDefinitionTicketOwnerLocationInfo(470));
        UserClassUserFieldDefinition usergroupID = new UserClassUserFieldDefinition(125){};
        dem.register(FieldDefinition.class, (Object)usergroupID);
        dem.register(TicketFieldDefinition.class, (Object)new TicketFieldDefinitionTicketOwnerGroupId((UserFieldDefinition<?>)usergroupID, 320));
        HDStringUserFieldDefinition room = new HDStringUserFieldDefinition("user.masterdata", 140, HDUsersAndGroups.FIELD_ROOM){

            public boolean isBatchEditable() {
                return true;
            }
        };
        dem.register(FieldDefinition.class, (Object)room);
        dem.register(TicketFieldDefinition.class, (Object)new AbstractTicketFieldDefinitionForTicketOwner((UserFieldDefinition)room, 380){});
        LanguageUserFieldDefinition language = new LanguageUserFieldDefinition(170);
        dem.register(FieldDefinition.class, (Object)language);
        dem.register(TicketFieldDefinition.class, (Object)new TicketFieldDefinitionTicketOwnerLanguage((UserFieldDefinition)language, 390){});
        HDStringUserFieldDefinition computername = new HDStringUserFieldDefinition("user.masterdata", 180, HDUsersAndGroups.FIELD_COMPUTER_NAME){
            {
                this.setEditability(UF_Editability.READ_ONLY_FOR_ALL);
            }

            public FieldValue getFieldValue(UserAccount userAccount) {
                FieldValue fieldValue = super.getFieldValue(userAccount);
                fieldValue.setEnabled(this.isEnabled());
                return fieldValue;
            }
        };
        dem.register(FieldDefinition.class, (Object)computername);
        dem.register(TicketFieldDefinition.class, (Object)new AbstractTicketFieldDefinitionForTicketOwner((UserFieldDefinition)computername, 460){});
        HDStringUserFieldDefinition costCenter = new HDStringUserFieldDefinition("user.masterdata", 190, HDUsersAndGroups.FIELD_COST_CENTRE){

            public boolean isBatchEditable() {
                return true;
            }
        };
        dem.register(FieldDefinition.class, (Object)costCenter);
        dem.register(TicketFieldDefinition.class, (Object)new AbstractTicketFieldDefinitionForTicketOwner((UserFieldDefinition)costCenter, 370){});
        dem.register(FieldDefinition.class, (Object)new HintUserFieldDefinition(LumpSumUserFieldPanelDefinition.FIELD_PANEL_KEY, 1){

            public String getHint() {
                return HDFieldDisplayNameProvider.MSG.getMsg("field.lumpsum.hint", new Object[0]);
            }
        });
        dem.register(FieldDefinition.class, (Object)new LumpSumUserFieldDefinition(LumpSumUserFieldPanelDefinition.FIELD_PANEL_KEY, HDUsersAndGroups.FIELD_LUMP_SUM_1, 310));
        dem.register(FieldDefinition.class, (Object)new LumpSumUserFieldDefinition(LumpSumUserFieldPanelDefinition.FIELD_PANEL_KEY, HDUsersAndGroups.FIELD_LUMP_SUM_2, 320));
        dem.register(FieldDefinition.class, (Object)new LumpSumUserFieldDefinition(LumpSumUserFieldPanelDefinition.FIELD_PANEL_KEY, HDUsersAndGroups.FIELD_LUMP_SUM_3, 330));
        dem.register(FieldDefinition.class, (Object)new HDStringUserFieldDefinition("user.masterdata", 181, HDUsersAndGroups.FIELD_CLIENT_DETAILS){
            {
                this.setEditability(UF_Editability.READ_ONLY_FOR_ALL);
            }

            public FieldValue getFieldValue(UserAccount userAccount) {
                FieldValue fieldValue = super.getFieldValue(userAccount);
                fieldValue.setEnabled(this.isEnabled());
                return fieldValue;
            }
        });
        spm.runIfPluginLoaded("fieldsettings", () -> new Executable(){

            public void execute() {
                HDUserFieldsConfigStructureProvider structureProvider = new HDUserFieldsConfigStructureProvider();
                spm.register(ConfigStructureProvider.class, (Object)structureProvider);
                spm.register(UserFieldSettingsPropertyExtension.class, (Object)new HDUserFieldSettingPropertyExtension(structureProvider));
                spm.register(UserFieldSettingsManagerFactory.class, () -> new UserFieldSettingManagerHD());
                spm.register(FieldSettingsSelectValueProvider.class, (Object)new SqlQuerySelectValueProvider());
                FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/core/ticketfieldsettings/config/js/TicketFieldSettingsPropertyRenderer.js");
                combinedFile.addMessages(TicketFieldSettingsManager.MSG);
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "configAppExtras.js", combinedFile));
                spm.runIfPluginLoaded("theme", () -> new Executable(){

                    public void execute() {
                        spm.register(ThemeResource.class, (Object)new ThemeResource("remotegui", ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/core/ticketfieldsettings/config/css/ticketfields-sprites.less")));
                    }
                });
            }
        });
        spm.register(StatisticalUserDetails.class, (Object)new NamedUserDetails());
        spm.register(StatisticalUserDetails.class, (Object)new MaxUserDetails());
        spm.register(FieldPanelDefinition.class, (Object)new LumpSumUserFieldPanelDefinition(UserAccountType.Standard));
        spm.register(FieldPanelDefinition.class, (Object)new LumpSumUserFieldPanelDefinition(UserAccountType.Guest));
        spm.register(FieldPanelDefinition.class, (Object)new ResourcesStandardUserFieldPanelDefinition());
        spm.register(FieldPanelDefinition.class, (Object)new ResourcesGuestFieldPanelDefinition());
        spm.register(FieldPanelDefinition.class, (Object)new ResourcesMasterFieldPanelDefinition());
        dem.register(FieldDefinition.class, (Object)new MembershipsUserFieldDefinition(ResourcesStandardUserFieldPanelDefinition.FIELD_GROUP_KEY, "fieldtype_members" + HDUsersAndGroups.RESOURCE.getName(), HDUsersAndGroups.RESOURCE, "resourcesonly", 100));
        dem.register(FieldDefinition.class, (Object)new MembershipsUserFieldDefinition(ResourcesGuestFieldPanelDefinition.FIELD_GROUP_KEY, "fieldtype_members" + HDUsersAndGroups.RESOURCE.getName(), HDUsersAndGroups.RESOURCE, "resourcesonly", 100));
        dem.register(FieldDefinition.class, (Object)new MembershipsUserFieldDefinition(ResourcesMasterFieldPanelDefinition.FIELD_GROUP_KEY, "fieldtype_members" + HDUsersAndGroups.RESOURCE.getName(), HDUsersAndGroups.RESOURCE, "resourcesonly", 100));
        dem.register(FieldDefinition.class, (Object)new AllowedActionsUserFieldDefinition());
        spm.register(FieldPanelDefinition.class, (Object)new AllowedActionsFieldPanelDefinition(UserAccountType.Standard));
        spm.register(FieldPanelDefinition.class, (Object)new AllowedActionsFieldPanelDefinition(UserAccountType.Guest));
        dem.register(FieldDefinition.class, (Object)new AllowedActionsGroupFieldDefinition());
        spm.register(FieldPanelDefinition.class, (Object)new AllowedActionsFieldPanelDefinition(UsersAndGroups.GROUPTYPE_ALLUSERS, 505));
        spm.register(FieldPanelDefinition.class, (Object)new AllowedActionsFieldPanelDefinition(UsersAndGroups.GROUPTYPE_STANDARD, 505));
        spm.register(FieldPanelDefinition.class, (Object)new AllowedActionsFieldPanelDefinition(UsersAndGroups.GROUPTYPE_AUTH, 505));
        spm.register(FieldPanelDefinition.class, (Object)new AllowedActionsFieldPanelDefinition(HDUsersAndGroups.GROUPTYPE_SUPPORTERS, 205));
        spm.register(FieldPanelDefinition.class, (Object)new AllowedActionsFieldPanelDefinition(HDUsersAndGroups.GROUPTYPE_ENDUSER, 205));
        spm.register(FieldPanelDefinition.class, (Object)new AllowedActionsFieldPanelDefinition(HDUsersAndGroups.RESOURCE, 205));
        spm.register(FieldPanelDefinition.class, (Object)new PermissionsGroupFieldPanelDefinition(HDUsersAndGroups.GROUPTYPE_SUPPORTERS, PermissionsGroupFieldPanelDefinition.FIELD_PANEL_KEY_SUPPORTERS));
        dem.register(FieldDefinition.class, (Object)new PermissionGroupFieldDefinition(PermissionsGroupFieldPanelDefinition.FIELD_PANEL_KEY_SUPPORTERS, "fieldtype_permission", 100));
        spm.register(PermissionPatcher.class, (Object)new SupportersPermissionPatcher());
        spm.register(FieldPanelDefinition.class, (Object)new PermissionsGroupFieldPanelDefinition(HDUsersAndGroups.GROUPTYPE_ENDUSER, PermissionsGroupFieldPanelDefinition.FIELD_PANEL_KEY_ENDUSERS));
        dem.register(FieldDefinition.class, (Object)new PermissionGroupFieldDefinition(PermissionsGroupFieldPanelDefinition.FIELD_PANEL_KEY_ENDUSERS, "fieldtype_permission", 100));
        spm.register(FieldPanelDefinition.class, (Object)new PermissionsGroupFieldPanelDefinition(HDUsersAndGroups.RESOURCE, PermissionsGroupFieldPanelDefinition.FIELD_PANEL_KEY_RESOURCES));
        spm.register(FieldPanelDefinition.class, (Object)new MembersResourcesGroupFieldPanelDefinition());
        spm.register(FieldPanelDefinition.class, (Object)new GeneralResourcesGroupFieldPanelDefinition());
        spm.register(FieldPanelDefinition.class, (Object)new NotificationSettingsResourcesGroupFieldPanelDefinition());
        spm.register(FieldPanelDefinition.class, (Object)new WorkingHoursResourcesGroupFieldPanelDefinition());
        spm.register(PermissionPatcher.class, (Object)new ResourcesPermissionPatcher());
        dem.register(FieldDefinition.class, (Object)new PermissionGroupFieldDefinition(PermissionsGroupFieldPanelDefinition.FIELD_PANEL_KEY_RESOURCES, "fieldtype_permission", 100));
        dem.register(FieldDefinition.class, (Object)new MembersGroupFieldDefinition("resource.members", HDUsersAndGroups.RESOURCE, "fieldtype_members", 100));
        dem.register(FieldDefinition.class, (Object)new GroupNameFieldDefinition("resource.general", 10));
        Arrays.stream(DayOfWeek.values()).forEach(dayOfWeek -> dem.register(FieldDefinition.class, (Object)new ResHourRangeGroupFieldDefinition(WorkingHoursResourcesGroupFieldPanelDefinition.FIELD_GROUP_KEY, (DayOfWeek)dayOfWeek)));
        dem.register(FieldDefinition.class, (Object)new EmailGroupFieldDefinition("resource.general", HDUsersAndGroups.RES_FIELD_EMAIL.getKey(), 15){

            public String getLabel() {
                return HDFieldDisplayNameProvider.MSG.getMsg("field.resourceemail", new Object[0]);
            }

            public boolean isAvailable(UserGroupInfo userGroup) {
                return SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_CREATEUSERS);
            }
        });
        dem.register(FieldDefinition.class, (Object)new ParentIdGroupFieldDefinition("resource.general", "resourceparentid", 20, HDUsersAndGroups.RESOURCE, HDUsersAndGroups.GROUPTYPEDEF_RESOURCE.getMaxTreeLevel()){

            public String getLabel() {
                return HDFieldDisplayNameProvider.MSG.getMsg("field.resourceparent", new Object[0]);
            }
        });
        dem.register(FieldDefinition.class, (Object)new OtherResourcesGroupFieldDefinition());
        dem.register(FieldDefinition.class, (Object)new ResSettingsGroupFieldDefinition("resource.general", 30, 1));
        dem.register(FieldDefinition.class, (Object)new ResSettingsGroupFieldDefinition("resource.general", 40, 2));
        dem.register(FieldDefinition.class, (Object)new CurrencyGroupFieldDefinition("resource.general", HDUsersAndGroups.RES_FIELD_HOURLY_RATE.getKey(), 60){

            public String getLabel() {
                return HDFieldDisplayNameProvider.MSG.getMsg("field.resourcehourlyrate", new Object[0]);
            }
        });
        dem.register(FieldDefinition.class, (Object)new EscalationGroupFieldDefinition("resource.general", HDUsersAndGroups.RES_FIELD_ESC_RES_ID, 70));
        dem.register(FieldDefinition.class, (Object)new ResSettingsGroupFieldDefinition("resource.notificationsettings", 20, 4));
        dem.register(FieldDefinition.class, (Object)new ResNotificationSettingsGroupFieldDefinition("resource.notificationsettings", 30, 4));
        spm.register(NotificationGroup.class, (Object)new ResourceNotificationGroup());
        spm.register(NotificationGroup.class, (Object)new EmailErrorNotificationGroup());
        spm.register(UserOrGroupAdditionalDetailProvider.class, (Object)new HDUserOrGroupAdditionalDetailProvider());
        spm.register(CustomUserAction.class, (Object)new SetAsDefaultGUIPreferencesCustomUserAction());
        spm.register(CustomUserAction.class, (Object)new ResetAndSetAsDefaultGUIPreferencesCustomUserAction());
        spm.register(LoginListener.class, (Object)new ComputerNameSetter());
        Tickets.getAttributesForRegistration().forEach(att -> spm.register(TicketAttribute.class, (Object)att));
        Tickets.getFieldsForRegistration().forEach(field -> spm.register(TicketField.class, (Object)field));
        Tickets.getFieldDefinitionsForRegistration().forEach(fieldDefinition -> DynamicExtensionManager.getInstance().register(TicketFieldDefinition.class, fieldDefinition));
        ReaStepVO.getAttributesForRegistration().forEach(att -> spm.register(ReaStepAttribute.class, (Object)att));
        ReaStepVO.getFieldsForRegistration().forEach(field -> spm.register(ReaStepField.class, (Object)field));
        ExtensionArguments.getExtArgsForRegistration().forEach(extArg -> spm.register(ExtensionArguments.ExtArg.class, extArg));
        spm.register(ExtensionArguments.ExtArg.class, UnbundleTicketActionExtensionFactory.EXTARG_UNBUNDLE_TICKETS);
        SearchTagTicketTags.getTagsForRegistration().forEach(tag -> spm.register(SearchTagTicketTags.TicketTag.class, tag));
        spm.register(PluggableTicketSearchTag.class, (Object)new AccessSearchTag("additionalAccessGroups", Type.group));
        spm.register(PluggableTicketSearchTag.class, (Object)new AccessSearchTag("additionalAccessUsers", Type.user));
        spm.register(TicketActionExtensionFactory.class, (Object)new EscalateOrAuthorizeTicketActionExtensionFactory());
        spm.register(TicketActionExtensionFactory.class, (Object)new BundleTicketActionExtensionFactory());
        spm.register(TicketActionExtensionFactory.class, (Object)new UnbundleTicketActionExtensionFactory());
        spm.register(TicketActionExtensionFactory.class, (Object)new ReactivateTicketActionExtensionFactory());
        spm.register(TicketActionExtensionFactory.class, (Object)new AppointmentTimeActionExtensionFactory());
        spm.register(TicketActionExtensionFactory.class, (Object)new UpdateReaStepTextExtensionFactory());
        spm.register(TicketActionExtensionFactory.class, (Object)new DeadlineMahnenTicketActionExtensionFactory());
        spm.register(TicketActionExtensionFactory.class, (Object)new CloseTicketActionExtensionFactory());
        spm.register(TicketActionExtensionFactory.class, (Object)new ReopenTicketActionExtensionFactory());
        spm.register(TicketActionExtensionFactory.class, (Object)new DuplicatedContentExtensionFactory());
        spm.register(AutoTextManager.class, (Object)new AutoTextManager());
        DeadlineUpdateExtensionFactory deadlineUpdateExtensionFactory = new DeadlineUpdateExtensionFactory();
        spm.register(CreateTicketExtensionFactory.class, (Object)deadlineUpdateExtensionFactory);
        spm.register(UpdateTicketDataExtension.class, (Object)deadlineUpdateExtensionFactory);
        spm.register(CreateTicketExtensionFactory.class, (Object)new CreateTicketFromMailExtension());
        spm.register(VetoPower.class, (Object)new VetoPower(){

            @Nonnull
            public VetoType getType() {
                return TicketManagerVetoPower.TYPE;
            }

            public VetoSemaphore checkForVeto() {
                return TicketManager.getVetoPower().checkForVeto();
            }
        });
        spm.register(TicketManagerFactory.class, (Object)new TicketManagerFactoryImpl());
        spm.register(UserEventListener.class, (Object)new UserEventAdapter(){

            public void userAccountBeforeDeleted(@Nonnull UserAccount userAccount) {
                REMOVE_USERREFERENCES_ON_DELETE.userAccountBeforeDeleted(userAccount);
            }
        });
        ItilLinkManagerImpl itilLinkManager = new ItilLinkManagerImpl();
        spm.register(ItilLinkManager.class, (Object)itilLinkManager);
        spm.register(ConnectionCreationListener.class, (Object)itilLinkManager);
        spm.register(UserGroupField.class, UserFieldsWithClientSettings.USER_FIELDS_WITH_CLIENT_SETTINGS);
        spm.register(FieldAndGroupTypeAssociation.class, (Object)new FieldAndGroupTypeAssociation(UsersAndGroups.GROUPTYPE_ALLUSERS, new HashSet<String>(Arrays.asList(UserFieldsWithClientSettings.USER_FIELDS_WITH_CLIENT_SETTINGS.getKey()))));
        spm.register(FieldAndGroupTypeAssociation.class, (Object)new FieldAndGroupTypeAssociation(UsersAndGroups.GROUPTYPE_STANDARD, new HashSet<String>(Arrays.asList(UserFieldsWithClientSettings.USER_FIELDS_WITH_CLIENT_SETTINGS.getKey()))));
        spm.register(UserFieldsWithClientSettings.class, (Object)new UserFieldsWithClientSettingsForTicketList());
        spm.register(ConnectionCreationListener.class, (Object)new DefaultValueInitializer());
        spm.register(TicketViewManager.class, (Object)new TicketViewManagerImpl());
        spm.register(UserField.class, TicketViewManager.TICKET_VIEW_USERFIELD);
        spm.register(UserField.class, TicketViewManager.TICKET_VIEW_VISIBILITY);
        spm.register(UserGroupField.class, TicketViewManager.GLOBAL_TICKET_VIEW);
        spm.register(FieldAndGroupTypeAssociation.class, (Object)new FieldAndGroupTypeAssociation(UsersAndGroups.GROUPTYPE_ALLUSERS, new String[]{TicketViewManager.GLOBAL_TICKET_VIEW.getKey()}));
        spm.register(TicketEventListener.class, (Object)TicketViewTicketEventListener.getInstance());
        spm.register(TicketEventListener.class, (Object)new EventLogTicketEventListener());
        spm.register(TicketEventListener.class, (Object)new ItilChangedTicketEventListener());
        spm.register(TicketEventListener.class, (Object)this.timelineDataHandler);
        spm.runIfPluginLoaded("statistics", () -> new Executable(){

            public void execute() {
                spm.register(EventLogDescription.class, (Object)new TicketEventLogDescription());
                spm.register(EventLogDescription.class, (Object)new TemplateEventLogDescription());
                spm.register(EventLogDescription.class, (Object)new MailErrorEventLogDescription());
            }
        });
        spm.register(UserGroupEventListener.class, (Object)new TicketViewGroupEventListener());
        spm.register(UserEventListener.class, (Object)new TicketViewUserEventListener());
        spm.register(TicketViewFactory.class, (Object)new OwnTicketViewDefinition());
        spm.register(TicketViewFactory.class, (Object)new SupervisorTicketViewDefinition());
        spm.register(TicketViewFactory.class, (Object)new InquiryTicketViewDefinition());
        spm.register(TicketViewFactory.class, (Object)new OpenTicketViewDefinition());
        spm.register(TicketViewFactory.class, (Object)new LastEditorTicketViewDefinition());
        spm.register(TicketViewFactory.class, (Object)new SharedWithMeTicketViewDefinition());
        spm.register(TicketViewFactory.class, (Object)new UnreadTicketViewDefinition());
        spm.register(SubViewGroupingDefinition.class, (Object)ResourceSubViewGrouping.INSTANCE);
        spm.register(SubViewGroupingDefinition.class, (Object)MyResourceSubViewGrouping.INSTANCE);
        spm.register(SubViewGroupingDefinition.class, (Object)SupervisorSubViewGrouping.INSTANCE);
        spm.register(SubViewGroupingDefinition.class, (Object)PrioritySubViewGrouping.INSTANCE);
        spm.register(SubViewGroupingDefinition.class, (Object)CategorySubViewGrouping.INSTANCE);
        spm.register(SubViewGroupingDefinition.class, (Object)new TicketFieldSubViewGrouping(Tickets.FIELD_CLASSIFICATION_ID));
        spm.register(SubViewGroupingDefinition.class, (Object)new UserFieldSubViewGrouping(HDUsersAndGroups.FIELD_LOCATION_ID));
        spm.register(SubViewGroupingDefinition.class, (Object)ItilSubViewGrouping.INSTANCE);
        spm.register(SubViewGroupingDefinition.class, (Object)ItilMasterSubViewGrouping.INSTANCE);
        spm.register(SubViewGroupingDefinition.class, (Object)new TicketFieldSubViewGrouping(Tickets.FIELD_IDENTIFIER));
        ItilMasterSubViewGroupingEventListener itilMasterSubViewGroupingEventListener = new ItilMasterSubViewGroupingEventListener();
        ItilManager.getInstance().addDataChangeListener(itilMasterSubViewGroupingEventListener);
        itilLinkManager.registerListener(itilMasterSubViewGroupingEventListener);
        spm.register(TicketViewCategory.class, (Object)new TicketViewCategory("globalsearch"));
        spm.register(TicketViewCategory.class, (Object)new TicketViewCategory("globalviews"));
        spm.register(TicketViewCategory.class, (Object)new TicketViewCategory("myviews"));
        spm.register(TicketViewCategory.class, (Object)new TicketViewCategory("supervisor", () -> SupervisorSubViewGrouping.INSTANCE.getDisplayName(), () -> SupervisorSubViewGrouping.INSTANCE.getDescription()));
        spm.register(TicketViewCategory.class, (Object)new TicketViewCategory("resourceid", () -> Tickets.FIELD_RESOURCE_GUID.getLabel()));
        spm.register(TicketViewCategory.class, (Object)new TicketViewCategory("itil", () -> Tickets.FIELD_ITIL_ID.getLabel()));
        spm.register(TicketViewCategory.class, (Object)new TicketViewCategory("priority", () -> Tickets.FIELD_PRIORITY_ID.getLabel()));
        spm.register(ConnectionCreationListener.class, () -> this.timelineDataHandler.init());
        new ReportingServerPluginRegistration().registerExtension(spm);
        spm.runIfPluginLoaded("webapi.core", () -> new Executable(){

            public void execute() {
                HelpDeskTicketWebAPIExtension.registerExtension(spm, new HelpDeskTicketSearchHandler());
            }
        });
        spm.register(ActionCreationNotificator.class, (Object)new ActionCreationNotificatorImpl());
        DefaultMailTemplates.registerDefaultMailTemplates(spm);
        spm.runIfPluginLoaded("remotegui", () -> new Executable(){

            public void execute() {
                spm.register(ServiceMethod.class, (Object)new AttachmentDisplay());
                FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/attachmentdisplay/attachmentdisplay.js");
                combinedFile.addMessages(AttachmentDisplay.MSG);
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 201, "helpdesk.attachmentdisplay.js", combinedFile));
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "configAppExtras.js", combinedFile));
            }
        });
        spm.runIfPluginLoaded("mail", () -> new Executable(){

            public void execute() {
                MailAttachmentDisplayProvider mailTextAttachmentDisplayProvider = new MailAttachmentDisplayProvider();
                spm.register(AttachmentDisplayProvider.class, (Object)mailTextAttachmentDisplayProvider);
                spm.register(HttpSessionListener.class, (Object)mailTextAttachmentDisplayProvider);
            }
        });
        spm.register(AttachmentDisplayProvider.class, (Object)new ImageAttachmentDisplayProvider());
        spm.register(AttachmentDisplayProvider.class, (Object)new VideoAttachmentDisplayProvider());
        spm.register(AttachmentDisplayProvider.class, (Object)new PlainTextAttachmentDisplayProvider());
        spm.register(AttachmentDisplayProvider.class, (Object)new HtmlTextAttachmentDisplayProvider());
        spm.register(AttachmentDisplayProvider.class, (Object)new ClearReportsAttachmentDisplayProvider());
        spm.register(AttachmentDisplayProvider.class, (Object)new VCardPackageAttachmentDisplayProvider());
        spm.register(AttachmentDisplayProvider.class, (Object)new CalendarAttachmentDisplayProvider());
        spm.register(AttachmentDisplayProvider.class, (Object)new PDFAttachmentDisplayProvider());
        spm.register(AttachmentDisplayProvider.class, (Object)new ZipAttachmentDisplayProvider());
        spm.runIfPluginLoaded("adhoc", () -> new Executable(){

            public void execute() {
                spm.register(ServerPluginManagerListener.class, (Object)new ServerPluginManagerListener(){

                    public void vetoFinished(@Nullable VetoType type) {
                        if (type == null) {
                            new Thread(() -> {
                                try {
                                    LocalConfigChangeListener listener = new LocalConfigChangeListener();
                                    ConfigurationManager manager = ConfigurationManager.getInstance();
                                    listener.init(manager.getCurrent());
                                    manager.addConfigurationChangeListener((ConfigurationChangeListener)listener);
                                }
                                catch (Throwable th) {
                                    HDLogger.debug(th);
                                }
                            }, "Ad Hoc Cache Initializer").start();
                        }
                    }
                });
                spm.register(ConfigStructureProvider.class, (Object)new HDAdhocStructureProvider());
            }
        });
        spm.register(ServerPluginManagerListener.class, (Object)new ServerPluginManagerListener(){

            public void vetoFinished(@Nullable VetoType type) {
                ActionManager actionManager;
                ActionVO actionVO;
                if (type == null && ((actionVO = (ActionVO)(actionManager = ActionManager.getInstance()).get(-16)).getSpecial() & 4) == 0) {
                    actionManager.get(-16);
                    try {
                        actionManager.update(new ActionVO(actionVO.getId(), actionVO.getDisplayValue(), -100, true, actionVO.getBillingType(), actionVO.getLumpSumType(), actionVO.getFixedCharge(), actionVO.isDeleted(), actionVO.getSpecial() | 4, actionVO.isHidden()));
                    }
                    catch (SQLException e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
        });
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void init(final ServerPluginManager spm) {
        if (ConfigurationManager.isHelpCenterMode()) {
            return;
        }
        try {
            HdPermissions.addFreePermission(Permission.valueOf((String)"cowork"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.throwIfValuesOfRegisteredExtArgsDoNotImplementHashCodeAndEquals(spm);
        @Nonnull List fieldDefinitions = DynamicExtensionManager.getInstance().get(FieldDefinition.class);
        fieldDefinitions.stream().filter(f -> f instanceof LoginsUserFieldDefinition).findFirst().ifPresent(f -> DynamicExtensionManager.getInstance().unregister(FieldDefinition.class, f));
        HDLoginsUserFieldDefinition loginFieldDef = new HDLoginsUserFieldDefinition("logins", "logins", 100);
        DynamicExtensionManager.getInstance().register(FieldDefinition.class, (Object)loginFieldDef);
        TicketFieldSettingsManager.getInstance().init();
        this.serverInitializer.start();
        this.serverValuesConnector.init();
        this.ticketDataConnector.init(UserManager.getInstance(), spm);
        new ReportingServerPluginRegistration().init(spm);
        ((ItilLinkManager)spm.getSingleInstance(ItilLinkManager.class)).registerListener(new GeneratedAttributeItilCountEventListener());
        spm.runIfPluginLoaded("configuration", () -> new Executable(){

            public void execute() {
                ConfigAngularApplicationServlet configAngularApplicationServlet = (ConfigAngularApplicationServlet)spm.getSingleInstance(ConfigAngularApplicationServlet.class);
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new ScaledTicketValueIcon());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new LoadAvailableAutoTexts());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new AutoTextIcon());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new CreateOrEditAutoText());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new SaveAutoText());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new DeleteAutoText());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new LoadMailTemplates());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new LoadMailTemplatesSettings());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new LoadMailTemplatesEditor());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new SaveMailTemplatesEditor());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new CreateSetHandler());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new DeleteLangHandler());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new DeleteSetHandler());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new DeleteMailTemplateHandler());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new LoadDefaultMailTemplatesHandler());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new LoadMailConfigSettings());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new SaveMailConfigSettings());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new MoveMailTemplateHandler());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new LoadTemplateDataHandler());
            }
        });
    }

    private void throwIfValuesOfRegisteredExtArgsDoNotImplementHashCodeAndEquals(ServerPluginManager spm) {
        for (ExtensionArguments.ExtArg extArg : spm.get(ExtensionArguments.ExtArg.class)) {
            try {
                if (extArg.getValueType().isEnum() || extArg instanceof ExtensionArguments.NonJsonizableExtArg) continue;
                Method methodHashCode = extArg.getValueType().getMethod("hashCode", new Class[0]);
                if (methodHashCode.getDeclaringClass() != extArg.getValueType()) {
                    throw new IllegalStateException("ValueType of ExtArg with key \"" + extArg.getKey() + "\" must implement hashCode.");
                }
                Method methodEquals = extArg.getValueType().getMethod("equals", Object.class);
                if (methodEquals.getDeclaringClass() == extArg.getValueType()) continue;
                throw new IllegalStateException("ValueType of ExtArg with key \"" + extArg.getKey() + "\" must implement equals.");
            }
            catch (NoSuchMethodException | SecurityException ex) {
                HDLogger.error("Error while checking whether ValueType of ExtArg with key \"" + extArg.getKey() + "\" implements hashCode and equals.");
                throw new RuntimeException(ex);
            }
        }
    }

    public void reset() {
        this.serverInitializer.interruptExecution();
    }

    public void restart() {
    }

    @Nonnull
    public RecoveryLauncher getRecoveryLauncher() {
        return new HdStandaloneConfiguration();
    }

    public ApplicationDescription getApplicationDescription() {
        return new HelpdeskApplicationDescription();
    }

    static {
        ConfigurationManager.NAME_DEFAULT = HelpDeskInstanceName.get();
        REMOVE_USERREFERENCES_ON_DELETE = new UserEventAdapter(){

            public void userAccountBeforeDeleted(@Nonnull UserAccount userAccount) {
                TicketManager.getMaintenance().removeReferencesToUserAccountFromAllTicketsAndReaSteps(userAccount.getID());
                ((AutoTextManager)ServerPluginManager.getInstance().getSingleInstance(AutoTextManager.class)).cleanUpAutoTextsOfUser(userAccount);
                UserClassManager.getInstance().cleanUpSuperVisors(HDUsersAndGroups.getUserID(userAccount.getID()));
            }
        };
    }
}

