/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.helpdesk.core.model.ticket.BillingInformation;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

public class ServerDataUtil {
    public static void closeAll(Connection con, Statement pst, ResultSet rs) {
        try {
            rs.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            pst.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            con.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static BillingInformation getBilling(int actionId, UserAccount user) {
        BillingInformation billing = new BillingInformation();
        ActionVO actionVO = (ActionVO)ActionManager.getInstance().get(actionId);
        if (actionVO == null) {
            return null;
        }
        int billingType = actionVO.getBillingType();
        if (billingType == 0) {
            billing.setLumpSum(null);
        } else {
            int lumpSumType = actionVO.getLumpSumType();
            double actionLumpSum = actionVO.getFixedCharge();
            if (lumpSumType == 0) {
                billing.setLumpSum(new BigDecimal(actionLumpSum));
            } else if (lumpSumType != -1) {
                Double lumpSum = null;
                switch (lumpSumType) {
                    case 1: {
                        lumpSum = (Double)user.getValue((UserField)HDUsersAndGroups.FIELD_LUMP_SUM_1);
                        break;
                    }
                    case 2: {
                        lumpSum = (Double)user.getValue((UserField)HDUsersAndGroups.FIELD_LUMP_SUM_2);
                        break;
                    }
                    case 3: {
                        lumpSum = (Double)user.getValue((UserField)HDUsersAndGroups.FIELD_LUMP_SUM_3);
                    }
                }
                if (lumpSum != null) {
                    actionLumpSum = lumpSum;
                }
                billing.setLumpSum(new BigDecimal(actionLumpSum));
            } else {
                billing.setLumpSum(null);
            }
        }
        billing.setHourlyRated(billingType != 1);
        return billing;
    }
}

