/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups;

import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassVO;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.shared.model.user.User;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserModelConverter {
    public static String[] getEmailAddresses(@Nonnull UserAccount account) {
        String email = (String)account.getValue((UserField)UsersAndGroups.FIELD_EMAIL);
        if (email == null) {
            email = "";
        }
        return email.split(";");
    }

    @Nullable
    public static User convertUserAccount(@Nullable UserAccount account) {
        return UserModelConverter.convertUserAccount(account, false);
    }

    public static User convertUserAccount(UserAccount account, boolean ignoreVisibilityRestrictions) {
        if (account == null) {
            return null;
        }
        User userInfo = new User();
        UserModelConverter.convertUserAccount(account, userInfo, ignoreVisibilityRestrictions);
        return userInfo;
    }

    public static void convertUserAccount(@Nonnull UserAccount account, @Nonnull User userInfo) {
        UserModelConverter.convertUserAccount(account, userInfo, false);
    }

    private static void convertUserAccount(@Nonnull UserAccount account, @Nonnull User userInfo, boolean ignoreVisibilityRestrictions) {
        Integer groupID;
        userInfo.addData(Field.USERDATA_USERID, HDUsersAndGroups.getUserID(account));
        List logins = account.getLoginSettings();
        userInfo.addData(Field.USERDATA_USERNAME, logins.size() > 0 ? ((LoginSettings)logins.get(0)).getLoginID() : account.getDisplayName());
        UserModelConverter.addIfVisible(userInfo, account, Field.USERDATA_FIRSTNAME, UsersAndGroups.FIELD_FIRSTNAME, ignoreVisibilityRestrictions);
        UserModelConverter.addIfVisible(userInfo, account, Field.USERDATA_LASTNAME, UsersAndGroups.FIELD_LASTNAME, ignoreVisibilityRestrictions);
        UserModelConverter.addIfVisible(userInfo, account, Field.USERDATA_TELEPHONE, UsersAndGroups.FIELD_TELEPHONE, ignoreVisibilityRestrictions);
        String[] allEmailAddresses = UserModelConverter.getEmailAddresses(account);
        if (allEmailAddresses.length > 0) {
            UserModelConverter.addIfVisible(userInfo, account, Field.USERDATA_EMAIL, UsersAndGroups.FIELD_EMAIL, f -> allEmailAddresses, ignoreVisibilityRestrictions);
        }
        userInfo.addData(Field.USERDATA_DISPLAYNAME, account.getDisplayName());
        UserModelConverter.addIfVisible(userInfo, account, Field.USERDATA_COMPUTERNAME, HDUsersAndGroups.FIELD_COMPUTER_NAME, ignoreVisibilityRestrictions);
        UserModelConverter.addIfVisible(userInfo, account, Field.USERDATA_LANGUAGE, HDUsersAndGroups.FIELD_LANGUAGE, ignoreVisibilityRestrictions);
        Integer locationID = (Integer)account.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID);
        if (locationID != null) {
            LocationVO location = (LocationVO)LocationManager.getInstance().get(locationID);
            String locationDisplayName = location != null ? location.getDisplayValue() : "";
            UserModelConverter.addIfVisible(userInfo, account, Field.USERDATA_LOCATION, HDUsersAndGroups.FIELD_LOCATION_ID, ignoreVisibilityRestrictions);
            UserModelConverter.addIfVisible(userInfo, account, Field.USERDATA_LOCATION_DISPLAYNAME, HDUsersAndGroups.FIELD_LOCATION_ID, f -> locationDisplayName, ignoreVisibilityRestrictions);
        }
        if ((groupID = (Integer)account.getValue((UserField)HDUsersAndGroups.FIELD_CLASS_ID)) != null) {
            UserClassVO group = (UserClassVO)UserClassManager.getInstance().get(groupID);
            String groupDisplayName = group != null ? group.getDisplayValue() : "";
            UserModelConverter.addIfVisible(userInfo, account, Field.USERDATA_GROUP, HDUsersAndGroups.FIELD_CLASS_ID, ignoreVisibilityRestrictions);
            UserModelConverter.addIfVisible(userInfo, account, Field.USERDATA_GROUP_DISPLAYNAME, HDUsersAndGroups.FIELD_CLASS_ID, f -> groupDisplayName, ignoreVisibilityRestrictions);
        }
        UserModelConverter.addIfVisible(userInfo, account, Field.USERDATA_ROOM, HDUsersAndGroups.FIELD_ROOM, ignoreVisibilityRestrictions);
        UserModelConverter.addIfVisible(userInfo, account, Field.USERDATA_DEPARTMENT, UsersAndGroups.getFieldByKey((String)"department"), ignoreVisibilityRestrictions);
        UserModelConverter.addIfVisible(userInfo, account, Field.USERDATA_COSTCENTRE, HDUsersAndGroups.FIELD_COST_CENTRE, ignoreVisibilityRestrictions);
        UserModelConverter.addIfVisible(userInfo, account, Field.USERDATA_USERFIELD1, UsersAndGroups.getFieldByKey((String)"custom1"), ignoreVisibilityRestrictions);
        UserModelConverter.addIfVisible(userInfo, account, Field.USERDATA_USERFIELD2, UsersAndGroups.getFieldByKey((String)"custom2"), ignoreVisibilityRestrictions);
        UserModelConverter.addIfVisible(userInfo, account, Field.USERDATA_USERFIELD3, UsersAndGroups.getFieldByKey((String)"custom3"), ignoreVisibilityRestrictions);
        UserModelConverter.addIfVisible(userInfo, account, Field.USERDATA_USERFIELD4, UsersAndGroups.getFieldByKey((String)"custom4"), ignoreVisibilityRestrictions);
        UserModelConverter.addIfVisible(userInfo, account, Field.USERDATA_USERFIELD5, UsersAndGroups.getFieldByKey((String)"custom5"), ignoreVisibilityRestrictions);
        UserModelConverter.addIfVisible(userInfo, account, Field.USERDATA_USERFIELD6, UsersAndGroups.getFieldByKey((String)"custom6"), ignoreVisibilityRestrictions);
        UserModelConverter.addIfVisible(userInfo, account, Field.USERDATA_LUMPSUM1, HDUsersAndGroups.FIELD_LUMP_SUM_1, ignoreVisibilityRestrictions);
        UserModelConverter.addIfVisible(userInfo, account, Field.USERDATA_LUMPSUM2, HDUsersAndGroups.FIELD_LUMP_SUM_2, ignoreVisibilityRestrictions);
        UserModelConverter.addIfVisible(userInfo, account, Field.USERDATA_LUMPSUM3, HDUsersAndGroups.FIELD_LUMP_SUM_3, ignoreVisibilityRestrictions);
        userInfo.addData(Field.USERDATA_IMPORT_NAME, account.getValue((UserField)HDUsersAndGroups.FIELD_IMPORT_NAME));
        userInfo.addData(Field.USERDATA_LASTMODIFIED, account.getLastModified());
        userInfo.addData(Field.USERDATA_DELETED, !account.isActive());
    }

    private static void addIfVisible(User userInfo, UserAccount account, Field oldStyleField, UserField<?> field, boolean ignoreVisibilityRestrictions) {
        UserModelConverter.addIfVisible(userInfo, account, oldStyleField, field, f -> account.getValue(f), ignoreVisibilityRestrictions);
    }

    private static void addIfVisible(User userInfo, UserAccount account, Field oldStyleField, UserField<?> field, Function<UserField<?>, Object> valueProvider, boolean ignoreVisibilityRestrictions) {
        UserFieldDefinition definition = UsersAndGroups.getUserFieldDefinitionByKey((String)field.getKey());
        if (definition == null) {
            return;
        }
        if (ignoreVisibilityRestrictions || definition.isAvailable(account)) {
            userInfo.addData(oldStyleField, valueProvider.apply(field));
        }
    }
}

