/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview.subview;

import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketview.SubViewGroupingDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.core.ticketview.subview.SimpleSubViewGrouping;
import com.inet.helpdesk.core.ticketview.subview.SubView;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import java.nio.charset.StandardCharsets;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CategorySubViewGrouping
extends SimpleSubViewGrouping {
    @Nonnull
    public static final CategorySubViewGrouping INSTANCE = new CategorySubViewGrouping();

    public CategorySubViewGrouping() {
        super("categoryid");
    }

    @Override
    public boolean supportsHideSubnodeTickets() {
        return true;
    }

    @Override
    @Nullable
    public List<SubView<?>> getSubViews(@Nonnull TicketViewFactory parent, @Nonnull GUID accountID, Locale locale, @Nonnull Set<Integer> ticketIDs) {
        if (parent instanceof CategorySubView) {
            return ((CategorySubView)parent).subViews;
        }
        List<CategoryVO> all = CategoryManager.getInstance().getAll(false);
        Collator collator = Collator.getInstance(ClientLocale.getThreadLocale());
        Comparator comparator = (a, b) -> collator.compare(a.getDisplayName(), b.getDisplayName());
        ArrayList result = new ArrayList();
        CategorySubViewGrouping.addSubCategories(0, all, parent, result, new HashMap<String, CategorySubView>(), comparator);
        return result;
    }

    private static void addSubCategories(@Nonnull Integer parentId, List<CategoryVO> all, @Nonnull TicketViewFactory parent, @Nonnull List<SubView<?>> result, HashMap<String, CategorySubView> map, @Nonnull Comparator<? super SubView<?>> comparator) {
        block0: while (true) {
            Iterator<CategoryVO> it = all.iterator();
            while (it.hasNext()) {
                CategoryVO category = it.next();
                if (!parentId.equals(category.getParentCategoryID())) continue;
                it.remove();
                Integer id = category.getId();
                String path = category.getPath();
                CategorySubView subview = map.get(path);
                if (subview == null) {
                    ArrayList<Integer> ids = new ArrayList<Integer>();
                    ids.add(id);
                    subview = new CategorySubView(parent, ids, path, category.getDisplayValue());
                    result.add(subview);
                    map.put(path, subview);
                } else {
                    ((List)subview.getChildID()).add(id);
                }
                CategorySubViewGrouping.addSubCategories(id, all, parent, subview.subViews, map, comparator);
                continue block0;
            }
            break;
        }
        result.sort(comparator);
    }

    @Override
    public void patchSearchCommand(Object id, @Nonnull SearchCommand command, @Nonnull GUID accountID) {
        SearchCondition searchEx;
        CategorySubView subview = (CategorySubView)id;
        if (subview.isHideSubnodeTickets()) {
            searchEx = new SearchCondition("categoryid", SearchCondition.SearchTermOperator.IN, subview.getChildID());
        } else {
            HashSet<Integer> ids = new HashSet<Integer>();
            CategorySubViewGrouping.addSubIDs(subview, ids);
            searchEx = new SearchCondition("categoryid", SearchCondition.SearchTermOperator.IN, ids);
        }
        command.getSearchExpression().add((SearchExpression)searchEx);
    }

    private static void addSubIDs(CategorySubView subview, HashSet<Integer> ids) {
        ids.addAll((Collection)subview.getChildID());
        for (SubView<?> view : subview.subViews) {
            CategorySubViewGrouping.addSubIDs((CategorySubView)view, ids);
        }
    }

    @Override
    @Nullable
    protected Supplier<SearchExpression> getConditionSupplier(@Nonnull String subID, boolean hideSubnodeTickets) {
        List all = CategoryManager.getInstance().getAll(false);
        HashSet<Integer> ids = new HashSet<Integer>();
        String path = new String(Base64.getUrlDecoder().decode(subID), StandardCharsets.UTF_8);
        for (CategoryVO category : all) {
            if (!path.equals(category.getPath())) continue;
            ids.add(category.getId());
        }
        if (!hideSubnodeTickets) {
            int size;
            do {
                size = ids.size();
                for (CategoryVO category : all) {
                    if (!ids.contains(category.getParentCategoryID())) continue;
                    ids.add(category.getId());
                }
            } while (size < ids.size());
        }
        return () -> new SearchCondition("categoryid", SearchCondition.SearchTermOperator.IN, (Object)ids);
    }

    static class CategorySubView
    extends SubView<List<Integer>> {
        @Nonnull
        private final List<SubView<?>> subViews = new ArrayList();
        private String path;

        public CategorySubView(@Nonnull TicketViewFactory parent, List<Integer> ids, String path, String displayName) {
            super(parent, INSTANCE, ids, displayName, null, null);
            this.path = path;
        }

        @Override
        @Nonnull
        public String getID() {
            return this.getParent().getID() + "." + Base64.getUrlEncoder().withoutPadding().encodeToString(this.path.getBytes(StandardCharsets.UTF_8));
        }

        @Override
        public Object getFilterID() {
            return this;
        }

        @Override
        @Nullable
        public SubViewGroupingDefinition getSubViewGrouping() {
            return INSTANCE;
        }

        @Override
        public boolean isHideSubnodeTickets() {
            return this.getParent().isHideSubnodeTickets();
        }
    }
}

