/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugin.adhoc;

import com.inet.config.ConfigValue;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationChangeEvent;
import com.inet.config.ConfigurationChangeListener;
import com.inet.config.ConfigurationModificationEvent;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class LocalConfigChangeListener
implements ConfigurationChangeListener {
    private Set<String> CHECK_KEYS = new HashSet<String>(Arrays.asList("adhoc.enabled", "adhoc.dataLocation.type", "adhoc.dataLocation.directory", "adhoc.dataLocation.root", "ccrepository.pathlist"));
    private Map<String, String> recent = new HashMap<String, String>();
    public static final ConfigValue<DatabaseConfigInfoList> DB_CONFIGS = new ConfigValue(HDConfigKeys.DB_CONFIGS);

    public void init(Configuration config) {
        for (String key : this.CHECK_KEYS) {
            this.recent.put(key, config.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurationChanged(ConfigurationChangeEvent e) {
        if (!e.isCurrentConfiguration()) {
            return;
        }
        int type = e.getType();
        if (type == 2) {
            if (e.getType() == 2 && e instanceof ConfigurationModificationEvent) {
                ConfigurationModificationEvent cm = (ConfigurationModificationEvent)e;
                boolean hasData = false;
                for (String key : cm.getChangedKeys()) {
                    if (!this.CHECK_KEYS.contains(key)) continue;
                    hasData = true;
                    break;
                }
                if (!hasData) {
                    return;
                }
            }
        } else if (type != 0) {
            return;
        }
        boolean isChange = false;
        Map<String, String> map = this.recent;
        synchronized (map) {
            Configuration config = e.getChangedConfiguration();
            for (String key : this.CHECK_KEYS) {
                String current = config.get(key);
                if (Objects.equals(current, this.recent.get(key))) continue;
                this.recent.put(key, current);
                isChange = true;
            }
        }
        if (isChange) {
            // empty if block
        }
    }
}

