/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithField;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.ByFirstLetterSortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.id.GUID;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nullable;

public class TicketFieldDefinitionSubject
extends AbstractTicketFieldDefinitionWithField<String> {
    public TicketFieldDefinitionSubject(int prio) {
        super(Tickets.FIELD_SUBJECT, true, false, prio);
        this.setVisibility(TicketFieldDefinition.FIELD_VISIBILITY.ENDUSER);
    }

    @Override
    public String getDisplayValue(TicketVO ticket) {
        String displayValue = ticket.getSubject();
        return displayValue;
    }

    @Override
    public FieldEditDefinition getEditDefinition() {
        return new FieldEditDefinition(this){

            @Override
            public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                String subject = values.get(this.getFieldKey());
                if (subject != null) {
                    ticketData.put(Tickets.FIELD_SUBJECT, subject);
                }
            }

            @Override
            public void updateCurrentValue(TicketVO ticket, GUID ownerId, Map<String, String> values) {
                if (ticket != null) {
                    String subject = ticket.getSubject();
                    values.put(this.getFieldKey(), String.valueOf(subject));
                } else {
                    values.put(this.getFieldKey(), (String)TicketFieldDefinitionSubject.this.defaultValue());
                }
            }

            @Override
            public String getFieldKey() {
                return TicketFieldDefinitionSubject.this.getKey();
            }

            @Override
            public String getDisplayType() {
                return "textinput";
            }

            @Override
            public String getDisplayName() {
                return TicketFieldDefinitionSubject.this.getDisplayName();
            }
        };
    }

    @Override
    public SortGroupInformation getSortGroupInformation() {
        return new ByFirstLetterSortGroupInformation(this);
    }

    @Override
    public Comparator<TicketVO> getComparator() {
        Comparator comp = String.CASE_INSENSITIVE_ORDER;
        Comparator nullsFirst = Comparator.nullsFirst(comp);
        return (a, b) -> nullsFirst.compare(this.getDisplayValue((TicketVO)a), this.getDisplayValue((TicketVO)b));
    }

    @Override
    @Nullable
    public FieldSettingsType getDisplayType() {
        return FieldSettingsType.TYPE_TEXT;
    }
}

