/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.field.ConfigurableDefaultValue;
import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.helpdesk.core.ticketfieldsettings.ConfigurableMandatoryField;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithGenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.ByIDSortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldSortedIteratorDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.JoinIndexIterator;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroup;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.search.index.IndexSearchEngine;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketFieldDefinitionCategoryId
extends AbstractTicketFieldDefinitionWithGenericFieldsManager
implements ConfigurableDefaultValue,
ConfigurableMandatoryField<Integer> {
    public TicketFieldDefinitionCategoryId(int prio) {
        super(Tickets.FIELD_CATEGORY_ID, CategoryManager.getInstance(), prio);
    }

    @Override
    public URL getColumnIcon(Integer iconSize) {
        if (iconSize <= 16) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/kategorie_16.png");
        }
        if (iconSize <= 32) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/kategorie_16@2x.png");
        }
        return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/kategorie_16@3x.png");
    }

    @Override
    public FieldEditDefinition getEditDefinition() {
        return new SelectEditDefinition(this){

            @Override
            public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                String value = values.get(this.getFieldKey());
                if (!StringFunctions.isEmpty((String)value)) {
                    Integer categoryId;
                    ticketData.put(Tickets.FIELD_CATEGORY_ID, null);
                    SelectOption selectOption = (SelectOption)new Json().fromJson(value, SelectOption.class);
                    String valueString = selectOption.getValue();
                    if (!StringFunctions.isEmpty((String)valueString) && (categoryId = Integer.valueOf(valueString)) != null && categoryId != 0) {
                        ticketData.put(Tickets.FIELD_CATEGORY_ID, categoryId);
                    }
                }
            }

            @Override
            public void updateCurrentValue(TicketVO ticket, GUID ownerId, Map<String, String> values) {
                CategoryVO categoryVO;
                Integer categoryId = TicketFieldDefinitionCategoryId.this.defaultValue();
                if (ticket != null) {
                    categoryId = ticket.getCategoryID();
                }
                SelectOption option = new SelectOption(null, "");
                if (categoryId != null && (categoryVO = (CategoryVO)CategoryManager.getInstance().get(categoryId)) != null) {
                    option = new SelectOption(String.valueOf(categoryId), categoryVO.getDisplayValue(), String.valueOf(categoryVO.getId()), 0, false, false, categoryVO.getPath());
                }
                values.put(this.getFieldKey(), new Json().toJson((Object)option));
            }

            @Override
            public String getFieldKey() {
                return TicketFieldDefinitionCategoryId.this.getKey();
            }

            @Override
            public String getDisplayName() {
                return TicketFieldDefinitionCategoryId.this.getDisplayName();
            }

            @Override
            public SelectOptionResult getSelectOptions(List<TicketVO> tickets, String searchTerm, int chunkSize, int currentSize) {
                boolean supporter = HDUsersAndGroups.isSupporter();
                ArrayList<SelectOption> list = new ArrayList<SelectOption>();
                searchTerm = searchTerm != null ? searchTerm : "";
                CategoryManager manager = CategoryManager.getInstance();
                List categories = manager.getAll(true);
                Collections.sort(categories);
                String hiddenPath = null;
                for (CategoryVO categoryVO : categories) {
                    if (!supporter) {
                        if (categoryVO.isHidden()) {
                            if (hiddenPath != null && categoryVO.getPath().startsWith(hiddenPath + "\\")) continue;
                            hiddenPath = categoryVO.getPath();
                            continue;
                        }
                        if (hiddenPath != null) {
                            if (categoryVO.getPath().startsWith(hiddenPath + "\\")) {
                                continue;
                            }
                        } else {
                            hiddenPath = null;
                        }
                    }
                    if (!categoryVO.getPath().toLowerCase().contains(searchTerm.toLowerCase())) continue;
                    int level = this.getLevel(manager, categoryVO, 0);
                    if (!StringFunctions.isEmpty((String)searchTerm) && level > 0) {
                        this.addParents(manager, categoryVO, list, level);
                    }
                    list.add(new SelectOption(categoryVO.getId() == 0 ? null : String.valueOf(categoryVO.getId()), categoryVO.getDisplayValue(), categoryVO.getId() == 0 ? null : String.valueOf(categoryVO.getId()), level, false, false, categoryVO.getPath()));
                }
                if (list.size() < currentSize) {
                    return new SelectOptionResult(0, new ArrayList());
                }
                List subList = list.subList(currentSize, Math.min(list.size(), currentSize + chunkSize));
                return new SelectOptionResult(list.size(), subList);
            }

            private void addParents(CategoryManager manager, CategoryVO categoryVO, ArrayList<SelectOption> list, int level) {
                Integer parentId = categoryVO.getParentCategoryID();
                if (parentId != null && parentId > 0) {
                    CategoryVO parent = (CategoryVO)manager.get(parentId);
                    this.addParents(manager, parent, list, level - 1);
                    SelectOption parentOption = new SelectOption(String.valueOf(parent.getId()), parent.getDisplayValue(), String.valueOf(parent.getId()), level - 1, false, false, parent.getPath());
                    if (!list.stream().anyMatch(opt -> opt.getValue().equals(parentOption.getValue()))) {
                        list.add(parentOption);
                    }
                }
            }

            private int getLevel(CategoryManager manager, CategoryVO categoryVO, int level) {
                Integer parent = categoryVO.getParentCategoryID();
                if (parent != null && parent > 0) {
                    int nextLevel = this.getLevel(manager, (CategoryVO)manager.get(parent), level + 1);
                    return nextLevel;
                }
                return level;
            }
        };
    }

    @Override
    public String getDisplayValue(TicketVO ticket) {
        String path;
        CategoryVO categoryVO;
        Integer categoryID = ticket.getCategoryID();
        if (categoryID != null && (categoryVO = (CategoryVO)CategoryManager.getInstance().get(categoryID)) != null && !StringFunctions.isEmpty((String)(path = categoryVO.getPath()))) {
            path = path.replace("\\", " \\ ");
            return path;
        }
        return null;
    }

    @Override
    public SortGroupInformation getSortGroupInformation() {
        return new ByIDSortGroupInformation(Tickets.FIELD_CATEGORY_ID.getKey(), sortGroupKey -> {
            CategoryVO parent;
            if (StringFunctions.isEmpty((String)sortGroupKey)) {
                return new SortGroup(Tickets.MSG.getMsg("value.unset", new Object[0]), false, null);
            }
            CategoryVO cat = (CategoryVO)CategoryManager.getInstance().get(Integer.parseInt(sortGroupKey));
            Object displayName = cat.getDisplayValue();
            Integer parentCatID = cat.getParentCategoryID();
            while (parentCatID != null && parentCatID > 0 && (parent = (CategoryVO)CategoryManager.getInstance().get(parentCatID)) != null) {
                displayName = parent.getDisplayValue() + " \\ " + (String)displayName;
                parentCatID = parent.getParentCategoryID();
            }
            String iconKey = sortGroupKey;
            return new SortGroup((String)displayName, true, iconKey);
        });
    }

    @Override
    public Comparator<TicketVO> getComparator() {
        Comparator nullsFirst = Comparator.nullsFirst(String.CASE_INSENSITIVE_ORDER);
        return (a, b) -> nullsFirst.compare(this.getDisplayValue((TicketVO)a), this.getDisplayValue((TicketVO)b));
    }

    @Override
    @Nullable
    public FieldSortedIteratorDefinition getSortedDefinition() {
        return new FieldSortedIteratorDefinition(){

            @Override
            @Nonnull
            public Iterator<Integer> getIterator(@Nonnull Set<Integer> mainIds, @Nonnull IndexSearchEngine<Integer> engine, boolean forward) {
                CategoryManager.getInstance();
                Comparator comp = forward ? Comparator.naturalOrder() : Comparator.reverseOrder();
                TreeMap map = new TreeMap(comp);
                for (CategoryVO category : CategoryManager.getInstance().getAll(true)) {
                    map.put(category.getPath(), Collections.singleton(category.getId()));
                }
                return new JoinIndexIterator(mainIds, engine, "categoryid", map.values().iterator(), forward);
            }
        };
    }

    public void setDefaultValue(@Nullable String value) {
        TicketField<Integer> field = this.getField();
        field.setDefaultValue((Integer)field.getValidOrDefaultValue((Integer)field.getFieldType().valueOf(value), null));
    }
}

