/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.mailtemplates;

import com.inet.classloader.translations.LanguageUtils;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.core.mailtemplates.DefaultMailTemplates;
import com.inet.helpdesk.core.mailtemplates.MailTemplateData;
import com.inet.helpdesk.core.mailtemplates.MailTemplatesManager;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.EventLog;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

public enum MailTemplateEventLog {
    MailTemplateAdded,
    MailTemplateChanged,
    MailTemplateDeleted,
    MailTemplateSetDeleted,
    MailTemplateLangDeleted,
    MailTemplateSetAdded,
    MailTemplateLangAdded;

    private static final EventLog<MailTemplateEventLog> EVENT_LOG;

    public void log(MailTemplateData mailtemplate, @Nonnull MailTemplatesManager.ExtType type) {
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("Name", mailtemplate.getName());
        data.put("Set", mailtemplate.getSet());
        data.put("Lang", mailtemplate.getLang());
        data.put("Format", type.name());
        String msg = DefaultMailTemplates.MSG.getMsg(Locale.getDefault(), "eventlog." + this.name() + ".type", new Object[]{mailtemplate.getName(), DefaultMailTemplates.MSG.getMsg("eventlog.format." + type.name(), new Object[0])});
        EVENT_LOG.log((Enum)this, userAccount, msg, new Json().toJson(data), new Object[]{mailtemplate.getName()});
    }

    public static void logChanges(MailTemplateData data, MailTemplateData oldData) {
        if (StringFunctions.isEmpty((String)oldData.getHtmlData()) && !StringFunctions.isEmpty((String)data.getHtmlData())) {
            MailTemplateAdded.log(data, MailTemplatesManager.ExtType.html);
        }
        if (StringFunctions.isEmpty((String)oldData.getTextData()) && !StringFunctions.isEmpty((String)data.getTextData())) {
            MailTemplateAdded.log(data, MailTemplatesManager.ExtType.txt);
        }
        if (!StringFunctions.isEmpty((String)oldData.getHtmlData()) && StringFunctions.isEmpty((String)data.getHtmlData())) {
            MailTemplateDeleted.log(data, MailTemplatesManager.ExtType.html);
        }
        if (!StringFunctions.isEmpty((String)oldData.getTextData()) && StringFunctions.isEmpty((String)data.getTextData())) {
            MailTemplateDeleted.log(data, MailTemplatesManager.ExtType.txt);
        }
        if (!(StringFunctions.isEmpty((String)oldData.getHtmlData()) || StringFunctions.isEmpty((String)data.getHtmlData()) || oldData.getHtmlData().equals(data.getHtmlData()))) {
            MailTemplateChanged.log(data, MailTemplatesManager.ExtType.html);
        }
        if (!(StringFunctions.isEmpty((String)oldData.getTextData()) || StringFunctions.isEmpty((String)data.getTextData()) || oldData.getTextData().equals(data.getTextData()))) {
            MailTemplateChanged.log(data, MailTemplatesManager.ExtType.txt);
        }
    }

    public void logSet(String setName) {
        String setDisplay = setName;
        if (setName.equals("default")) {
            setDisplay = DefaultMailTemplates.MSG.getMsg(Locale.getDefault(), "eventlog.default", new Object[0]);
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("Set", setName);
        String msg = DefaultMailTemplates.MSG.getMsg(Locale.getDefault(), "eventlog." + this.name(), new Object[]{setDisplay});
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        EVENT_LOG.log((Enum)this, userAccount, msg, new Json().toJson(data), new Object[]{setDisplay});
    }

    public void logLang(String setName, String langName) {
        if (setName.equals("default")) {
            setName = DefaultMailTemplates.MSG.getMsg(Locale.getDefault(), "eventlog.default", new Object[0]);
        }
        String langDisplay = langName;
        if (langName.equals("default")) {
            langDisplay = DefaultMailTemplates.MSG.getMsg(Locale.getDefault(), "eventlog.default", new Object[0]);
        } else {
            List additionalLanguages = LanguageUtils.getAdditionalLanguages(Set.of());
            Optional<LocalizedKey> first = additionalLanguages.stream().filter(l -> l.getKey().equals(langName)).findFirst();
            if (first.isPresent()) {
                langDisplay = first.get().getDisplayName();
            }
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("Set", setName);
        data.put("Lang", langName);
        String msg = DefaultMailTemplates.MSG.getMsg(Locale.getDefault(), "eventlog." + this.name(), new Object[]{langDisplay, setName});
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        EVENT_LOG.log((Enum)this, userAccount, msg, new Json().toJson(data), new Object[]{langDisplay});
    }

    static {
        EVENT_LOG = EventLog.register((String)"helpdesktemplate");
    }
}

