/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.mailtemplates;

import com.inet.annotations.InternalApi;
import com.inet.classloader.I18nMessages;
import com.inet.helpdesk.core.mailtemplates.MailTemplate;
import com.inet.plugin.ServerPluginManager;
import java.util.HashMap;

@InternalApi
public class DefaultMailTemplates {
    public static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.core.mailtemplates.i18n.LanguageResources", DefaultMailTemplates.class);
    public static final int ANFRAGE_USER = 1;
    public static final int ANFRAGE_DISP = 2;
    public static final int AUTORISIEREN_USER = 3;
    public static final int AUTORISIEREN_RES = 4;
    public static final int MAILEINGANG_RES = 5;
    public static final int WIEDERVORLAGE = 6;
    public static final int MANU_ESCALATION_DISP = 7;
    public static final int MANU_ESCALATION_RES = 8;
    public static final int AUTO_ESCALATION_DISP = 9;
    public static final int AUTO_ESCALATION_RES = 10;
    public static final int AUTO_MAHNUNG_DISP = 11;
    public static final int AUTO_MAHNUNG_RES = 12;
    public static final int BEENDEN = 13;
    public static final int ERROR = 14;
    public static final int NEW_INCIDENT = 15;
    public static final int LOOP_ERROR = 16;
    public static final int ESCA_WARN_YELLOW = 17;
    public static final int ESCA_WARN_RED = 18;
    public static final int DEAD_WARN_YELLOW = 19;
    public static final int DEAD_WARN_RED = 20;
    public static final int MAILEINGANG_DISP = 21;
    public static final int NO_NEW_TICKETS = 22;
    public static final int TRIGGER_MAIL = 666;
    public static final String TO_TYP_UNKNOWN = "others";
    public static final String TO_TYP_ALL_DISP = "alldispatchers";
    public static final String TO_TYP_DISP = "dispatcher";
    public static final String TO_TYP_RES = "resource";
    public static final String TO_TYP_USER = "user";
    private static final MailTemplate tmp_anfrage = new MailTemplate("alldispatchers", "anfrage", "New Request Dispatcher", true);
    private static final MailTemplate tmp_autorisierenuser = new MailTemplate("user", "autorisierenuser", "New Order User", true);
    private static final MailTemplate tmp_autorisierenres = new MailTemplate("resource", "autorisierenres", "New Order Resource", true);
    private static final MailTemplate tmp_maileingangres = new MailTemplate("resource", "maileingangres", "New Mail", true);
    private static final MailTemplate tmp_maileingangdisp = new MailTemplate("dispatcher", "maileingangdisp", "New Mail", true);
    private static final MailTemplate tmp_vorlage = new MailTemplate("resource", "vorlage", "Reminder");
    private static final MailTemplate tmp_manueskadisp = new MailTemplate("dispatcher", "manueskadisp", "Manual Escalation", true);
    private static final MailTemplate tmp_manueskares = new MailTemplate("resource", "manueskares", "Manual Escalation", true);
    private static final MailTemplate tmp_autoeskadisp = new MailTemplate("dispatcher", "autoeskadisp", "Automatic Escalation");
    private static final MailTemplate tmp_autoeskares = new MailTemplate("resource", "autoeskares", "Automatic Escalation");
    private static final MailTemplate tmp_automahnres = new MailTemplate("resource", "automahn", "Deadline expired");
    private static final MailTemplate tmp_automahndisp = new MailTemplate("dispatcher", "automahn", "Deadline expired");
    private static final MailTemplate tmp_beenden = new MailTemplate("user", "beenden", "Order finished", true);
    private static final MailTemplate tmp_error = new MailTemplate("user", "error", "Error Message");
    private static final MailTemplate tmp_loop_error = new MailTemplate("alldispatchers", "loop-error", "Loop Error Message");
    private static final MailTemplate tmp_newincident = new MailTemplate("others", "newincident", "New Problem Link");
    private static final MailTemplate tmp_nonewticket = new MailTemplate("user", "nonewticket", "Only Existing Tickets Allowed");
    private static final MailTemplate tmp_warning = new MailTemplate("resource", "warning", null);
    private static final MailTemplate tmp_sub = new MailTemplate("others", "subtemplate", null, false, true);
    private static final MailTemplate tmp_sublaststep = new MailTemplate("others", "subtemplatelaststep", null, false, true);
    private static final HashMap<Integer, MailTemplate> defaultMailTemplates = new HashMap<Integer, MailTemplate>(){
        {
            this.put(2, tmp_anfrage);
            this.put(3, tmp_autorisierenuser);
            this.put(4, tmp_autorisierenres);
            this.put(5, tmp_maileingangres);
            this.put(21, tmp_maileingangdisp);
            this.put(6, tmp_vorlage);
            this.put(7, tmp_manueskadisp);
            this.put(8, tmp_manueskares);
            this.put(9, tmp_autoeskadisp);
            this.put(10, tmp_autoeskares);
            this.put(11, tmp_automahndisp);
            this.put(12, tmp_automahnres);
            this.put(13, tmp_beenden);
            this.put(14, tmp_error);
            this.put(16, tmp_loop_error);
            this.put(15, tmp_newincident);
            this.put(22, tmp_nonewticket);
            this.put(17, tmp_warning);
            this.put(18, tmp_warning);
            this.put(19, tmp_warning);
            this.put(20, tmp_warning);
        }
    };

    public static void registerDefaultMailTemplates(ServerPluginManager spm) {
        spm.register(MailTemplate.class, (Object)tmp_anfrage);
        spm.register(MailTemplate.class, (Object)tmp_autorisierenuser);
        spm.register(MailTemplate.class, (Object)tmp_autorisierenres);
        spm.register(MailTemplate.class, (Object)tmp_maileingangres);
        spm.register(MailTemplate.class, (Object)tmp_maileingangdisp);
        spm.register(MailTemplate.class, (Object)tmp_vorlage);
        spm.register(MailTemplate.class, (Object)tmp_manueskadisp);
        spm.register(MailTemplate.class, (Object)tmp_manueskares);
        spm.register(MailTemplate.class, (Object)tmp_autoeskadisp);
        spm.register(MailTemplate.class, (Object)tmp_autoeskares);
        spm.register(MailTemplate.class, (Object)tmp_automahnres);
        spm.register(MailTemplate.class, (Object)tmp_beenden);
        spm.register(MailTemplate.class, (Object)tmp_error);
        spm.register(MailTemplate.class, (Object)tmp_loop_error);
        spm.register(MailTemplate.class, (Object)tmp_newincident);
        spm.register(MailTemplate.class, (Object)tmp_nonewticket);
        spm.register(MailTemplate.class, (Object)tmp_warning);
        spm.register(MailTemplate.class, (Object)tmp_sub);
        spm.register(MailTemplate.class, (Object)tmp_sublaststep);
    }

    public static HashMap<Integer, MailTemplate> getDefaultMailTemplatesMap() {
        return defaultMailTemplates;
    }
}

