/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.dbconnection.DBConnection;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class OracleCreateDatabaseCommand
implements IComposedCommand {
    private DatabaseInfos dbInfo;
    private final String name;

    public OracleCreateDatabaseCommand(DatabaseInfos dbInfo, Node databaseName) {
        this.name = databaseName.getParameter(IDatabaseInfos.DATABASE_PARAM.name.name());
        this.dbInfo = dbInfo;
    }

    @Override
    public int execute() throws SQLException {
        DBConnection dbCon = this.dbInfo.getDBConnection();
        String accountPassword = dbCon.getAccountPassword();
        try {
            dbCon.execute("alter session set \"_ORACLE_SCRIPT\"=true");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        dbCon.executeUpdate("CREATE USER " + this.name + " IDENTIFIED BY " + dbCon.getAccountPassword(), "CREATE USER " + this.name);
        dbCon.executeUpdate("GRANT DBA TO " + this.name);
        dbCon.closeConnection();
        dbCon.setJdbcUser(this.name);
        dbCon.setJdbcPassword(accountPassword);
        Connection con = dbCon.openConnection(this.dbInfo);
        if (con == null) {
            throw new SQLException("Cannot connect to the Database with the new User");
        }
        return 1;
    }

    @Override
    public String getSqlStatement() {
        return "CREATE USER " + this.name;
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return IDatabaseCommand.TIME.init;
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        return element.getName() == NodeFactory.TAG.database && action == ICommandFactory.COMMAND_TYPE.create;
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        return null;
    }
}

