/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.DefaultCommandSyntax;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.model.ISchemaNode;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import java.sql.SQLException;
import java.util.List;

public class DefaultAlterDropCommand
implements IComposedCommand {
    private DatabaseInfos dbInfo;
    private final Node tableName;
    private String name;
    private String statement;
    private NodeFactory.TAG type;
    private final DefaultCommandSyntax syntax;

    protected DefaultAlterDropCommand(DatabaseInfos dbInfo, DefaultCommandSyntax syntax, Node tableName) {
        this.syntax = syntax;
        this.tableName = tableName;
        this.dbInfo = dbInfo;
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        if (element == null) {
            return false;
        }
        NodeFactory.TAG localType = element.getName();
        if (this.type == null ? localType != NodeFactory.TAG.column && localType != NodeFactory.TAG.index && localType != NodeFactory.TAG.reference : this.type != localType) {
            return false;
        }
        return this.name == null || this.name.equals(this.getNameFromNode(element));
    }

    private String getNameFromNode(Node element) {
        NodeFactory.TAG localType = element.getName();
        if (localType == NodeFactory.TAG.column) {
            return element.getParameter(IDatabaseInfos.COLUMN_PARAM.column_name.toString());
        }
        if (localType == NodeFactory.TAG.index) {
            return element.getParameter(IDatabaseInfos.INDEX_PARAM.index_name.toString());
        }
        if (localType == NodeFactory.TAG.reference) {
            return element.getParameter(IDatabaseInfos.REFERENCE_PARAM.fk_name.toString());
        }
        return null;
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        if (this.statement != null) {
            return null;
        }
        String tabName = ((ISchemaNode)((Object)this.tableName)).getSourceName(this.dbInfo);
        this.type = element.getName();
        this.name = this.getNameFromNode(element);
        if (this.type == NodeFactory.TAG.column) {
            this.statement = "ALTER TABLE " + tabName + " DROP COLUMN " + this.dbInfo.getQuote(this.name);
        }
        if (this.type == NodeFactory.TAG.index) {
            if ("true".equals(element.getParameter(IDatabaseInfos.INDEX_PARAM.isprimarykey.toString()))) {
                this.statement = "ALTER TABLE " + tabName + " DROP PRIMARY KEY";
            } else {
                this.statement = "";
                if (this.syntax.useTableNameOnDropIndex()) {
                    this.statement = "ALTER TABLE " + tabName;
                }
                this.statement = this.statement + " DROP INDEX " + this.dbInfo.getQuote(this.name);
            }
        }
        if (this.type == NodeFactory.TAG.reference) {
            this.statement = "ALTER TABLE " + tabName + " DROP " + this.syntax.getDropNameOnDropForeignKey() + " " + this.dbInfo.getQuote(this.name);
        }
        return null;
    }

    @Override
    public int execute() throws SQLException {
        return this.dbInfo.getDBConnection().executeUpdate(this.getSqlStatement());
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return this.type == NodeFactory.TAG.column ? IDatabaseCommand.TIME.dropstructure : IDatabaseCommand.TIME.dropreferences;
    }

    @Override
    public String getSqlStatement() {
        return this.statement;
    }
}

