/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.data.step;

import com.inet.annotations.JsonData;
import com.inet.editor.HtmlConverter;
import com.inet.field.fieldtypes.FieldType;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepAttribute;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.webapi.data.step.AttachmentResponseData;
import com.inet.helpdesk.webapi.data.step.TicketStepEntryResponseData;
import com.inet.helpdesk.webapi.util.HelpDeskWebAPIHelper;
import com.inet.plugin.ServerPluginManager;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

@JsonData
@Schema(description="Detailed response data for a ticket reaction step including text content and fields")
public class TicketStepDetailedEntryResponseData
extends TicketStepEntryResponseData {
    @Schema(description="The text content of the reaction step")
    private String text;
    @Schema(description="Whether the text content is in HTML format")
    private boolean htmlContent;
    @Schema(description="The display name of the action that was performed")
    private String actionDisplayName;
    @Schema(description="Map of attribute keys to their values for the reaction step")
    private Map<String, Object> attributes = new HashMap<String, Object>();
    @Schema(description="Map of field keys to their values for the reaction step")
    private Map<String, Object> fields = new HashMap<String, Object>();

    protected TicketStepDetailedEntryResponseData() {
    }

    public TicketStepDetailedEntryResponseData(ReaStepVO reaStepVO, int currentTicketId) {
        super(reaStepVO, currentTicketId);
        this.actionDisplayName = ((ActionVO)ActionManager.getInstance().get(reaStepVO.getActionID())).getDisplayValue();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static TicketStepDetailedEntryResponseData from(int currentTicketId, ReaStepVO reaStepsForTicket, ReaStepTextVO reaStepText, boolean inlineImages, List<String> requestedFields, List<AttachmentResponseData> attachments) {
        TicketStepDetailedEntryResponseData data = new TicketStepDetailedEntryResponseData(reaStepsForTicket, currentTicketId);
        if (reaStepText != null) {
            data.htmlContent = reaStepText.hasHtmlContent();
            data.text = reaStepText.getText();
            if (data.htmlContent && inlineImages) {
                try {
                    data.text = HtmlConverter.html2inlinedHtml((String)data.text, (boolean)true, (URL)new URL("attachment://"));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        Set<ReaStepAttribute<Object>> includedAttributes = reaStepsForTicket.getIncludedAttributes();
        includedAttributes.removeIf(attribute -> !requestedFields.contains(attribute.getKey()));
        for (ReaStepAttribute<Object> reaStepAttribute : includedAttributes) {
            Object rawValue = reaStepsForTicket.getAttribute(reaStepAttribute);
            Object value = HelpDeskWebAPIHelper.getValidAPIObject(rawValue);
            if (value == null) continue;
            data.attributes.put(reaStepAttribute.getKey(), value);
            HelpDeskWebAPIHelper.addDisplayValueToAttributes((FieldType<Object>)reaStepAttribute.getFieldType(), data.attributes, reaStepAttribute.getKey(), value, rawValue);
        }
        @Nonnull List reaStepFields = ServerPluginManager.getInstance().get(ReaStepField.class);
        reaStepFields.removeIf(it -> !requestedFields.contains(it.getKey()));
        for (ReaStepField reaStepField : reaStepFields) {
            Object rawValue = reaStepsForTicket.getValue(reaStepField);
            Object value = HelpDeskWebAPIHelper.getValidAPIObject(rawValue);
            if (value == null) continue;
            data.fields.put(reaStepField.getKey(), value);
            HelpDeskWebAPIHelper.addDisplayValueToAttributes((FieldType<Object>)reaStepField.getFieldType(), data.attributes, reaStepField.getKey(), value, rawValue);
        }
        if (attachments.size() > 0) {
            data.fields.put("attachments", attachments);
        }
        return data;
    }
}

