/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.data;

import com.inet.annotations.JsonData;
import com.inet.http.upload.AttachmentDescription;
import com.inet.id.GUID;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonData
@Schema(description="Request data for creating a new ticket")
public class HelpDeskTicketCreateRequestData {
    @Schema(description="The initial text content of the ticket", required=true)
    private String text;
    @Schema(description="Whether the text content is in HTML format", defaultValue="false")
    private boolean htmlContent = false;
    @Schema(description="The GUID of the ticket owner. If not set, the current user's GUID will be used")
    private GUID ownerGUID = null;
    @Schema(description="Additional fields to be set on the ticket")
    private Map<String, String> ticketFields = new HashMap<String, String>();
    @Schema(description="Additional arguments for ticket creation")
    private Map<String, String> actionArguments = new HashMap<String, String>();
    @Schema(description="List of attachments to be added to the ticket")
    private List<AttachmentDescription> attachments = new ArrayList<AttachmentDescription>();

    private HelpDeskTicketCreateRequestData() {
    }

    public String getText() {
        return this.text;
    }

    public boolean isHtmlContent() {
        return this.htmlContent;
    }

    public GUID getOwnerGUID() {
        return this.ownerGUID;
    }

    public Map<String, String> getTicketFields() {
        return this.ticketFields;
    }

    public Map<String, String> getActionArguments() {
        return this.actionArguments;
    }

    public List<AttachmentDescription> getAttachments() {
        return this.attachments;
    }
}

