/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups;

import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class HDFieldLocator {
    private static final String TRANSLATION_PREFIX_OTHER = "_";
    private static final String TRANSLATION_PREFIX_USERFIELD = "UF_";
    private static final String TRANSLATION_PREFIX_DEVICEFIELD = "DF_";
    private static final String TRANSLATION_PREFIX_TICKETFIELD = "TF_";
    private static Map<Field, Supplier<com.inet.field.Field>> dbKeyToFieldKey = new HashMap<Field, Supplier<com.inet.field.Field>>(){
        {
            this.put(Field.USERDATA_EMAIL, () -> UsersAndGroups.FIELD_EMAIL);
            this.put(Field.USERDATA_FIRSTNAME, () -> UsersAndGroups.FIELD_FIRSTNAME);
            this.put(Field.USERDATA_LASTNAME, () -> UsersAndGroups.FIELD_LASTNAME);
            this.put(Field.USERDATA_TELEPHONE, () -> UsersAndGroups.FIELD_TELEPHONE);
            this.put(Field.USERDATA_COMPUTERNAME, () -> HDUsersAndGroups.FIELD_COMPUTER_NAME);
            this.put(Field.USERDATA_COSTCENTRE, () -> HDUsersAndGroups.FIELD_COST_CENTRE);
            this.put(Field.USERDATA_DEPARTMENT, () -> UsersAndGroups.getFieldByKey((String)"department"));
            this.put(Field.USERDATA_GROUP, () -> HDUsersAndGroups.FIELD_CLASS_ID);
            this.put(Field.USERDATA_IMPORT_NAME, () -> HDUsersAndGroups.FIELD_IMPORT_NAME);
            this.put(Field.USERDATA_LANGUAGE, () -> HDUsersAndGroups.FIELD_LANGUAGE);
            this.put(Field.USERDATA_LOCATION, () -> HDUsersAndGroups.FIELD_LOCATION_ID);
            this.put(Field.USERDATA_ROOM, () -> HDUsersAndGroups.FIELD_ROOM);
            this.put(Field.USERDATA_LUMPSUM1, () -> HDUsersAndGroups.FIELD_LUMP_SUM_1);
            this.put(Field.USERDATA_LUMPSUM2, () -> HDUsersAndGroups.FIELD_LUMP_SUM_2);
            this.put(Field.USERDATA_LUMPSUM3, () -> HDUsersAndGroups.FIELD_LUMP_SUM_3);
            this.put(Field.USERDATA_USERFIELD1, () -> UsersAndGroups.getFieldByKey((String)"custom1"));
            this.put(Field.USERDATA_USERFIELD2, () -> UsersAndGroups.getFieldByKey((String)"custom2"));
            this.put(Field.USERDATA_USERFIELD3, () -> UsersAndGroups.getFieldByKey((String)"custom3"));
            this.put(Field.USERDATA_USERFIELD4, () -> UsersAndGroups.getFieldByKey((String)"custom4"));
            this.put(Field.USERDATA_USERFIELD5, () -> UsersAndGroups.getFieldByKey((String)"custom5"));
            this.put(Field.USERDATA_USERFIELD6, () -> UsersAndGroups.getFieldByKey((String)"custom6"));
            this.put(Field.USERDATA_NOTE, () -> UsersAndGroups.FIELD_NOTE);
            this.put(Field.TICKETDATA_CATEGORY, () -> Tickets.FIELD_CATEGORY_ID);
            this.put(Field.TICKETDATA_CATEGORYID, () -> Tickets.FIELD_CATEGORY_ID);
            this.put(Field.TICKETDATA_CLASSIFICATIONID, () -> Tickets.FIELD_CLASSIFICATION_ID);
            this.put(Field.TICKETDATA_DEADLINE, () -> Tickets.FIELD_DEADLINE);
            this.put(Field.TICKETDATA_DUETIME, () -> Tickets.FIELD_TARGET_TIME);
            this.put(Field.TICKETDATA_HASATTACHMENTS, () -> Tickets.ATTRIBUTE_ATTACHMENTS);
            this.put(Field.TICKETDATA_INQUIRYDATE, () -> Tickets.ATTRIBUTE_INQUIRY_DATE);
            this.put(Field.TICKETDATA_ITILID, () -> Tickets.FIELD_ITIL_ID);
            this.put(Field.TICKETDATA_LASTMODIFIED, () -> Tickets.ATTRIBUTE_LAST_CHANGED);
            this.put(Field.TICKETDATA_LASTTEXTEDITOR, () -> Tickets.ATTRIBUTE_LAST_EDITOR_GUID);
            this.put(Field.TICKETDATA_ORDERID, () -> Tickets.ATTRIBUTE_BUNDLE_ID);
            this.put(Field.TICKETDATA_OWNER, () -> Tickets.FIELD_OWNER_GUID);
            this.put(Field.TICKETDATA_PRIORITYID, () -> Tickets.FIELD_PRIORITY_ID);
            this.put(Field.TICKETDATA_REQUESTMAILACCOUNT, () -> Tickets.ATTRIBUTE_EMAIL_EINGANG);
            this.put(Field.TICKETDATA_RESOURCEID, () -> Tickets.FIELD_RESOURCE_GUID);
            this.put(Field.TICKETDATA_SPECIALFIELD, () -> Tickets.FIELD_IDENTIFIER);
            this.put(Field.TICKETDATA_STATUSID, () -> Tickets.ATTRIBUTE_STATUS_ID);
            this.put(Field.TICKETDATA_SUBJECT, () -> Tickets.FIELD_SUBJECT);
            this.put(Field.TICKETDATA_SUMTIMES, () -> Tickets.ATTRIBUTE_SUM_TIME);
            this.put(Field.TICKETDATA_TERMINVEREINBARUNG, () -> Tickets.ATTRIBUTE_TERMINVEREINBARUNG);
            this.put(Field.TICKETDATA_TICKETFIELD1, () -> HDFieldLocator.getTicketOpenField("custom1"));
            this.put(Field.TICKETDATA_TICKETFIELD2, () -> HDFieldLocator.getTicketOpenField("custom2"));
            this.put(Field.TICKETDATA_TICKETFIELD3, () -> HDFieldLocator.getTicketOpenField("custom3"));
            this.put(Field.TICKETDATA_TICKETFIELD4, () -> HDFieldLocator.getTicketOpenField("custom4"));
            this.put(Field.TICKETDATA_TICKETFIELD5, () -> HDFieldLocator.getTicketOpenField("custom5"));
            this.put(Field.TICKETDATA_TICKETFIELD6, () -> HDFieldLocator.getTicketOpenField("custom6"));
            this.put(Field.TICKETDATA_TICKETFIELD7, () -> HDFieldLocator.getTicketOpenField("custom7"));
            this.put(Field.TICKETDATA_TICKETID, () -> Tickets.ATTRIBUTE_TICKET_ID);
        }
    };

    private static com.inet.field.Field<?> getTicketOpenField(String fieldKey) {
        if (ServerPluginManager.getInstance().getState() != ServerPluginManager.ServerPluginManagerState.INIT) {
            return null;
        }
        return Tickets.getFieldByKey(fieldKey);
    }

    public static <T extends com.inet.field.Field> T getUserFieldForDBKey(String dbKey) {
        Optional<Field> field = Arrays.stream(Field.values()).filter(f -> f.name().startsWith("USERDATA")).filter(f -> f.getKey() != null && f.getKey().equals(dbKey)).findFirst();
        if (field.isPresent()) {
            return HDFieldLocator.getFieldForOldDbField(field.get());
        }
        throw new IllegalArgumentException("No such field: " + dbKey);
    }

    public static <T extends com.inet.field.Field> T getFieldForOldDbField(Field dbKey) {
        Supplier<com.inet.field.Field> supplier = dbKeyToFieldKey.get((Object)dbKey);
        if (supplier != null) {
            return (T)supplier.get();
        }
        switch (dbKey) {
            case USERDATA_GROUP_DISPLAYNAME: {
                return HDFieldLocator.getFieldForOldDbField(Field.USERDATA_GROUP);
            }
            case USERDATA_LOCATION_DISPLAYNAME: {
                return HDFieldLocator.getFieldForOldDbField(Field.USERDATA_LOCATION);
            }
            case DEVICEDATA_TYPE_DISPLAYNAME: {
                return HDFieldLocator.getFieldForOldDbField(Field.DEVICEDATA_TYPE);
            }
            case TICKETDATA_RESOURCEID_DISPLAYNAME: {
                return HDFieldLocator.getFieldForOldDbField(Field.TICKETDATA_RESOURCEID);
            }
        }
        return null;
    }

    public static Field getOldDbFieldForNewField(com.inet.field.Field<?> fieldKey) {
        for (Map.Entry<Field, Supplier<com.inet.field.Field>> entry : dbKeyToFieldKey.entrySet()) {
            com.inet.field.Field field = entry.getValue().get();
            if (field == null || !field.equals(fieldKey)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static String getTranslationKeyForNewField(com.inet.field.Field<?> field) {
        if (field instanceof UserField) {
            return HDFieldLocator.getUserTranslationKey(field);
        }
        if (field instanceof TicketField || field instanceof TicketAttribute) {
            return HDFieldLocator.getTicketTranslationKey(field);
        }
        if (field == Tickets.ATTRIBUTE_TICKET_ID) {
            return null;
        }
        throw new UnsupportedOperationException(field.toString());
    }

    private static String getUserTranslationKey(com.inet.field.Field<?> field) {
        String prefix = TRANSLATION_PREFIX_USERFIELD;
        return prefix + field.getKey();
    }

    private static String getTicketTranslationKey(com.inet.field.Field<?> field) {
        String prefix = TRANSLATION_PREFIX_TICKETFIELD;
        return prefix + field.getKey();
    }

    public static com.inet.field.Field getFieldToTranslateByTranslationKey(String translationKey) {
        if (translationKey.startsWith(TRANSLATION_PREFIX_USERFIELD)) {
            return UsersAndGroups.getFieldByKey((String)translationKey.substring(TRANSLATION_PREFIX_USERFIELD.length()));
        }
        if (translationKey.startsWith(TRANSLATION_PREFIX_TICKETFIELD)) {
            String ticketFieldKey = translationKey.substring(TRANSLATION_PREFIX_TICKETFIELD.length());
            TicketField fieldByKey = Tickets.getFieldByKey(ticketFieldKey);
            if (fieldByKey != null) {
                return fieldByKey;
            }
            for (com.inet.field.Field f : DynamicExtensionManager.getInstance().get(TicketAttribute.class)) {
                if (!ticketFieldKey.equals(f.getKey())) continue;
                return f;
            }
            switch (ticketFieldKey) {
                case "priority": {
                    return Tickets.FIELD_PRIORITY_ID;
                }
                case "category": {
                    return Tickets.FIELD_CATEGORY_ID;
                }
                case "itil": {
                    return Tickets.FIELD_ITIL_ID;
                }
                case "classification": {
                    return Tickets.FIELD_CLASSIFICATION_ID;
                }
                case "duetime": {
                    return Tickets.FIELD_TARGET_TIME;
                }
                case "specialfield": {
                    return Tickets.FIELD_IDENTIFIER;
                }
            }
            return null;
        }
        return null;
    }
}

