/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.data.AdditionalFieldSetting;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.model.general.AbstractData;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationManager;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationVO;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityVO;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusManager;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusVO;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.shared.model.general.ContextType;
import com.inet.helpdesk.shared.util.TypespecificIntMap;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.user.UserAccount;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import srv.ServerUtilities;

public class ServerValuesConnectorImpl
implements ServerValuesConnector {
    private TypespecificIntMap<String> idToKey = new TypespecificIntMap();
    private List<AdditionalFieldSetting> additionalFieldSettings = new ArrayList<AdditionalFieldSetting>();
    private static final ArrayList<Field> TICKET_COLUMNS_ENDUSER = new ArrayList();
    private static final ConfigValue<Integer> DEFAULT_TICKET_FONT_SIZE_VALUE = new ConfigValue(HDConfigKeys.DEFAULT_TICKET_FONT_SIZE);
    private static final ConfigValue<String> DEFAULT_TICKET_FONT_NAME_VALUE = new ConfigValue(HDConfigKeys.DEFAULT_TICKET_FONT_NAME);
    private static final ConfigValue<Boolean> DEFAULT_TICKET_PLAINTEXT_REASTEP = new ConfigValue(HDConfigKeys.DEFAULT_TICKET_PLAINTEXT_REASTEP);
    private static final ConfigValue<String> DEFAULT_COMPANY_ADDRESS = new ConfigValue(HDConfigKeys.DEFAULT_COMPANY_ADDRESS);
    private static final ConfigValue<Integer> DEFAULT_EMAIL_SEND_CLOSE_TIME = new ConfigValue(HDConfigKeys.DEFAULT_EMAIL_SEND_CLOSE_TIME);

    @Override
    public boolean isHtmlContent() {
        return (Boolean)DEFAULT_TICKET_PLAINTEXT_REASTEP.get();
    }

    @Override
    public String getNodeImageName(AbstractData res) {
        switch (res.getTypeId()) {
            case 1: {
                if (res.isDeleted()) {
                    return "delete_16.gif";
                }
                if (res.isWriteable()) {
                    return "resources_16.gif";
                }
                if (res.isReadable()) {
                    return "resources_read_16.gif";
                }
                return "resource_forign_16.gif";
            }
            case 0: {
                StatusVO status = (StatusVO)StatusManager.getInstance().get(res.getId());
                return status == null ? null : status.getImageName();
            }
            case 2: {
                PriorityVO priority = (PriorityVO)PriorityManager.getInstance().get(res.getId());
                return priority == null ? null : priority.getImageName();
            }
            case 3: {
                ClassificationVO classification = (ClassificationVO)ClassificationManager.getInstance().get(res.getId());
                return classification == null ? null : classification.getImageName();
            }
            case 5: {
                if (res.isDeleted()) {
                    return "delete_16.gif";
                }
                return "folder_closed_16.gif";
            }
            case 6: {
                if (res.isDeleted()) {
                    return "delete_16.gif";
                }
                return "benutzergr_16.gif";
            }
            case 7: {
                ItilVO itiltype = (ItilVO)ItilManager.getInstance().get(res.getId());
                return itiltype == null ? null : itiltype.getImageName();
            }
            case 8: {
                return "frei_16.gif";
            }
            case 9: {
                return "user_16.gif";
            }
            case 4: {
                return "kategorie_16.gif";
            }
            case 18: {
                String val = res.getStringKey();
                if ("".equals(val)) {
                    val = "alllanguages";
                }
                if ("xx".equals(val)) {
                    return null;
                }
                return "flags/" + val + ".png";
            }
        }
        String fieldName = this.idToKey.get(res.getTypeId());
        if (Field.TICKETDATA_CATEGORYID.name().equals(fieldName)) {
            return "kategorie_16.gif";
        }
        for (AdditionalFieldSetting additionalFieldSetting : this.additionalFieldSettings) {
            String imageName = additionalFieldSetting.getImageName(fieldName, res.getTypeId(), res.getId(), res.getStringKey());
            if (imageName == null) continue;
            return imageName;
        }
        return null;
    }

    @Override
    public boolean isResourceWritable(int resourceId, int userId, int searchDirection) {
        UserAccount account = HDUsersAndGroups.getUserAccount(userId);
        if (SystemPermissionChecker.hasAnyPermission((UserAccount)account, (Permission[])new Permission[]{HdPermissions.TICKET_RESOURCES_READ}) && SystemPermissionChecker.hasAnyPermission((UserAccount)account, (Permission[])new Permission[]{HdPermissions.TICKET_RESOURCES_READ_WRITE})) {
            return true;
        }
        UserGroupInfo resource = HDUsersAndGroups.getResource(resourceId);
        if (resource == null) {
            return false;
        }
        return HDUsersAndGroups.hasWritePermissionInResource(account.getID(), resource);
    }

    public void init() {
        this.additionalFieldSettings.addAll(ServerPluginManager.getInstance().get(AdditionalFieldSetting.class));
    }

    @Override
    public Font getDefaultFont() throws ServerDataException {
        String fontName = (String)DEFAULT_TICKET_FONT_NAME_VALUE.get();
        int fontSize = (Integer)DEFAULT_TICKET_FONT_SIZE_VALUE.get();
        if (StringFunctions.isEmpty((String)fontName)) {
            fontName = HDConfigKeys.DEFAULT_TICKET_FONT_NAME.getDefault();
        }
        if (fontSize <= 0) {
            fontSize = Integer.parseInt(HDConfigKeys.DEFAULT_TICKET_FONT_SIZE.getDefault());
        }
        return new Font(fontName, 0, fontSize);
    }

    @Override
    public boolean isSupporterNameDisplayable(ContextType contextType) throws ServerDataException {
        if (contextType == ContextType.enduser) {
            return (Boolean)ServerUtilities.CLIENT_ENDUSER_SHOWBEARBEITER.get();
        }
        return true;
    }

    static {
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_TICKETID);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_HASATTACHMENTS);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_SUBJECT);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_STATUSID);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_RESOURCEID);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_INQUIRYDATE);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_CATEGORYID);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_PRIORITYID);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_CLASSIFICATIONID);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_ITILID);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_DEADLINE);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_TERMINVEREINBARUNG);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_SPECIALFIELD);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_LASTTEXTEDITOR);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_LASTMODIFIED);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_TICKETFIELD1);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_TICKETFIELD2);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_TICKETFIELD3);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_TICKETFIELD4);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_TICKETFIELD6);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_TICKETFIELD7);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_SUMTIMES);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_DUETIME);
    }
}

