/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets;

import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionAutoCC;
import com.inet.helpdesk.core.ticketmanager.fields.MandatoryFieldVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.BasicFieldValidation;
import com.inet.usersandgroups.api.ui.fields.EmailAddressHelper;
import javax.annotation.Nullable;

public class TicketFieldAutoCC
extends TicketField<String> {
    public static final String KEY = "autocc";
    public static final String DEFAULT_EMPTY_IDENTIFIER = "";

    public TicketFieldAutoCC() {
        super(KEY, DEFAULT_EMPTY_IDENTIFIER, FieldTypeFactory.auto());
        this.setEnduserEditability(MandatoryFieldVO.MandatoryType.HIDDEN);
    }

    public String getValidOrDefaultValue(String value, GUID entryID) {
        if (value == null) {
            return DEFAULT_EMPTY_IDENTIFIER;
        }
        String normalized = TicketFieldDefinitionAutoCC.normalizeEmailAddressesIntoLinesPreservingFormat(value);
        return normalized;
    }

    @Override
    public TicketVOSingle getValueSourceForSlaveTicketForEnduser(TicketVOSingle master, TicketVOSingle slave) {
        return slave;
    }

    @Override
    public int getFieldChangeReaStepActionId() {
        return -29;
    }

    public void validate(String value) {
        super.validate((Object)value);
        if (value != null) {
            BasicFieldValidation.throwIfLengthExceedsLimit((String)value, (int)1023);
            String normalized = TicketFieldDefinitionAutoCC.normalizeEmailAddressesIntoLinesPreservingFormat(value);
            for (String line : normalized.split("\n")) {
                String tocheck = line.replaceAll("[^<]+<([^>@]+@[^>]+)>.*", "$1");
                EmailAddressHelper.get().throwIfContainsInvalidEmailAddresses(tocheck);
            }
        }
    }

    @Override
    public OperationNewReaStep createStringFieldChangeReaStep(String oldFieldValue, String newFieldValue, @Nullable MutableReaStepData additionalReaStepData, OperationChangedTicket ticket) {
        if ((oldFieldValue == null || oldFieldValue.isBlank()) && (newFieldValue == null || newFieldValue.isBlank())) {
            return null;
        }
        return super.createStringFieldChangeReaStep(oldFieldValue, newFieldValue, additionalReaStepData, ticket);
    }
}

