/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.DefaultCommandSyntax;
import com.inet.dbupdater.databases.commands.DefaultSimpleCommand;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.model.ISchemaNode;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class MSSQLAlterDropCommand
implements IComposedCommand {
    private static final Logger logger = LogManager.getLogger((String)"DB Updater");
    private DatabaseInfos dbInfo;
    private final Node tableName;
    private String name;
    private String statement;
    private NodeFactory.TAG type;
    private String origDropDefault;
    private String altDropDefault;
    private boolean mayFail = false;

    protected MSSQLAlterDropCommand(DatabaseInfos dbInfo, DefaultCommandSyntax syntax, Node tableName) {
        this.tableName = tableName;
        this.dbInfo = dbInfo;
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        if (element == null) {
            return false;
        }
        NodeFactory.TAG localType = element.getName();
        if (this.type == null ? localType != NodeFactory.TAG.column && localType != NodeFactory.TAG.index && localType != NodeFactory.TAG.reference : this.type != localType) {
            return false;
        }
        return this.name == null || this.name.equals(this.getNameFromNode(element));
    }

    private String getNameFromNode(Node element) {
        NodeFactory.TAG localType = element.getName();
        if (localType == NodeFactory.TAG.column) {
            return element.getParameter(IDatabaseInfos.COLUMN_PARAM.column_name.toString());
        }
        if (localType == NodeFactory.TAG.index) {
            return element.getParameter(IDatabaseInfos.INDEX_PARAM.index_name.toString());
        }
        if (localType == NodeFactory.TAG.reference) {
            return element.getParameter(IDatabaseInfos.REFERENCE_PARAM.fk_name.toString());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        if (this.statement != null) {
            return null;
        }
        String tabName = ((ISchemaNode)((Object)this.tableName)).getSourceName(this.dbInfo);
        String origTabName = ((ISchemaNode)((Object)this.tableName)).getName(this.dbInfo);
        this.type = element.getName();
        this.name = this.getNameFromNode(element);
        if (this.type == NodeFactory.TAG.column) {
            this.statement = "";
            try (ResultSet result = null;){
                try {
                    result = this.dbInfo.getDBConnection().executeQuery("select object_name(c.default_object_id) as bound_to_default from sys.columns as c join sys.tables as t on t.object_id = c.object_id join sys.schemas as s on s.schema_id = t.schema_id where c.default_object_id is not null and c.default_object_id is not null AND t.name='" + origTabName + "' AND c.name='" + this.name + "';");
                }
                catch (SQLException sqle) {
                    result = this.dbInfo.getDBConnection().executeQuery("select o.name as bound_to_default from syscolumns c inner join sysobjects o on c.cdefault = o.id  where c.cdefault > 0 and object_name(c.id) = '" + origTabName + "' and c.name = '" + this.name + "';");
                }
                while (result != null && result.next()) {
                    String defBound = result.getString("bound_to_default");
                    if (defBound == null) continue;
                    this.altDropDefault = "EXEC sp_unbindefault '" + tabName + "." + this.name + "'; ";
                    this.origDropDefault = "ALTER TABLE " + tabName + " DROP CONSTRAINT " + this.dbInfo.getQuote(defBound) + "; ";
                    this.statement = this.statement + this.origDropDefault;
                }
            }
            this.statement = this.statement + "ALTER TABLE " + tabName + " DROP COLUMN " + this.dbInfo.getQuote(this.name);
        }
        if (this.type == NodeFactory.TAG.index) {
            Node constraint;
            Node node = constraint = element.getDiffSource() != null ? element.getDiffSource() : element;
            if ("true".equals(constraint.getParameter(IDatabaseInfos.INDEX_PARAM.isprimarykey.toString()))) {
                this.statement = "ALTER TABLE " + tabName + " DROP CONSTRAINT " + this.dbInfo.getQuote(this.name);
            } else {
                if ("false".equals(constraint.getParameter(IDatabaseInfos.INDEX_PARAM.non_unique.toString()))) {
                    this.statement = "ALTER TABLE " + tabName + " DROP CONSTRAINT " + this.dbInfo.getQuote(this.name);
                    this.mayFail = true;
                    ArrayList<IComposedCommand> additional = new ArrayList<IComposedCommand>();
                    additional.add(new DefaultSimpleCommand("DROP INDEX " + tabName + "." + this.dbInfo.getQuote(this.name), this.dbInfo, false, IDatabaseCommand.TIME.dropreferences, true));
                    return additional;
                }
                this.statement = "DROP INDEX " + tabName + "." + this.dbInfo.getQuote(this.name);
            }
        }
        if (this.type == NodeFactory.TAG.reference) {
            this.statement = "ALTER TABLE " + tabName + " DROP CONSTRAINT " + this.dbInfo.getQuote(this.name);
        }
        return null;
    }

    @Override
    public int execute() throws SQLException {
        String sqlStatement = this.getSqlStatement();
        try {
            int executeUpdate = this.dbInfo.getDBConnection().executeUpdate(sqlStatement);
            return executeUpdate;
        }
        catch (SQLException sqle) {
            if (this.mayFail) {
                return 1;
            }
            if (this.origDropDefault != null && this.altDropDefault != null) {
                sqlStatement = sqlStatement.replace(this.origDropDefault, this.altDropDefault);
                return this.dbInfo.getDBConnection().executeUpdate(sqlStatement);
            }
            throw sqle;
        }
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return this.type == NodeFactory.TAG.column ? IDatabaseCommand.TIME.dropstructure : IDatabaseCommand.TIME.dropreferences;
    }

    @Override
    public String getSqlStatement() {
        return this.statement;
    }
}

