/*
 * Decompiled with CFR 0.152.
 */
package srv.automatic.deviceimport;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class MappingHandler {
    private final Map<String, String> mappedColumns;

    public MappingHandler(Map<String, String> mappedColumns) {
        this.mappedColumns = mappedColumns;
    }

    protected List<MappedColumn> getMappedColumns() {
        return this.getListOfColumnsToSelect(new String[0]);
    }

    @Nonnull
    protected ArrayList<MappedColumn> getListOfColumnsToSelect(String @Nonnull [] additionals) {
        ArrayList<MappedColumn> list = new ArrayList<MappedColumn>();
        int internalKey = -1;
        for (int i = 0; i < additionals.length; ++i) {
            list.add(new MappedColumn(null, additionals[i], internalKey--, 100));
        }
        AtomicInteger i = new AtomicInteger(0);
        ArrayList collected = this.mappedColumns.entrySet().stream().map(e -> new MappedColumn((String)e.getKey(), (String)e.getValue(), i.getAndIncrement(), 100)).collect(Collectors.toCollection(ArrayList::new));
        list.addAll(collected);
        return list;
    }

    protected class MappedColumn {
        private final int modelIndex;
        private final int maxValueLength;
        private final String internalColumnName;
        private final String sourceColumnName;

        private MappedColumn(String internalColumnName, String sourceColumnName, int modelIndex, int maxValueLength) {
            this.internalColumnName = internalColumnName;
            this.sourceColumnName = sourceColumnName;
            this.modelIndex = modelIndex;
            this.maxValueLength = maxValueLength;
        }

        protected boolean allowsMultiRows() {
            return true;
        }

        protected int getMaxValueLength() {
            return this.maxValueLength;
        }

        protected String getInternalColumnName() {
            return this.internalColumnName;
        }

        protected String getSourceColumnName() {
            return this.sourceColumnName;
        }
    }
}

