/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.data;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.field.fieldtypes.FieldType;
import com.inet.helpdesk.core.data.TicketAccessInfo;
import com.inet.helpdesk.core.data.TicketAccessInformationsProvider;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.webapi.util.HelpDeskWebAPIHelper;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonData
@Schema(description="Response data containing ticket details and access information")
public class HelpDeskTicketIdResponseData {
    @Schema(description="The numeric ID of the ticket", required=true)
    private int ticketId;
    @Schema(description="The reference ID of the ticket used in email subjects", required=true)
    private String ticketIdReference;
    @Schema(description="The GUID of the user who currently has write access to the ticket")
    @JsonExcludeNull
    private GUID writeSessionUserGUID;
    @Schema(description="The display name of the user who currently has write access to the ticket")
    @JsonExcludeNull
    private String writeSessionUserDisplayName;
    @Schema(description="Map of user GUIDs to display names for users who currently have read access to the ticket")
    @JsonExcludeNull
    private Map<GUID, String> readSessions;
    @Schema(description="Map of field keys to their values for the ticket")
    private Map<String, Object> fields = new HashMap<String, Object>();
    @Schema(description="Map of attribute keys to their values for the ticket")
    private Map<String, Object> attributes = new HashMap<String, Object>();
    @Schema(description="List of ticket IDs for bundled secondary tickets. Only present if this ticket is the primary ticket in a bundle.")
    @JsonExcludeNull
    private List<Integer> bundledSecondaryTicketIds;

    public static HelpDeskTicketIdResponseData from(TicketVO ticket, List<String> requestedFields) {
        List<TicketVOSingle> ticketsInBundle;
        List list;
        HelpDeskTicketIdResponseData data = new HelpDeskTicketIdResponseData();
        data.ticketId = ticket.getID();
        data.ticketIdReference = Tickets.getTicketIDForEmailSubject(ticket.getID());
        TicketAccessInformationsProvider informationsProvider = (TicketAccessInformationsProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAccessInformationsProvider.class);
        TicketAccessInfo ticketAccessInfo = informationsProvider.getTicketAccessInfo(ticket.getID());
        if (ticketAccessInfo != null) {
            List<TicketAccessInfo.TicketAccessor> list2;
            TicketAccessInfo.TicketAccessor writeSession = ticketAccessInfo.getWriteSession();
            if (writeSession != null) {
                data.writeSessionUserGUID = writeSession.getUser();
                data.writeSessionUserDisplayName = ticketAccessInfo.getWriteSession().getUserDisplayName();
            }
            if ((list2 = ticketAccessInfo.getReadSessions()) != null) {
                data.readSessions = list2.stream().distinct().collect(Collectors.toMap(TicketAccessInfo.TicketAccessor::getUser, TicketAccessInfo.TicketAccessor::getUserDisplayName));
            }
        }
        for (TicketAttribute ticketAttribute : ticket.getIncludedAttributes()) {
            Object fieldOrAttributeValue;
            Object value;
            if (!requestedFields.contains(ticketAttribute.getKey()) || (value = HelpDeskWebAPIHelper.getValidAPIObject(fieldOrAttributeValue = ticket.getFieldOrAttributeValue(ticketAttribute))) == null) continue;
            data.attributes.put(ticketAttribute.getKey(), value);
            HelpDeskWebAPIHelper.addDisplayValueToAttributes((FieldType<Object>)ticketAttribute.getFieldType(), data.attributes, ticketAttribute.getKey(), value, ticket.getFieldOrAttributeValue(ticketAttribute));
        }
        for (TicketField<Object> ticketField : ticket.getIncludedFields()) {
            Object value;
            if (!requestedFields.contains(ticketField.getKey()) || (value = HelpDeskWebAPIHelper.getValidAPIObject(ticket.getFieldOrAttributeValue(ticketField))) == null) continue;
            data.fields.put(ticketField.getKey(), value);
            HelpDeskWebAPIHelper.addDisplayValueToAttributes((FieldType<Object>)ticketField.getFieldType(), data.attributes, ticketField.getKey(), value, ticket.getFieldOrAttributeValue(ticketField));
        }
        if (ticket.isMasterInBundle() && !(list = (ticketsInBundle = TicketManager.getReader().getTicketsInBundle(ticket.getID(), false)).stream().map(TicketVOSingle::getID).collect(Collectors.toList())).isEmpty()) {
            data.bundledSecondaryTicketIds = list;
        }
        return data;
    }
}

