/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.user.fields;

import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.fieldsettings.user.model.UserFieldCustom;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.BasicFieldValidation;

public class UserFieldOpen
extends UserFieldCustom<String> {
    public static final String KEY_ONE = "custom1";
    public static final String KEY_TWO = "custom2";
    public static final String KEY_THREE = "custom3";
    public static final String KEY_FOUR = "custom4";
    public static final String KEY_FIVE = "custom5";
    public static final String KEY_SIX = "custom6";
    public static final String KEY_DEPARTMENT = "department";

    public UserFieldOpen(GenericFieldSetting setting) {
        super(setting, UserFieldOpen.searchPrio(setting.getKey()));
    }

    private static int searchPrio(String key) {
        switch (key) {
            case "custom1": {
                return 500;
            }
            case "custom2": {
                return 490;
            }
            case "custom3": {
                return 480;
            }
            case "custom4": {
                return 470;
            }
            case "custom5": {
                return 460;
            }
            case "custom6": {
                return 450;
            }
            case "department": {
                return 700;
            }
        }
        return 0;
    }

    private int maxLength() {
        switch (this.getKey()) {
            case "department": {
                return 100;
            }
            case "custom1": 
            case "custom2": 
            case "custom3": 
            case "custom4": 
            case "custom5": {
                return 255;
            }
            case "custom6": {
                return 1000;
            }
        }
        return 0;
    }

    public String getValidOrDefaultValue(String value, GUID entryID) {
        if (value == null) {
            return "";
        }
        return (String)super.getValidOrDefaultValue((Object)value, entryID);
    }

    public void validate(String value) {
        super.validate((Object)value);
        BasicFieldValidation.throwIfNull((Object)value);
        BasicFieldValidation.throwIfLengthExceedsLimit((String)value, (int)this.maxLength());
    }

    public static boolean isOpenField(String key) {
        return KEY_ONE.equals(key) || KEY_TWO.equals(key) || KEY_THREE.equals(key) || KEY_FOUR.equals(key) || KEY_FIVE.equals(key) || KEY_SIX.equals(key) || KEY_DEPARTMENT.equals(key);
    }

    public String getLabel() {
        return HDFieldDisplayNameProvider.getStaticDisplayNameForUserField(this.getKey());
    }
}

