/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.mail;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.data.FileContainer;
import com.inet.helpdesk.core.mail.MailAttachment;
import com.inet.mail.api.BaseEmail;
import com.inet.persistence.PersistenceEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class MailUtilities {
    public static final String BOUNDARY = "boundary=";
    public static final String BASE64 = "base64";
    public static final String CHAR_SET = "UTF-8";

    public static String addToList(PersistenceEntry attachment, String targetName, boolean inline, List<MailAttachment> toAttach) {
        if (!attachment.exists()) {
            return "Missing Image";
        }
        return MailUtilities.internalAddToList(new FileContainer(attachment), targetName, inline, toAttach);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="no traversal because we pass in an actually existing file path")
    public static String addToList(final String attachmentPath, String targetName, boolean inline, List<MailAttachment> toAttach) {
        if (!new File(attachmentPath).exists()) {
            return "Missing Image";
        }
        String fileName = attachmentPath.substring(attachmentPath.lastIndexOf(47) + 1);
        FileContainer.InputStreamProvider inputStreamProvider = new FileContainer.InputStreamProvider(){

            @Override
            @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="no traversal because we pass in an actually existing file path")
            public InputStream getInputStream() throws IOException {
                return new FileInputStream(new File(attachmentPath));
            }
        };
        return MailUtilities.internalAddToList(new FileContainer(fileName, attachmentPath, inputStreamProvider), targetName, inline, toAttach);
    }

    private static String internalAddToList(FileContainer file, String targetName, boolean inline, List<MailAttachment> toAttach) {
        String extension;
        int dotIndex;
        int index;
        for (int i = 0; i < toAttach.size(); ++i) {
            if (!toAttach.get(i).getPath().equals(file.getPath())) continue;
            if (inline) {
                toAttach.get(i).setInLineDeklaration(true);
            }
            return toAttach.get(i).getFileName();
        }
        if (targetName == null && (index = (index = ((String)(targetName = file.getName())).indexOf("_ReaID")) > -1 ? ((String)targetName).indexOf(95, index + 5) : ((String)targetName).indexOf(95)) > -1 && index > -1) {
            targetName = ((String)targetName).substring(index + 1);
        }
        if ((dotIndex = ((String)targetName).lastIndexOf(46)) > 0) {
            extension = ((String)targetName).substring(dotIndex + 1);
            targetName = ((String)targetName).substring(0, dotIndex);
        } else {
            extension = "";
        }
        if (MailUtilities.nameExists((String)targetName, extension, toAttach)) {
            String testName;
            int counter = 1;
            while (MailUtilities.nameExists(testName = (String)targetName + counter, extension, toAttach)) {
                ++counter;
            }
            targetName = testName;
        }
        String fullName = extension.isEmpty() ? targetName : (String)targetName + "." + extension;
        FileContainer fileWithChangedName = new FileContainer(fullName, file.getPath(), () -> file.getInputStream());
        toAttach.add(new MailAttachment(fileWithChangedName, inline));
        return fullName;
    }

    protected static boolean nameExists(String name, String extension, List<MailAttachment> toAttach) {
        String fullName = extension.isEmpty() ? name : name + "." + extension;
        for (int i = 0; i < toAttach.size(); ++i) {
            if (!fullName.equals(toAttach.get(i).getFileName())) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static String encodeMIMEText(String text) {
        return BaseEmail.encodeMIMEText((String)text);
    }
}

