/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.model;

import com.inet.dbupdater.model.IModelWriter;
import com.inet.dbupdater.model.Node;
import java.io.PrintWriter;
import java.util.Stack;

public class ModelWriterXML
implements IModelWriter {
    private static final String INDENT_SPACE = "   ";
    private PrintWriter out;
    private Node model;
    private Stack<String> elementStack;
    private boolean isMonolithic;
    private boolean wasClosed = true;

    public ModelWriterXML(PrintWriter out, Node model) {
        this.out = out;
        this.model = model;
    }

    public void run() {
        this.elementStack = new Stack();
        this.out.print("<?xml version=\"1.0\"?>\n");
        this.model.write(this);
    }

    @Override
    public void closeNode() {
        this.checkClose();
        String name = this.elementStack.pop();
        if (this.isMonolithic) {
            this.out.print("/>\n");
        } else {
            this.indent();
            this.out.print("</" + name + ">\n");
        }
        this.isMonolithic = false;
    }

    @Override
    public void openNode(String name, boolean isMonolithic) {
        this.checkClose();
        this.indent();
        this.elementStack.push(name);
        this.out.write("<" + name);
        this.wasClosed = isMonolithic;
        this.isMonolithic = isMonolithic;
    }

    @Override
    public void writeContent(String content) {
        if (content != null) {
            this.checkClose();
            this.indent();
            this.out.print("<![CDATA[");
            this.out.print(content);
            this.out.print("]]>\n");
        }
    }

    @Override
    public void writeParameter(String name, String value) {
        this.out.print(" ");
        this.out.write(name);
        if (value != null) {
            this.out.print("=\"");
            this.out.print(value);
            this.out.print("\"");
        }
    }

    private void checkClose() {
        if (!this.wasClosed) {
            this.out.write(">\n");
            this.wasClosed = true;
        }
    }

    private void indent() {
        for (int i = 0; i < this.elementStack.size(); ++i) {
            this.out.print(INDENT_SPACE);
        }
    }
}

