/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.jobrunner.jobs;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.DefaultAlterIndexCommand;
import com.inet.dbupdater.databases.commands.DefaultCommandFactory;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.jobrunner.JobStructure;
import com.inet.dbupdater.jobrunner.jobs.IJob;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class JobAlterTable
implements IJob {
    @Override
    public JobStructure createCommands(DatabaseInfos targetCon, Node model) {
        if (model == null) {
            return null;
        }
        if (model.getName() != NodeFactory.TAG.table) {
            throw new IllegalArgumentException("The JobCreateTable can be used only for tables!");
        }
        JobStructure commands = new JobStructure();
        ArrayList<String> modifiedIndices = new ArrayList<String>();
        try {
            block2: for (Node node : model.getAllChildren()) {
                String colName;
                List<IComposedCommand> recentCommands;
                IDatabaseCommand.TIME execTime = null;
                if (node.getState() == 0) {
                    execTime = IDatabaseCommand.TIME.addstructure;
                }
                if (node.getState() == 1) {
                    execTime = IDatabaseCommand.TIME.alterstructure;
                }
                if (node.getState() == 2) {
                    execTime = IDatabaseCommand.TIME.dropstructure;
                }
                if ((recentCommands = commands.get(execTime)) != null) {
                    for (IComposedCommand recent : recentCommands) {
                        if (!recent.accepts(node, ICommandFactory.COMMAND_TYPE.alter)) continue;
                        commands.addCommands(recent.addDataset(node, ICommandFactory.COMMAND_TYPE.alter));
                        continue block2;
                    }
                }
                String string = colName = "true".equals(node.getRecentValue(IDatabaseInfos.INDEX_PARAM.isprimarykey.toString())) ? "PRIMARY" : null;
                if (node.getName() == NodeFactory.TAG.index) {
                    String indexName = node.getParameter(IDatabaseInfos.INDEX_PARAM.index_name.name());
                    String indexNameLower = indexName.toLowerCase();
                    if (modifiedIndices.contains(indexNameLower)) continue;
                    modifiedIndices.add(indexNameLower);
                    Node targetParent = node.getParent().getDiffTarget();
                    List<Object> colsInTarget = targetParent != null ? targetParent.getChildren(NodeFactory.TAG.index).stream().filter(c -> indexName.equalsIgnoreCase(c.getParameter(IDatabaseInfos.INDEX_PARAM.index_name.name()))).collect(Collectors.toList()) : new ArrayList();
                    Node sourceParent = node.getParent().getDiffSource();
                    List<Object> colsInSource = sourceParent != null ? sourceParent.getChildren(NodeFactory.TAG.index).stream().filter(c -> indexName.equalsIgnoreCase(c.getParameter(IDatabaseInfos.INDEX_PARAM.index_name.name()))).collect(Collectors.toList()) : new ArrayList();
                    IComposedCommand command = null;
                    if (colsInSource.size() > 0 && colsInTarget.size() == 0) {
                        command = targetCon.getCommandFactory().getCommand(ICommandFactory.COMMAND_TYPE.alter, node.getName(), IDatabaseCommand.TIME.dropreferences, model, colName);
                        List<IComposedCommand> subCommands = command.addDataset(node, ICommandFactory.COMMAND_TYPE.remove);
                        if (subCommands != null) {
                            commands.addCommands(subCommands);
                            command = null;
                        }
                        if (command == null) continue;
                        commands.add(command);
                        continue;
                    }
                    ICommandFactory.COMMAND_TYPE type = ICommandFactory.COMMAND_TYPE.alter;
                    ArrayList<IComposedCommand> indexCommands = new ArrayList<IComposedCommand>();
                    boolean requireWrap = false;
                    if (colsInSource.size() == 0 && colsInTarget.size() > 0) {
                        type = ICommandFactory.COMMAND_TYPE.create;
                        command = targetCon.getCommandFactory().getCommand(ICommandFactory.COMMAND_TYPE.alter, node.getName(), IDatabaseCommand.TIME.addreferences, model, colName);
                    } else {
                        command = targetCon.getCommandFactory().getCommand(ICommandFactory.COMMAND_TYPE.alter, node.getName(), IDatabaseCommand.TIME.dropreferences, model, colName);
                        node.setDiffReferences((Node)colsInSource.get(0), (Node)colsInTarget.get(0));
                        List<IComposedCommand> subCommands = command.addDataset(node, ICommandFactory.COMMAND_TYPE.remove);
                        if (subCommands != null) {
                            indexCommands.addAll(subCommands);
                        } else {
                            indexCommands.add(command);
                        }
                        type = ICommandFactory.COMMAND_TYPE.create;
                        colName = colsInTarget.size() > 0 && "true".equals(((Node)colsInTarget.get(0)).getParameter(IDatabaseInfos.INDEX_PARAM.isprimarykey.toString())) ? "PRIMARY" : null;
                        command = targetCon.getCommandFactory().getCommand(ICommandFactory.COMMAND_TYPE.alter, node.getName(), IDatabaseCommand.TIME.addreferences, model, colName);
                        requireWrap = true;
                    }
                    IComposedCommand secondary = null;
                    for (Node node2 : colsInTarget) {
                        if (secondary != null) {
                            command.addDataset(node2, type);
                            continue;
                        }
                        List<IComposedCommand> com = command.addDataset(node2, type);
                        if (com == null || com.size() <= 0) continue;
                        secondary = com.get(0);
                    }
                    if (command != null) {
                        indexCommands.add(command);
                    }
                    if (secondary != null) {
                        indexCommands.add(secondary);
                    }
                    if (requireWrap) {
                        DefaultAlterIndexCommand unbindCommand = new DefaultAlterIndexCommand(targetCon, ((DefaultCommandFactory)targetCon.getCommandFactory()).getSyntax(), sourceParent);
                        commands.addCommands(unbindCommand.wrapInReferenceUnbind(node, indexCommands));
                        continue;
                    }
                    commands.addCommands(indexCommands);
                    continue;
                }
                IComposedCommand command = targetCon.getCommandFactory().getCommand(ICommandFactory.COMMAND_TYPE.alter, node.getName(), execTime, model, colName);
                if (command == null) continue;
                List<IComposedCommand> com = command.addDataset(node, ICommandFactory.COMMAND_TYPE.alter);
                commands.add(command);
                if (com == null) continue;
                commands.addCommands(com);
            }
        }
        catch (SQLException e) {
            Logger logger = LogManager.getLogger((String)"DB Updater");
            logger.error((Object)"Job alter table failed");
            logger.error((Throwable)e);
            throw new IllegalStateException(e);
        }
        return commands;
    }
}

