/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.search;

import com.inet.cowork.server.search.e;
import com.inet.cowork.server.webapi.search.SearchRequestData;
import com.inet.cowork.server.webapi.search.SearchResponseData;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Tag(name="Search", description="Message search operations")
public class a
extends RequestHandlerBase<SearchRequestData, SearchResponseData> {
    public a() {
        super(new String[]{"/search"});
    }

    public String getHelpPageKey() {
        return "webapi.cowork.search";
    }

    @Operation(summary="Search messages", description="Searches for messages across all accessible channels using the provided query. Supports pagination and text format options.", responses={@ApiResponse(responseCode="200", description="Search results retrieved successfully", content={@Content(schema=@Schema(implementation=SearchResponseData.class))}), @ApiResponse(responseCode="400", description="Invalid search parameters (empty query, invalid message count or offset)")})
    public SearchResponseData a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable SearchRequestData searchRequestData, @Nonnull List<String> list, boolean bl) throws IOException {
        if (searchRequestData == null) {
            throw new ClientMessageException("No input was given or the JSON was incorrect. Please check the documentation for the correct JSON format of this request.");
        }
        if (StringFunctions.isEmpty((String)searchRequestData.getQuery())) {
            throw new ClientMessageException("No query or an empty query was given.");
        }
        if (searchRequestData.getMessageCount() <= 0) {
            throw new ClientMessageException("Your requested messageCount must be greater than zero.");
        }
        if (searchRequestData.getStartOffset() < 0) {
            throw new ClientMessageException("Your requested startOffset must be greater or equal than zero.");
        }
        Set<com.inet.cowork.api.model.a> set = e.v().b(searchRequestData.getQuery(), searchRequestData.getMessageCount() + 1);
        List<com.inet.cowork.api.model.a> list2 = new ArrayList<com.inet.cowork.api.model.a>(set);
        boolean bl2 = list2.size() > searchRequestData.getMessageCount();
        int n2 = searchRequestData.getStartOffset();
        int n3 = list2.size();
        if (bl2) {
            n3 = searchRequestData.getMessageCount();
        }
        n2 = Math.min(n2, n3);
        list2 = list2.subList(n2, n3);
        return SearchResponseData.from(list2, searchRequestData.getTextFormat());
    }

    @Operation(summary="Search messages", description="Searches for messages across all accessible channels using the provided query. Supports pagination and text format options.", responses={@ApiResponse(responseCode="200", description="Search results retrieved successfully", content={@Content(schema=@Schema(implementation=SearchResponseData.class))}), @ApiResponse(responseCode="400", description="Invalid search parameters (empty query, invalid message count or offset)")})
    public /* synthetic */ Object handle(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable Object object, @Nonnull List list, boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (SearchRequestData)object, list, bl);
    }
}

