/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.members;

import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.cowork.api.model.MemberStatus;
import com.inet.cowork.api.model.MemberStatusGroup;
import com.inet.cowork.api.webapi.CoWorkWebAPIUtils;
import com.inet.cowork.server.webapi.members.MembersResponseData;
import com.inet.id.GUID;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@Tag(name="Members", description="Channel member operations")
public class a
extends RequestHandler.WithParentPathToken<Void, MembersResponseData, GUID> {
    public a() {
        super(new String[]{"members"});
    }

    public String getHelpPageKey() {
        return "webapi.cowork.teams.channels.members";
    }

    @Operation(summary="List channel members", description="Returns a list of all members in a channel and their current status", responses={@ApiResponse(responseCode="200", description="List of channel members retrieved successfully", content={@Content(schema=@Schema(implementation=MembersResponseData.class))}), @ApiResponse(responseCode="403", description="Channel not available or access forbidden"), @ApiResponse(responseCode="404", description="Channel not found")})
    public MembersResponseData e(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Void void_, @Nullable GUID gUID, boolean bl) throws IOException {
        CoWorkChannel coWorkChannel = CoWorkWebAPIUtils.checkAndGetChannelIfIsValid(httpServletRequest, httpServletResponse, gUID);
        if (coWorkChannel == null) {
            return null;
        }
        if (!coWorkChannel.isAvailable()) {
            ResponseWriter.forbidden((HttpServletResponse)httpServletResponse, (String)"Channel is not available.");
            return null;
        }
        List<MemberStatusGroup> list = CoWorkManager.getInstance().getUsersInChannel(coWorkChannel.getId());
        ArrayList<MemberStatus> arrayList = new ArrayList<MemberStatus>();
        for (MemberStatusGroup memberStatusGroup : list) {
            arrayList.addAll(memberStatusGroup.getMembers());
        }
        return MembersResponseData.fromUsersInChannel(arrayList);
    }

    @Operation(summary="List channel members", description="Returns a list of all members in a channel and their current status", responses={@ApiResponse(responseCode="200", description="List of channel members retrieved successfully", content={@Content(schema=@Schema(implementation=MembersResponseData.class))}), @ApiResponse(responseCode="403", description="Channel not available or access forbidden"), @ApiResponse(responseCode="404", description="Channel not found")})
    public /* synthetic */ Object handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Object object, @Nullable Object object2, boolean bl) throws IOException {
        return this.e(httpServletRequest, httpServletResponse, (Void)object, (GUID)object2, bl);
    }
}

