/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.directmessages;

import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.usersandgroups.api.user.UserManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.annotation.Nullable;

@Tag(name="Direct Messages", description="Direct message channel operations")
public class b
extends RequestHandler.WithParentPathToken<Void, Void, GUID> {
    private boolean bA;

    public b(boolean bl) {
        super(new String[]{"leave"});
        this.bA = bl;
    }

    public String getHelpPageKey() {
        return this.bA ? "webapi.cowork.teams.directmessages.leave" : "webapi.cowork.teams.channels.leave";
    }

    @Operation(summary="Leave direct message channel", description="Allows the current user to leave a direct message channel", responses={@ApiResponse(responseCode="204", description="Successfully left the channel"), @ApiResponse(responseCode="400", description="Channel does not exist, is not a direct message channel, or wrong HTTP method used")})
    public Void d(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Void void_, @Nullable GUID gUID, boolean bl) throws IOException {
        CoWorkChannel coWorkChannel;
        CoWorkManager coWorkManager = CoWorkManager.getInstance();
        CoWorkChannel coWorkChannel2 = coWorkChannel = this.bA ? coWorkManager.getDirectMessageChannel(gUID, false) : coWorkManager.getChannel(gUID);
        if (coWorkChannel == null) {
            throw new ClientMessageException("Direct message channel does not yet exist. Please create the channel first.");
        }
        if (!CoWorkManager.DIRECTMESSAGE_TEAM_ID.equals((Object)coWorkChannel.getTeamId())) {
            throw new ClientMessageException("This is not a direct message channel.");
        }
        if (!this.isMethodAllowedForData(httpServletRequest)) {
            throw new ClientMessageException("You have to POST the request to leave a channel");
        }
        if (!bl) {
            coWorkManager.leaveDirectMessageChannel(coWorkChannel.getId(), UserManager.getInstance().getCurrentUserAccountID());
        }
        httpServletResponse.setStatus(204);
        return null;
    }

    @Operation(summary="Leave direct message channel", description="Allows the current user to leave a direct message channel", responses={@ApiResponse(responseCode="204", description="Successfully left the channel"), @ApiResponse(responseCode="400", description="Channel does not exist, is not a direct message channel, or wrong HTTP method used")})
    public /* synthetic */ Object handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Object object, @Nullable Object object2, boolean bl) throws IOException {
        return this.d(httpServletRequest, httpServletResponse, (Void)object, (GUID)object2, bl);
    }
}

