/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.attachments;

import com.inet.annotations.JsonData;
import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.model.CoWorkAttachment;
import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.cowork.api.model.CoWorkMessage;
import com.inet.id.GUID;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

@JsonData
@Schema(description="List of attachments associated with a message")
public class AttachmentsListResponseData
extends ArrayList<Attachment> {
    private AttachmentsListResponseData() {
    }

    public static AttachmentsListResponseData from(CoWorkMessage message, CoWorkChannel channel) {
        if (message == null) {
            return null;
        }
        AttachmentsListResponseData attachmentsListResponseData = new AttachmentsListResponseData();
        List<GUID> list = message.getAttachmentsIds();
        if (list != null) {
            CoWorkManager coWorkManager = CoWorkManager.getInstance();
            attachmentsListResponseData.addAll(list.stream().map(guid -> Attachment.from(coWorkManager.getAttachmentMetaData(channel.getId(), (GUID)guid))).collect(Collectors.toList()));
        }
        return attachmentsListResponseData;
    }

    @JsonData
    @Schema(description="Metadata for a message attachment")
    public static class Attachment {
        @Schema(description="Additional properties of the attachment")
        private HashMap<String, String> properties;
        @Schema(description="Name of the attachment file")
        private String name;
        @Schema(description="Unique identifier of the attachment")
        private GUID id;

        public static Attachment from(CoWorkAttachment attachmentMetaData) {
            Attachment attachment = new Attachment();
            attachment.id = attachmentMetaData.getId();
            attachment.name = attachmentMetaData.getName();
            attachment.properties = new HashMap<String, String>(attachmentMetaData.getProperties());
            return attachment;
        }
    }
}

