/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.api.model;

import com.inet.annotations.JsonData;
import com.inet.cowork.api.model.Draft;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class UserMetaData {
    private ConcurrentHashMap<GUID, Long> channelLastSeen = new ConcurrentHashMap();
    private ConcurrentHashMap<GUID, Long> channelLastBlurred = new ConcurrentHashMap();
    private ConcurrentHashMap<GUID, Draft> channelDrafts = new ConcurrentHashMap();
    private ConcurrentHashMap<GUID, GUID> channelTargetMessageId = new ConcurrentHashMap();

    public Map<GUID, Long> getChannelLastSeen() {
        return this.channelLastSeen;
    }

    public void putChannelLastSeen(GUID channelId, Long timestamp) {
        this.channelLastSeen.put(channelId, timestamp);
    }

    public ConcurrentHashMap<GUID, Long> getChannelLastBlurred() {
        return this.channelLastBlurred;
    }

    public void putChannelLastBlurred(@Nonnull GUID channelId, @Nullable Long timestamp) {
        if (timestamp == null) {
            this.channelLastBlurred.remove(channelId);
            return;
        }
        this.channelLastBlurred.put(channelId, timestamp);
    }

    public ConcurrentHashMap<GUID, Draft> getDrafts() {
        return this.channelDrafts;
    }

    public void saveDraft(GUID channelId, Draft draft) {
        if (draft == null || StringFunctions.isEmpty((String)draft.getMessage()) && draft.getParentMessageId() == null) {
            this.channelDrafts.remove(channelId);
            return;
        }
        this.channelDrafts.put(channelId, draft);
    }

    public void saveChannelTargetMessage(GUID channelId, GUID messageId) {
        if (messageId == null) {
            this.channelTargetMessageId.remove(channelId);
            return;
        }
        this.channelTargetMessageId.put(channelId, messageId);
    }

    public GUID getChannelTargetMessageID(GUID channelId) {
        return this.channelTargetMessageId.get(channelId);
    }
}

