/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.teams;

import com.inet.annotations.JsonData;
import com.inet.cowork.api.model.CoWorkTeam;
import com.inet.cowork.server.webapi.teams.TeamGUIDResponseData;
import com.inet.id.GUID;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@JsonData
@Schema(description="List of teams the user has access to")
@ArraySchema(schema=@Schema(implementation=TeamGUIDResponseData.class))
public class TeamListResponseData
extends ArrayList<Entry> {
    public static TeamListResponseData from(List<CoWorkTeam> teams) {
        TeamListResponseData teamListResponseData = new TeamListResponseData();
        teamListResponseData.addAll(teams.stream().map(t2 -> Entry.from(t2)).collect(Collectors.toList()));
        return teamListResponseData;
    }

    @JsonData
    public static class Entry {
        private GUID id;
        private String displayName;

        public static Entry from(CoWorkTeam team) {
            Entry entry = new Entry();
            entry.displayName = team.getDisplayName();
            entry.id = team.getId();
            return entry;
        }
    }
}

