/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.attachments;

import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.model.CoWorkAttachment;
import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.cowork.api.model.CoWorkMessage;
import com.inet.cowork.api.webapi.CoWorkWebAPIUtils;
import com.inet.cowork.server.webapi.attachments.AttachmentsListResponseData;
import com.inet.http.servlet.SessionStore;
import com.inet.http.utils.MimeTypes;
import com.inet.id.GUID;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.RequestHandlerWithGUIDPathToken;
import com.inet.remote.gui.angular.AngularContentService;
import com.inet.shared.servlet.ServletUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;

@Tag(name="Attachments", description="Operations for managing message attachments")
public class a
extends RequestHandlerWithGUIDPathToken<Void, AttachmentsListResponseData.Attachment> {
    public a() {
        super(new String[]{"attachments"});
    }

    public String getHelpPageKey() {
        return "webapi.cowork.teams.channels.messages.attachments.id";
    }

    @Operation(summary="Get attachment by ID", description="Retrieves an attachment by its ID, either as binary data stream or metadata in JSON format based on Accept header", responses={@ApiResponse(responseCode="200", description="Attachment retrieved successfully", content={@Content(schema=@Schema(implementation=AttachmentsListResponseData.Attachment.class))}), @ApiResponse(responseCode="404", description="Channel, message or attachment not found")})
    public AttachmentsListResponseData.Attachment a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Void void_, @Nullable GUID gUID, boolean bl) throws IOException {
        CoWorkManager coWorkManager = CoWorkManager.getInstance();
        GUID gUID2 = CoWorkWebAPIUtils.getGUIDFromPathInfo(httpServletRequest, "channels");
        CoWorkChannel coWorkChannel = CoWorkWebAPIUtils.checkAndGetChannelIfIsValid(httpServletRequest, httpServletResponse, gUID2);
        if (coWorkChannel == null) {
            return null;
        }
        GUID gUID3 = CoWorkWebAPIUtils.getGUIDFromPathInfo(httpServletRequest, "messages");
        if (gUID3 == null) {
            ResponseWriter.notFound((HttpServletResponse)httpServletResponse, (String)"The message could not be determined for the given message id.");
            return null;
        }
        CoWorkMessage coWorkMessage = coWorkManager.getMessage(coWorkChannel.getId(), gUID3);
        if (coWorkMessage == null) {
            ResponseWriter.notFound((HttpServletResponse)httpServletResponse, (String)"The message could not be determined for the given attachments id.");
            return null;
        }
        CoWorkAttachment coWorkAttachment = coWorkManager.getAttachmentMetaData(gUID2, gUID);
        if (coWorkAttachment == null) {
            ResponseWriter.notFound((HttpServletResponse)httpServletResponse, (String)"The attachment could not be determined for the id.");
            return null;
        }
        if (!this.shouldSendJsonResponse()) {
            String string = httpServletRequest.getParameter("download");
            try (InputStream inputStream = CoWorkManager.getInstance().getAttachmentStream(gUID2, gUID, false);){
                if (inputStream != null) {
                    ServletUtils.setContentDisposition((HttpServletResponse)httpServletResponse, (String)coWorkAttachment.getName(), (!"true".equalsIgnoreCase(string) ? 1 : 0) != 0);
                    AngularContentService.serveStaticContent((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (InputStream)inputStream, (long)System.currentTimeMillis(), (String)MimeTypes.getMimeType((String)coWorkAttachment.getName()), (boolean)true);
                }
            }
        }
        return AttachmentsListResponseData.Attachment.from(coWorkAttachment);
    }

    public boolean shouldSendJsonResponse() {
        HttpServletRequest httpServletRequest = SessionStore.getHttpServletRequest();
        return httpServletRequest != null && "application/json; charset=utf-8".equalsIgnoreCase(httpServletRequest.getHeader("Accepts"));
    }

    @Operation(summary="Get attachment by ID", description="Retrieves an attachment by its ID, either as binary data stream or metadata in JSON format based on Accept header", responses={@ApiResponse(responseCode="200", description="Attachment retrieved successfully", content={@Content(schema=@Schema(implementation=AttachmentsListResponseData.Attachment.class))}), @ApiResponse(responseCode="404", description="Channel, message or attachment not found")})
    public /* synthetic */ Object handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Object object, @Nullable Object object2, boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (Void)object, (GUID)object2, bl);
    }
}

