/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.api.model;

import com.inet.annotations.JsonData;
import com.inet.cowork.api.CoWorkI18n;
import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.model.CoWorkTeam;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class CoWorkChannel {
    private GUID id;
    private GUID teamId;
    private String displayName;
    private String description;
    private boolean membersInherited;
    private Set<GUID> memberUserIds;
    private Set<GUID> memberGroupIds;
    private long lastModified;
    private byte[] icon;

    private CoWorkChannel() {
    }

    public static CoWorkChannel create(GUID id, GUID teamId, String displayName, String description, Set<GUID> memberUserIds, Set<GUID> memberGroupIds) {
        CoWorkChannel coWorkChannel = new CoWorkChannel();
        if (id == null) {
            id = GUID.generateNew();
        }
        coWorkChannel.id = id;
        coWorkChannel.teamId = teamId;
        coWorkChannel.displayName = displayName;
        coWorkChannel.description = description;
        coWorkChannel.membersInherited = false;
        coWorkChannel.memberUserIds = memberUserIds;
        coWorkChannel.memberGroupIds = memberGroupIds;
        return coWorkChannel;
    }

    public static CoWorkChannel create(GUID id, GUID teamId, String displayName, String description) {
        CoWorkChannel coWorkChannel = new CoWorkChannel();
        if (id == null) {
            id = GUID.generateNew();
        }
        coWorkChannel.id = id;
        coWorkChannel.teamId = teamId;
        coWorkChannel.displayName = displayName;
        coWorkChannel.description = description;
        coWorkChannel.membersInherited = true;
        return coWorkChannel;
    }

    public void setIcon(byte[] icon) {
        this.icon = icon;
    }

    public byte[] getIcon() {
        return this.icon;
    }

    public boolean isAvailable() {
        return this.isAvailable(UserManager.getInstance().getCurrentUserAccountID());
    }

    public boolean isAvailable(GUID userId) {
        if (userId == null) {
            return false;
        }
        CoWorkTeam coWorkTeam = CoWorkManager.getInstance().getTeam(this.teamId, userId);
        if (coWorkTeam == null || !coWorkTeam.isAvailable(userId)) {
            return false;
        }
        if (this.membersInherited) {
            return true;
        }
        if (this.memberUserIds != null && this.memberUserIds.contains(userId)) {
            return true;
        }
        return this.memberGroupIds != null && this.isGroupMember(this.memberGroupIds, userId);
    }

    public boolean isMembersInherited() {
        return this.membersInherited;
    }

    public void setMembersInherited(boolean membersInherited) {
        this.membersInherited = membersInherited;
    }

    private boolean isGroupMember(Set<GUID> memberGroupIds, GUID currentUserAccountID) {
        UserGroupManager userGroupManager = UserGroupManager.getInstance();
        Set set = userGroupManager.getGroupsForUser(currentUserAccountID);
        set.removeIf(g2 -> !memberGroupIds.contains(g2.getID()));
        return !set.isEmpty();
    }

    public GUID getId() {
        return this.id;
    }

    public void setId(GUID id) {
        this.id = id;
    }

    public GUID getTeamId() {
        return this.teamId;
    }

    public void setTeamId(GUID teamId) {
        this.teamId = teamId;
    }

    @Nonnull
    public String getDisplayName() {
        if (CoWorkManager.DIRECTMESSAGE_TEAM_ID.equals((Object)this.teamId)) {
            UserManager userManager = UserManager.getInstance();
            GUID gUID = userManager.getCurrentUserAccountID();
            if (this.memberUserIds != null && this.memberUserIds.size() == 2 && this.memberUserIds.contains(gUID)) {
                for (GUID gUID2 : this.memberUserIds) {
                    UserAccount userAccount;
                    if (gUID2.equals((Object)gUID) || (userAccount = userManager.getUserAccount(gUID2)) == null) continue;
                    return userAccount.getDisplayName();
                }
            }
            return CoWorkI18n.MSG_SERVER.getMsg("cowork.channel.orphaned", new Object[0]);
        }
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public Set<GUID> getAllMemberIds() {
        if (this.membersInherited) {
            CoWorkTeam coWorkTeam = CoWorkManager.getInstance().getTeam(this.teamId);
            if (coWorkTeam != null) {
                return coWorkTeam.getAllMemberIds();
            }
            return new HashSet<GUID>();
        }
        HashSet<GUID> hashSet = new HashSet<GUID>();
        if (this.memberUserIds != null) {
            hashSet.addAll(this.memberUserIds);
        }
        if (this.memberGroupIds != null) {
            for (GUID gUID : this.memberGroupIds) {
                hashSet.addAll(CoWorkTeam.getMembersOfGroup(gUID));
            }
        }
        return hashSet;
    }

    @Nonnull
    public Set<GUID> getMemberUserIds() {
        if (this.memberUserIds == null || this.memberUserIds.isEmpty()) {
            return new HashSet<GUID>();
        }
        return new HashSet<GUID>(this.memberUserIds);
    }

    public void setMemberUserIds(Set<GUID> memberUserIds) {
        this.memberUserIds = memberUserIds;
    }

    @Nonnull
    public Set<GUID> getMemberGroupIds() {
        if (this.memberGroupIds == null || this.memberGroupIds.isEmpty()) {
            return new HashSet<GUID>();
        }
        return new HashSet<GUID>(this.memberGroupIds);
    }

    public void setMemberGroupIds(Set<GUID> memberGroupIds) {
        this.memberGroupIds = memberGroupIds;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.description == null ? 0 : this.description.hashCode());
        n3 = 31 * n3 + (this.displayName == null ? 0 : this.displayName.hashCode());
        n3 = 31 * n3 + Arrays.hashCode(this.icon);
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        n3 = 31 * n3 + (int)(this.lastModified ^ this.lastModified >>> 32);
        n3 = 31 * n3 + (this.memberGroupIds == null || this.memberGroupIds.isEmpty() ? 0 : this.memberGroupIds.hashCode());
        n3 = 31 * n3 + (this.memberUserIds == null || this.memberUserIds.isEmpty() ? 0 : this.memberUserIds.hashCode());
        n3 = 31 * n3 + (this.membersInherited ? 1231 : 1237);
        n3 = 31 * n3 + (this.teamId == null ? 0 : this.teamId.hashCode());
        return n3;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoWorkChannel coWorkChannel = (CoWorkChannel)obj;
        if (this.description == null ? coWorkChannel.description != null : !this.description.equals(coWorkChannel.description)) {
            return false;
        }
        if (this.displayName == null ? coWorkChannel.displayName != null : !this.displayName.equals(coWorkChannel.displayName)) {
            return false;
        }
        if (!Arrays.equals(this.icon, coWorkChannel.icon)) {
            return false;
        }
        if (this.id == null ? coWorkChannel.id != null : !this.id.equals((Object)coWorkChannel.id)) {
            return false;
        }
        if (this.lastModified != coWorkChannel.lastModified) {
            return false;
        }
        if (this.memberGroupIds == null || this.memberGroupIds.isEmpty() ? coWorkChannel.memberGroupIds != null && !coWorkChannel.memberGroupIds.isEmpty() : !this.memberGroupIds.equals(coWorkChannel.memberGroupIds)) {
            return false;
        }
        if (this.memberUserIds == null || this.memberUserIds.isEmpty() ? coWorkChannel.memberUserIds != null && !coWorkChannel.memberUserIds.isEmpty() : !this.memberUserIds.equals(coWorkChannel.memberUserIds)) {
            return false;
        }
        if (this.membersInherited != coWorkChannel.membersInherited) {
            return false;
        }
        return !(this.teamId == null ? coWorkChannel.teamId != null : !this.teamId.equals((Object)coWorkChannel.teamId));
    }
}

