/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.api.model;

import com.inet.annotations.JsonData;
import com.inet.cowork.api.ChannelListener;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.id.GUID;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

@JsonData
public class ClientInChannelState {
    private String clientId;
    private transient Locale locale;
    private transient TimeZone timeZone;
    private GUID channelId;
    private GUID userId;
    private transient ChannelListener channelListener;
    private GUID targetMessageId;
    private transient List<GUID> visibleMessageIds;
    private transient Set<GUID> knownMessages = ConcurrentHashMap.newKeySet();
    private boolean writing;
    private long lastVisible;
    private boolean idle;
    private boolean focused;

    private ClientInChannelState() {
    }

    public ClientInChannelState(String clientId, GUID channelId, GUID userId, ChannelListener channelListener) {
        this.clientId = clientId;
        this.locale = ClientLocale.getThreadLocale();
        this.timeZone = ClientTimezone.getTimeZone();
        this.channelId = channelId;
        this.userId = userId;
        this.channelListener = channelListener;
        this.lastVisible = System.currentTimeMillis();
    }

    public GUID getChannelId() {
        return this.channelId;
    }

    public ChannelListener getChannelListener() {
        return this.channelListener;
    }

    public void setChannelListener(ChannelListener channelListener) {
        this.channelListener = channelListener;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public GUID getUserId() {
        return this.userId;
    }

    public void setTargetMessageId(GUID targetMessageId) {
        this.targetMessageId = targetMessageId;
    }

    public GUID getTargetMessageId() {
        return this.targetMessageId;
    }

    public void setVisibleMessageIds(List<GUID> visibleMessageIds) {
        this.visibleMessageIds = visibleMessageIds;
    }

    public List<GUID> getVisibleMessageIds() {
        return this.visibleMessageIds;
    }

    public Set<GUID> getKnownMessages() {
        return this.knownMessages;
    }

    public void setWriting(boolean writing) {
        this.writing = writing;
    }

    public boolean isWriting() {
        return this.writing;
    }

    public long getLastVisible() {
        return this.lastVisible;
    }

    public void setLastVisible(long lastVisible) {
        this.lastVisible = lastVisible;
    }

    public boolean isIdle() {
        return this.idle;
    }

    public void setIdle(boolean idle) {
        this.idle = idle;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public boolean isFocused() {
        return this.focused;
    }
}

