/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.InetHtmlConfiguration;
import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlEditorKit;
import com.inet.html.InetHtmlFontFactory;
import com.inet.html.css.StyleResolver;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.image.RemoteImage;
import com.inet.html.parser.converter.FontStyle;
import com.inet.html.parser.converter.FontWeight;
import com.inet.html.parser.converter.SingleAttributeValue;
import com.inet.html.utils.FontUtils;
import com.inet.html.utils.Logger;
import com.inet.html.views.BlankBoxPainter;
import com.inet.html.views.BoxView;
import com.inet.html.views.ContentView;
import com.inet.html.views.ControlView;
import com.inet.html.views.IBoxPainter;
import com.inet.html.views.form.FormRegistry;
import java.awt.Container;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.net.URLConnection;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;

public class RenderContext {
    public static final int DEVICE_TYPE_UNDEFINED = -1;
    public static final int BIDI_LTR = 0;
    public static final int BIDI_RTL = 1;
    public static final int BIDI_MIXED = 2;
    public static final int BREAK_MODE_OVERFLOW = 0;
    public static final int BREAK_MODE_WORDBREAK = 1;
    public static final int BREAK_MODE_WORDBREAKINLINE = 2;
    private final Document document;
    private boolean blockOnImageLoad = false;
    private FormRegistry formReg;
    private int selectionStart;
    private int selectionEnd;
    private JEditorPane textContainer;
    private Object renderHint = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
    private FontRenderContext frc = new FontRenderContext(null, false, false);
    private final InetHtmlFontFactory fontFactory;
    private boolean requiresFontRefreshOnSplit = false;
    private InetHtmlConfiguration config = InetHtmlConfiguration.getMailEditorConfig();
    private int bidiMode = 0;
    private Locale locale = Locale.getDefault();
    private Map<Object, AtomicInteger> pendingImages = new ConcurrentHashMap<Object, AtomicInteger>();
    private int imageLoadTimeout = 30000;
    private Thread imageLoadTimeoutThread;
    private Timeout imageLoadTimeoutRunnable;
    private Object media;
    private static final IBoxPainter EMPTY_PAINTER = new BlankBoxPainter();
    private int tabSize = -1;
    private int breakMode = 0;
    private boolean allowesFontFallback = true;
    private AtomicInteger heightAutoCounter = new AtomicInteger();
    private boolean isBodyHeightFixed = false;
    private int deviceType = -1;

    public RenderContext(Document document, FormRegistry formReg, InetHtmlFontFactory fontFactory) {
        this.document = document;
        this.fontFactory = fontFactory;
        if (fontFactory != null && fontFactory.requiresText()) {
            this.requiresFontRefreshOnSplit = true;
        }
        if (formReg == null) {
            formReg = new FormRegistry();
        }
        this.formReg = formReg;
        this.getPropertiesFromDocument();
    }

    private void getPropertiesFromDocument() {
        Object tabWidth;
        Object breakModeObj;
        if (this.document == null) {
            return;
        }
        Object configObj = this.document.getProperty(InetHtmlDocument.PROPERTY_CONFIGURATION);
        if (configObj instanceof InetHtmlConfiguration) {
            this.config = (InetHtmlConfiguration)configObj;
        }
        this.media = this.document.getProperty(InetHtmlDocument.PROPERTY_MEDIA);
        if (this.media != null && this.media == "print") {
            this.blockOnImageLoad = true;
        }
        if ((breakModeObj = this.document.getProperty(InetHtmlDocument.PROPERTY_BREAK_MODE)) != null) {
            if (breakModeObj == InetHtmlDocument.BREAK_MODE_WORDBREAK) {
                this.breakMode = 1;
            }
            if (breakModeObj == InetHtmlDocument.BREAK_MODE_WORDBREAKINLINE) {
                this.breakMode = 2;
            }
        }
        if ((tabWidth = this.document.getProperty(InetHtmlDocument.PROPERTY_TAB_WIDTH)) instanceof Number) {
            this.tabSize = ((Number)tabWidth).intValue();
        }
        this.allowesFontFallback = !Boolean.FALSE.equals(this.document.getProperty(InetHtmlDocument.PROPERTY_USE_FONT_FALLBACK));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkImageLoading() {
        this.media = this.deviceType != -1 ? (this.deviceType == 0 ? "screen" : (this.deviceType == 1 ? "print" : this.document.getProperty(InetHtmlDocument.PROPERTY_MEDIA))) : this.document.getProperty(InetHtmlDocument.PROPERTY_MEDIA);
        if (this.media == "print") {
            this.blockOnImageLoad = true;
            try {
                RenderContext renderContext = this;
                synchronized (renderContext) {
                    if (this.pendingImages.size() > 0 && (this.imageLoadTimeoutThread == null || this.imageLoadTimeoutThread.isAlive())) {
                        this.startTimeout();
                        this.wait(this.imageLoadTimeout * 2);
                    }
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public boolean isBlockOnImageLoad() {
        return this.blockOnImageLoad;
    }

    public void setFraction(boolean useFractional) {
        this.frc = new FontRenderContext(this.frc.getTransform(), this.frc.getAntiAliasingHint(), this.getMetricsHint(useFractional));
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    public void setFontRenderContext(FontRenderContext frc) {
        this.frc = frc;
        this.renderHint = frc.getAntiAliasingHint();
    }

    private Object getMetricsHint(boolean fractional) {
        return fractional ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
    }

    public Object getTextAntiAliasHint(boolean active) {
        if (active) {
            Map hintMap;
            Object toolkitHint;
            Object hints;
            Object hint = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
            JEditorPane container = this.getTextContainer();
            if (container != null && InetHtmlEditorKit.getRenderingMode() != InetHtmlEditorKit.RENDER_MODE.java_custom && (hints = container.getToolkit().getDesktopProperty("awt.font.desktophints")) instanceof Map && (toolkitHint = (hintMap = (Map)hints).get(RenderingHints.KEY_TEXT_ANTIALIASING)) != null) {
                hint = toolkitHint;
            }
            return hint;
        }
        return RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
    }

    public void registerControl(ControlView control) {
        this.formReg.addControl(control);
    }

    public void deregisterControl(ControlView control) {
        this.formReg.removeControl(control);
    }

    public void clearForms() {
        this.formReg.clear();
    }

    public void setTextContainer(JEditorPane container) {
        if (container == this.textContainer) {
            if (container != null) {
                this.selectionStart = this.textContainer.getSelectionStart();
                this.selectionEnd = this.textContainer.getSelectionEnd();
            }
            return;
        }
        this.textContainer = container;
        if (container == null) {
            this.selectionStart = 0;
            this.selectionEnd = 0;
            return;
        }
        if (container.getLocale() != null) {
            this.locale = container.getLocale();
        }
        this.selectionStart = this.textContainer.getSelectionStart();
        this.selectionEnd = this.textContainer.getSelectionEnd();
        if (this.renderHint != RenderingHints.VALUE_TEXT_ANTIALIAS_OFF) {
            this.renderHint = this.getTextAntiAliasHint(true);
            if (!this.renderHint.equals(this.frc.getAntiAliasingHint())) {
                this.frc = new FontRenderContext(this.frc.getTransform(), this.renderHint, this.frc.getFractionalMetricsHint());
            }
        }
    }

    public Document getTextContainerDocument() {
        return this.textContainer != null ? this.textContainer.getDocument() : null;
    }

    public EditorKit getTextContainerKit() {
        return this.textContainer != null ? this.textContainer.getEditorKit() : null;
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public JEditorPane getTextContainer() {
        return this.textContainer;
    }

    public int getViewportHeight() {
        if (this.textContainer != null) {
            Insets insets = this.textContainer.getInsets();
            Container cParent = this.textContainer.getParent();
            if (cParent instanceof JViewport) {
                Border scrollBorder;
                int borderOffset = 0;
                if (cParent.getParent() instanceof JScrollPane && (scrollBorder = ((JComponent)(cParent = cParent.getParent())).getBorder()) != null) {
                    Insets borderInsets = scrollBorder.getBorderInsets(cParent);
                    borderOffset += borderInsets.top + borderInsets.bottom;
                }
                return cParent.getHeight() - insets.top - insets.bottom - borderOffset;
            }
            return this.textContainer.getHeight() - insets.top - insets.bottom;
        }
        return -1;
    }

    public void registerRelativeHeight(boolean register) {
        if (register) {
            this.heightAutoCounter.incrementAndGet();
        } else {
            this.heightAutoCounter.decrementAndGet();
        }
    }

    public void setBodyHeightFixed(boolean isBodyHeightFixed) {
        this.isBodyHeightFixed = isBodyHeightFixed;
    }

    public boolean isLayoutOnHeightChange() {
        return !this.isBodyHeightFixed && this.heightAutoCounter.get() > 0;
    }

    public boolean paintSelection() {
        Caret caret;
        if (this.textContainer != null && (caret = this.textContainer.getCaret()) != null) {
            return caret.isSelectionVisible();
        }
        return false;
    }

    public void setTextAntiAlias(boolean useTextAntiAlias) {
        this.renderHint = this.getTextAntiAliasHint(useTextAntiAlias);
        this.frc = new FontRenderContext(this.frc.getTransform(), this.renderHint, this.frc.getFractionalMetricsHint());
    }

    public Object getTextAntiAliasHint() {
        return this.renderHint;
    }

    public Font getFont(BoxView view, boolean searchFallback) {
        String text;
        float size = view.getFontSize();
        SingleAttributeValue obj = StyleResolver.getAttributeValue(view.getElement(), AttributeFinder.FONT_FAMILY);
        String fontFamily = obj.getFamily();
        int style = 0;
        obj = StyleResolver.getAttributeValue(view.getElement(), AttributeFinder.FONT_STYLE);
        if (obj instanceof FontStyle && ((FontStyle)obj).isItalic()) {
            style |= 2;
        }
        if ((obj = StyleResolver.getAttributeValue(view.getElement(), AttributeFinder.FONT_WEIGHT)) instanceof FontWeight && ((FontWeight)obj).isBold()) {
            style |= 1;
        }
        if (this.fontFactory != null) {
            if (this.fontFactory.requiresText() || searchFallback) {
                String text2 = this.getTextFromView(view);
                if (searchFallback) {
                    return this.fontFactory.searchFontFor(text2, style, size);
                }
                return this.fontFactory.getFont(fontFamily, style, size, text2);
            }
            return this.fontFactory.getFont(fontFamily, style, size, null);
        }
        Font font = new Font(fontFamily, style, (int)size);
        if (searchFallback && font.canDisplayUpTo(text = this.getTextFromView(view)) >= 0) {
            font = FontUtils.getFontFor(text, style, size);
        }
        if (size != (float)((int)size)) {
            font = font.deriveFont(size);
        }
        return font;
    }

    private String getTextFromView(BoxView view) {
        String text = " ";
        if (view instanceof ContentView) {
            try {
                text = ((ContentView)view).getText();
            }
            catch (BadLocationException e) {
                Logger.error(e);
            }
        }
        return text;
    }

    public boolean isRefreshFontRequiredOnSplit() {
        return this.requiresFontRefreshOnSplit;
    }

    public static float getFontSize(Element elem) {
        return ((Float)elem.getAttributes().getAttribute((Object)TemporaryStyle.Attribute.FONT_SIZE)).floatValue();
    }

    public boolean collapseEmptyBlocks() {
        return !this.config.isTransformEmptyBlocks();
    }

    public boolean collapseTailingBreak() {
        return !this.config.isDoAlwaysBreak();
    }

    public void notifiyBidi(int bidiConstant, boolean overwrite) {
        if (overwrite) {
            this.bidiMode = bidiConstant;
        } else if (bidiConstant != this.bidiMode) {
            this.bidiMode = 2;
        }
    }

    public boolean requiresBidiCheck() {
        return this.bidiMode == 2;
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            this.locale = locale;
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public synchronized void notifyImageLoad(RemoteImage img) {
        if (img != null && (img.getStatus() == 0 || img.getStatus() == 1)) {
            AtomicInteger counter = this.pendingImages.get(img);
            if (counter == null) {
                counter = new AtomicInteger(1);
                this.pendingImages.put(img, counter);
            } else {
                counter.incrementAndGet();
            }
        }
        this.updateTimeout();
    }

    public synchronized void notifyImageLoadDone(RemoteImage img) {
        if (img == null || this.pendingImages.size() == 0) {
            return;
        }
        AtomicInteger counter = this.pendingImages.get(img);
        if (counter == null) {
            Logger.debug("LoadDone event for unregistered image " + img.getLocationString());
            return;
        }
        if (counter.decrementAndGet() == 0) {
            this.pendingImages.remove(img);
        }
        if (this.pendingImages.size() == 0) {
            this.resetImageTimeout();
            this.notifyAll();
        }
    }

    @Deprecated
    public int countBlockingImages() {
        return this.blockOnImageLoad ? this.pendingImages.size() : 0;
    }

    @Deprecated
    public Object getMedia() {
        return this.media;
    }

    public static IBoxPainter getEmptyBoxPainter() {
        return EMPTY_PAINTER;
    }

    public int getTabSize(int xOffset, int spaceWidth) {
        if (this.tabSize > 0) {
            return this.tabSize - xOffset % this.tabSize;
        }
        return spaceWidth;
    }

    public boolean allowTabs() {
        return this.tabSize > 0;
    }

    public int getBreakMode() {
        return this.breakMode;
    }

    public boolean isFontFallbackAllowed() {
        return this.allowesFontFallback;
    }

    public void updateTargetDevice(GraphicsDevice device) {
        this.deviceType = device != null ? device.getType() : 0;
    }

    public static void setSSLSocketFactory(URLConnection connection) {
    }

    public synchronized void resetImageTimeout() {
        if (this.imageLoadTimeoutThread != null) {
            this.imageLoadTimeoutThread.interrupt();
            try {
                this.imageLoadTimeoutThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.imageLoadTimeoutThread = null;
            this.imageLoadTimeoutRunnable = null;
        }
    }

    private synchronized void startTimeout() {
        if (this.imageLoadTimeoutThread == null) {
            this.imageLoadTimeoutRunnable = new Timeout();
            this.imageLoadTimeoutThread = new Thread((Runnable)this.imageLoadTimeoutRunnable, "Image Load Timeout");
            this.imageLoadTimeoutThread.start();
        }
    }

    private synchronized void updateTimeout() {
        if (this.imageLoadTimeoutThread != null && this.imageLoadTimeoutThread.isAlive()) {
            this.imageLoadTimeoutRunnable.updateTimeout();
        }
    }

    public void setImageLoadTimeout(int imageLoadTimeout) {
        this.imageLoadTimeout = Math.max(0, imageLoadTimeout);
    }

    private class Timeout
    implements Runnable {
        private long endTime;

        public Timeout() {
            this.updateTimeout();
        }

        public void updateTimeout() {
            this.endTime = System.currentTimeMillis() + (long)RenderContext.this.imageLoadTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (System.currentTimeMillis() < this.endTime) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            RenderContext renderContext = RenderContext.this;
            synchronized (renderContext) {
                RenderContext.this.notifyAll();
            }
        }
    }
}

