/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.CssDocument;
import com.inet.html.InetHtmlDocument;
import com.inet.html.ViewPainter;
import com.inet.html.css.CSS;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.ClearValue;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.Direction;
import com.inet.html.parser.converter.DisplayValue;
import com.inet.html.parser.converter.FloatValue;
import com.inet.html.parser.converter.FontSize;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.LineHeight;
import com.inet.html.parser.converter.ListPositionValue;
import com.inet.html.parser.converter.ListStyleType;
import com.inet.html.parser.converter.Overflow;
import com.inet.html.parser.converter.Position;
import com.inet.html.parser.converter.TextAlign;
import com.inet.html.parser.converter.UnicodeBidi;
import com.inet.html.parser.converter.UriValue;
import com.inet.html.parser.converter.VerticalAlign;
import com.inet.html.parser.converter.VisibilityValue;
import com.inet.html.parser.converter.WhiteSpace;
import com.inet.html.utils.CSSRules;
import com.inet.html.utils.DOMUtils;
import com.inet.html.views.BoxPainter;
import com.inet.html.views.HtmlRootView;
import com.inet.html.views.IBoxPainter;
import com.inet.html.views.RenderContext;
import com.inet.html.views.TableBoxPainter;
import com.inet.html.views.ViewPositionInfo;
import com.inet.html.views.layouts.BlockLayout;
import com.inet.html.views.layouts.ILayouted;
import com.inet.html.views.layouts.Layout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;

public abstract class BoxView
extends View {
    public IBoxPainter box;
    private LengthUnit widthUnit;
    private LengthUnit heightUnit;
    private int contentWidth = 0;
    private int contentHeight = 0;
    private int outerWidth = 0;
    private int outerHeight = 0;
    private int contentVerticalOffset = 0;
    private float fontSize = 12.0f;
    private int offset;
    private int length = -1;
    private boolean isMarker = false;
    private boolean isBreak;
    private byte visibility = 0;
    private int lineHeight = -1;
    private byte vAlign = 1;
    private Boolean isListItemWithMarker = null;
    private byte justification;
    private short firstLineBaseLine = 0;
    private byte whiteSpace = 0;
    private byte autoMarginJustify = (byte)-1;
    private byte clear;
    private byte overflow = 0;
    private byte display = (byte)3;
    private byte position = 0;
    private byte floatValue = 0;
    private byte direction = 0;
    private byte bidi = 0;
    private boolean isNativeLTR = true;
    private boolean preset;
    private HashMap<Element, IBoxPainter> childPainters;
    public static final int BASELINE = 2;
    public static final int STATUS_UPTODATE = 0;
    public static final int STATUS_REQ_LAYOUT = 1;
    public static final int STATUS_REQ_PRELAYOUT = 2;
    private static final int MODE_BORDER = 0;
    protected static final int MODE_PADDING = 1;
    protected static final int MODE_MARGIN = 2;
    private int status = 2;
    private ViewPainter painter;
    private HtmlRootView root;
    private RenderContext renderContext;
    private Object elementName;
    private boolean hasRelativeMargin = false;
    private boolean hasRelativePadding = false;

    public BoxView(Element elem) {
        super(elem);
        if (elem == null) {
            return;
        }
        this.elementName = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
        this.isBreak = this.elementName == HTML.Tag.BR;
        Document doc = elem.getDocument();
        if (doc instanceof InetHtmlDocument) {
            ((InetHtmlDocument)doc).checkInit(elem);
        }
        this.painter = null;
    }

    public BoxView(Element elem, ViewPainter painter) {
        this(elem);
        this.painter = painter;
    }

    public IBoxPainter getBox() {
        return this.box;
    }

    @Override
    public void setParent(View parent) {
        if (this.getParent() != null && this.getParent() == parent) {
            return;
        }
        super.setParent(parent);
        if (parent != null) {
            this.renderContext = this.getHTMLRoot().getRenderContext();
            this.setPropertiesFromAttributes(false);
        } else if (this.box != null) {
            this.box.reset();
        }
    }

    public void updateRelativeValues(int parentWidth) {
        if (this.hasRelativeMargin()) {
            this.box.setMargins(this.getBaseInsets(2, parentWidth, this.getElement()));
        }
        if (this.hasRelativePadding()) {
            this.box.setPadding(this.getBaseInsets(1, parentWidth, this.getElement()));
        }
    }

    Insets getBaseInsets(int type, int reference, Element refElement) {
        Insets result = null;
        switch (type) {
            case 0: {
                result = new Insets(this.getLengthInt(refElement, AttributeFinder.BORDER_TOP_WIDTH, type, reference), this.getLengthInt(refElement, AttributeFinder.BORDER_LEFT_WIDTH, type, reference), this.getLengthInt(refElement, AttributeFinder.BORDER_BOTTOM_WIDTH, type, reference), this.getLengthInt(refElement, AttributeFinder.BORDER_RIGHT_WIDTH, type, reference));
                break;
            }
            case 1: {
                result = new Insets(this.getLengthInt(refElement, AttributeFinder.PADDING_TOP, type, reference), this.getLengthInt(refElement, AttributeFinder.PADDING_LEFT, type, reference), this.getLengthInt(refElement, AttributeFinder.PADDING_BOTTOM, type, reference), this.getLengthInt(refElement, AttributeFinder.PADDING_RIGHT, type, reference));
                break;
            }
            case 2: {
                result = new Insets(this.getLengthInt(refElement, AttributeFinder.MARGIN_TOP, type, reference), this.getLengthInt(refElement, AttributeFinder.MARGIN_LEFT, type, reference), this.getLengthInt(refElement, AttributeFinder.MARGIN_BOTTOM, type, reference), this.getLengthInt(refElement, AttributeFinder.MARGIN_RIGHT, type, reference));
            }
        }
        if (result == null || IBoxPainter.EMPTY_INSETS.equals(result)) {
            return IBoxPainter.EMPTY_INSETS;
        }
        return result;
    }

    private int getLengthInt(Element elem, AttributeFinder<?> finder, int type, int reference) {
        LengthUnit unit = (LengthUnit)StyleResolver.getAttributeValue(elem, finder);
        if (unit == null || unit.getType() == -1) {
            return 0;
        }
        if (unit.getType() == 1 && elem == this.getElement()) {
            this.hasRelativeMargin = this.hasRelativeMargin() | type == 2;
            this.hasRelativePadding = this.hasRelativePadding() | type == 1;
        }
        if (unit.getType() == 2 && elem == this.getElement()) {
            reference = (int)this.getFontSize();
            this.hasRelativeMargin = this.hasRelativeMargin() | type == 2;
            this.hasRelativePadding = this.hasRelativePadding() | type == 1;
        }
        float value = unit.calculateValue(reference, this);
        return Math.round(value);
    }

    protected final void changeOnlyParent(View parent) {
        super.setParent(parent);
    }

    public void factoryPreset(byte floatValue, byte display, byte position) {
        this.floatValue = floatValue;
        this.display = display;
        this.position = position;
        this.preset = true;
    }

    protected void setPropertiesFromAttributes(boolean inline) {
        StyleResolver r;
        LineHeight lineHeightAttribute;
        Object cssFontSize;
        VerticalAlign vAlignValue;
        if (this.getParent() == null) {
            return;
        }
        WhiteSpace wsValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.WHITE_SPACE);
        if (wsValue != null) {
            this.whiteSpace = wsValue.getValue();
        }
        if ((vAlignValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.VERTICAL_ALIGN)) != null) {
            this.vAlign = vAlignValue.getAlign();
        }
        if (this.elementName != HTML.Tag.CONTENT) {
            VisibilityValue visibilityValue;
            ClearValue clearValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.CLEAR);
            if (clearValue != null) {
                this.clear = clearValue.getClear();
            }
            if ((visibilityValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.VISIBILITY)) != null) {
                this.visibility = visibilityValue.getVisibility();
            }
            this.setBlockProperties();
        }
        if ((cssFontSize = this.getAttributes().getAttribute((Object)TemporaryStyle.Attribute.FONT_SIZE)) == null) {
            if (this.getParent() instanceof BoxView) {
                this.fontSize = ((BoxView)this.getParent()).getFontSize();
            }
        } else {
            this.fontSize = cssFontSize.getClass() == Float.class ? ((Float)cssFontSize).floatValue() : ((FontSize)cssFontSize).getValue(this);
        }
        if ((lineHeightAttribute = (r = ((CssDocument)this.getDocument()).getStyleResolver()).getAttributeValueNonInherit(this.getElement(), AttributeFinder.LINE_HEIGHT)) == null) {
            View parent = this.getParent();
            boolean lineHeightSet = false;
            if (parent instanceof BoxView) {
                BoxView parentBox = (BoxView)parent;
                for (Element parentElement = this.getElement().getParentElement(); parentBox.getElement() != parentElement && parentElement != null; parentElement = parentElement.getParentElement()) {
                    LineHeight parentLH = r.getAttributeValueNonInherit(parentElement, AttributeFinder.LINE_HEIGHT);
                    if (parentLH == null) continue;
                    this.lineHeight = parentLH.isNormal() ? -1 : (int)parentLH.calculateValue(this.getFontSizeOfElement(parentElement), this);
                    lineHeightSet = true;
                    break;
                }
                if (!lineHeightSet) {
                    this.lineHeight = parentBox.getLineHeight();
                }
            }
        } else if (!lineHeightAttribute.isNormal()) {
            this.lineHeight = Math.round(lineHeightAttribute.calculateValue(this.fontSize, this));
        }
        this.box = this.createBoxPainter();
    }

    private float getFontSizeOfElement(Element element) {
        Object cssFontSize = element.getAttributes().getAttribute((Object)TemporaryStyle.Attribute.FONT_SIZE);
        if (cssFontSize == null) {
            if (this.getParent() instanceof BoxView) {
                return ((BoxView)this.getParent()).getFontSize();
            }
            return 16.0f;
        }
        if (cssFontSize.getClass() == Float.class) {
            return ((Float)cssFontSize).floatValue();
        }
        return ((FontSize)cssFontSize).getValue(this);
    }

    protected IBoxPainter createBoxPainter() {
        if (this.display == 12) {
            return new TableBoxPainter(this);
        }
        return BoxPainter.createBoxPainter(this);
    }

    protected void setBlockProperties() {
        UnicodeBidi bidiValue;
        TextAlign cssAlign;
        this.widthUnit = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.WIDTH);
        this.heightUnit = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.HEIGHT);
        Overflow overflowValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.OVERFLOW);
        if (overflowValue != null) {
            this.overflow = overflowValue.getOverflow();
        }
        if ((cssAlign = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.TEXT_ALIGN)) != null) {
            this.justification = cssAlign.getJustification();
        }
        if (!this.preset) {
            Position positionValue;
            DisplayValue displayValue;
            this.display = this.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.CONTENT ? (byte)2 : (byte)((displayValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.DISPLAY)) != null ? (int)displayValue.getDisplay() : 3);
            FloatValue floatValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.FLOAT);
            if (floatValue != null) {
                this.floatValue = floatValue.getFloat();
            }
            if (this.position == 0 && (positionValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.POSITION)) != null) {
                this.position = positionValue.getPosition();
            }
        }
        this.preset = false;
        Direction dir = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.DIRECTION);
        if (dir != null) {
            this.direction = dir.getValue();
        }
        if ((bidiValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.UNICODEBIDI)) != null) {
            this.bidi = bidiValue.getValue();
        }
        if (this.isBlock()) {
            LengthUnit marginLeft = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.MARGIN_LEFT);
            LengthUnit marginRight = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.MARGIN_RIGHT);
            if (marginLeft != null && marginLeft.isAuto()) {
                this.autoMarginJustify = marginRight != null && marginRight.isAuto() ? (byte)1 : (byte)2;
            } else if (marginRight != null && marginRight.isAuto()) {
                this.autoMarginJustify = 0;
            }
        }
    }

    public void setJustification(byte justification) {
        this.justification = justification;
    }

    public boolean isWidthSet() {
        return this.widthUnit != null;
    }

    @Override
    public void setSize(float newWidth, float newHeight) {
        this.outerWidth = (int)Math.ceil(newWidth);
        this.outerHeight = (int)Math.ceil(newHeight);
        int borderSize = this.box.getBorderInsets().left + this.box.getBorderInsets().right;
        int paddingSize = this.box.getPadding().left + this.box.getPadding().right;
        this.contentWidth = this.outerWidth - borderSize - paddingSize;
        borderSize = this.box.getBorderInsets().top + this.box.getBorderInsets().bottom;
        paddingSize = this.box.getPadding().top + this.box.getPadding().bottom;
        this.contentHeight = this.outerHeight - borderSize - paddingSize;
    }

    public void setSizeContent(float newWidth, float newHeight) {
        this.contentWidth = (int)Math.ceil(newWidth);
        this.contentHeight = (int)Math.ceil(newHeight);
        int borderSize = this.box.getBorderInsets().left + this.box.getBorderInsets().right;
        int paddingSize = this.box.getPadding().left + this.box.getPadding().right;
        this.outerWidth = this.contentWidth + borderSize + paddingSize;
        borderSize = this.box.getBorderInsets().top + this.box.getBorderInsets().bottom;
        paddingSize = this.box.getPadding().top + this.box.getPadding().bottom;
        this.outerHeight = this.contentHeight + borderSize + paddingSize;
    }

    public void setContentWidth(float newWidth) {
        this.contentWidth = (int)Math.ceil(newWidth);
        if (this instanceof ILayouted) {
            ((ILayouted)((Object)this)).predictWidth((int)newWidth);
        }
        int borderSize = this.box.getBorderInsets().left + this.box.getBorderInsets().right;
        int paddingSize = this.box.getPadding().left + this.box.getPadding().right;
        this.outerWidth = this.contentWidth + borderSize + paddingSize;
    }

    public LengthUnit getWidthUnit() {
        return this.widthUnit;
    }

    public LengthUnit getHeightUnit() {
        return this.heightUnit;
    }

    public int getJustification() {
        if (this.justification == -1) {
            return this.isLTR() ? 0 : 2;
        }
        return this.justification;
    }

    public int getAutoMarginJustify() {
        return this.autoMarginJustify;
    }

    @Override
    public float getAlignment(int axis) {
        if (axis == 0) {
            switch (this.getJustification()) {
                case 0: {
                    return 0.0f;
                }
                case 2: {
                    return 1.0f;
                }
            }
            return 0.5f;
        }
        return this.vAlign;
    }

    public int getSwingAlign(int axis) {
        if (axis == 0) {
            switch (this.getJustification()) {
                case 0: {
                    return 2;
                }
                case 2: {
                    return 4;
                }
            }
            return 0;
        }
        switch (this.vAlign) {
            case 3: 
            case 6: 
            case 8: {
                return 3;
            }
            case 4: 
            case 5: 
            case 7: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public int getResizeWeight(int axis) {
        LengthUnit unit = axis == 0 ? this.widthUnit : this.heightUnit;
        if (unit != null && unit.isAbsolute()) {
            return 0;
        }
        return 1;
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    public int getContentHeight() {
        return this.contentHeight > 1 ? this.contentHeight : 1;
    }

    public int getOuterHeight() {
        return this.outerHeight > 1 ? this.outerHeight : 1;
    }

    public int getOuterWidth() {
        return this.outerWidth;
    }

    public int getCompleteHight() {
        return this.getContentHeight();
    }

    public int getLeftInset() {
        return this.box.getPadding().left + this.box.getBorderInsets().left;
    }

    public int getRightInset() {
        return this.box.getPadding().right + this.box.getBorderInsets().right;
    }

    public int getTopInset() {
        return this.box.getPadding().top + this.box.getBorderInsets().top;
    }

    public int getBottomInset() {
        return this.box.getPadding().bottom + this.box.getBorderInsets().bottom;
    }

    public Insets getMargins() {
        return this.box.getMargins();
    }

    @Override
    public int getViewIndex(int pos, Position.Bias b) {
        if (b == Position.Bias.Backward) {
            --pos;
        }
        return this.getViewIndex(pos);
    }

    public int getViewIndex(int pos) {
        for (int i = 0; i < this.getViewCount(); ++i) {
            View v = this.getView(i);
            if (pos < v.getStartOffset() || pos >= v.getEndOffset()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getStartOffset() {
        return super.getStartOffset() + this.offset;
    }

    @Override
    public int getEndOffset() {
        return this.length >= 0 ? super.getStartOffset() + this.offset + this.length : super.getEndOffset();
    }

    public void setStartAndEndOffset(int start, int end) {
        this.offset = start - super.getStartOffset();
        this.length = end - start;
    }

    @Override
    public void paint(Graphics g, Shape allocation) {
        if (this.getVisibility() != 0) {
            return;
        }
        if (this.isCanceledByPainter(g, allocation)) {
            return;
        }
        Rectangle rect = (Rectangle)allocation;
        this.box.paint(g, rect, 0, this);
    }

    protected boolean isCanceledByPainter(Graphics g, Shape allocation) {
        ViewPainter viewPainter = this.getPainter();
        return viewPainter != null && this.getViewCount() == 0 && !viewPainter.paint(g, allocation);
    }

    public boolean isInFlow() {
        return CSSRules.isInFlow(this.position, this.floatValue);
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public boolean isBlock() {
        Object name = this.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (name == HTML.Tag.IMPLIED) {
            return true;
        }
        return CSSRules.isBlockFormatRequired(this);
    }

    public boolean isBlockFormattingContext() {
        return this.isBlock() && (this.overflow != 1 || this.isFloating() || this.isAbsolutePositioned());
    }

    public int getClear() {
        return this.clear;
    }

    public int getVisibility() {
        return this.visibility;
    }

    public void performPreLayout() {
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            BoxView view = (BoxView)this.getView(i);
            if (view == null || view.getStatus() != 2) continue;
            view.performPreLayout();
        }
    }

    public abstract void performLayoutWidth();

    public abstract Rectangle performLayout(boolean var1);

    public abstract void performLayoutVAlign(int var1);

    public void forceLayout() {
        View parent2 = this.getParent();
        if (parent2 != null) {
            ((BoxView)parent2).forceLayout();
        }
    }

    public void forceLayout(long timeout) {
        if (this.getParent() != null) {
            ((BoxView)this.getParent()).forceLayout(timeout);
        }
    }

    public void setContentVerticalOffset(int contentVerticalOffset) {
        this.contentVerticalOffset = contentVerticalOffset;
    }

    public int getContentVerticalOffset() {
        return this.contentVerticalOffset;
    }

    public boolean isMarker() {
        return this.isMarker;
    }

    public void setMarker(boolean isMarker) {
        this.isMarker = isMarker;
    }

    public ColorValue getBackgroundValue() {
        return this.box.getBackgroundValue();
    }

    public ColorValue getBorderTopColor() {
        return this.box.getBorderTopColor();
    }

    public ColorValue getBorderLeftColor() {
        return this.box.getBorderLeftColor();
    }

    public ColorValue getBorderRightColor() {
        return this.box.getBorderRightColor();
    }

    public ColorValue getBorderBottomColor() {
        return this.box.getBorderBottomColor();
    }

    public void setBorderBottomColor(ColorValue borderBottomColor) {
        this.box.setBorderBottomColor(borderBottomColor);
    }

    public void setBorderLeftColor(ColorValue borderLeftColor) {
        this.box.setBorderLeftColor(borderLeftColor);
    }

    public void setBorderRightColor(ColorValue borderRightColor) {
        this.box.setBorderRightColor(borderRightColor);
    }

    public void setBorderTopColor(ColorValue borderTopColor) {
        this.box.setBorderTopColor(borderTopColor);
    }

    public void setBackgroundValue(ColorValue backgroundValue) {
        this.box.setBackgroundValue(backgroundValue);
    }

    public int getFirstLineBaseLine() {
        return this.firstLineBaseLine;
    }

    public void setFirstLineBaseLine(short firstLineBaseLine) {
        this.firstLineBaseLine = firstLineBaseLine;
    }

    public boolean isBreak() {
        return this.isBreak;
    }

    public boolean isListItemWithMarker() {
        if (this.isListItemWithMarker != null) {
            return this.isListItemWithMarker;
        }
        if (this instanceof ILayouted && ((ILayouted)((Object)this)).getLayout() instanceof BlockLayout) {
            View view0;
            this.isListItemWithMarker = this.getViewCount() > 0 ? Boolean.valueOf((view0 = this.getView(0)) instanceof BoxView && ((BoxView)view0).isMarker()) : Boolean.FALSE;
            return this.isListItemWithMarker;
        }
        Element element = this.getElement();
        if (element.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.IMPLIED) {
            Element parent = element.getParentElement();
            if (element.getElementCount() == 0 || parent.getElement(0) != element.getElement(0)) {
                this.isListItemWithMarker = Boolean.FALSE;
                return false;
            }
            ListPositionValue markerPosition = StyleResolver.getAttributeValue(element, AttributeFinder.LIST_STYLE_POSITION);
            if (markerPosition != null && markerPosition.getType() == 0) {
                this.isListItemWithMarker = Boolean.FALSE;
                return false;
            }
            element = parent;
        }
        DisplayValue disp = StyleResolver.getAttributeValue(element, AttributeFinder.DISPLAY);
        FloatValue floating = StyleResolver.getAttributeValue(element, AttributeFinder.FLOAT);
        if (disp != null && disp.getDisplay() == 4 && (floating == null || floating.getFloat() == 0)) {
            ListStyleType type = StyleResolver.getAttributeValue(element, AttributeFinder.LIST_STYLE_TYPE);
            UriValue image = AttributeFinder.LIST_STYLE_IMAGE.getAttributeValue(this);
            if (type != null && type.getType() != 18 || image != null && !image.isNone()) {
                this.isListItemWithMarker = Boolean.TRUE;
                return true;
            }
        }
        this.isListItemWithMarker = Boolean.FALSE;
        return false;
    }

    public void addBoxPainter(Element elem, IBoxPainter painter) {
        if (painter != null && elem != null) {
            if (this.childPainters == null) {
                this.childPainters = new HashMap();
            }
            this.childPainters.put(elem, painter);
        }
    }

    public IBoxPainter getBoxPainter(Element descendant) {
        if (this.childPainters != null) {
            return this.childPainters.get(descendant);
        }
        return null;
    }

    public int getWhiteSpace() {
        return this.whiteSpace;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        if (status != 0) {
            this.getHTMLRoot().blockOnLayoutRunning();
            this.propagateStatus(status);
        } else {
            this.status = status;
        }
    }

    private void propagateStatus(int status) {
        BoxView parentView;
        this.status = status;
        View v = this.getParent();
        if (v instanceof BoxView && (parentView = (BoxView)v).getStatus() < status) {
            parentView.setStatus(status);
        }
    }

    public void setStatusLocal(int status) {
        this.status = status;
    }

    public ViewPositionInfo getViewForPosition(Point position, Rectangle bounds) {
        Layout layout;
        if (this instanceof ILayouted && (layout = ((ILayouted)((Object)this)).getLayout()) != null) {
            return layout.getViewForPosition(position, bounds);
        }
        return null;
    }

    public HtmlRootView getHTMLRoot() {
        if (this.root == null) {
            View parent = this.getParent();
            this.root = ((BoxView)parent).getHTMLRoot();
        }
        return this.root;
    }

    public void setRoot(HtmlRootView root) {
        this.root = root;
    }

    public ViewPainter getPainter() {
        return this.painter;
    }

    public void setPainter(ViewPainter viewPainter) {
        this.painter = viewPainter;
    }

    public boolean isBreakable() {
        return true;
    }

    public int getDisplay() {
        return this.display;
    }

    public RenderContext getRenderContext() {
        return this.renderContext;
    }

    public boolean isTableCell() {
        return this.display == 12;
    }

    public int getOverflow() {
        return this.overflow;
    }

    public boolean isFloating() {
        return CSSRules.isFloating(this.position, this.floatValue);
    }

    public int getFloat() {
        return this.floatValue;
    }

    public int getPosition() {
        return this.position;
    }

    protected void setPosition(byte position) {
        this.position = position;
    }

    public boolean isAbsolutePositioned() {
        return this.position >= 2;
    }

    public Rectangle getSpan() {
        return new Rectangle(0, 0, this.getOuterWidth(), this.getOuterHeight());
    }

    public int getDirection() {
        return this.direction;
    }

    public int getUnicodeBidi() {
        return this.bidi;
    }

    public boolean isLTR() {
        return this.bidi == 0 && this.isNativeLTR || this.direction == 0;
    }

    public void setIsNativeLTR(boolean isLTR) {
        this.isNativeLTR = isLTR;
    }

    public boolean isNativeLTR() {
        return this.isNativeLTR;
    }

    public String getID() {
        AttributeSet attributes = this.getElement().getAttributes();
        Object id = attributes.isDefined((Object)HTML.Attribute.ID) ? attributes.getAttribute((Object)HTML.Attribute.ID) : null;
        return id != null ? id.toString() : null;
    }

    public Object getTag() {
        return this.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
    }

    protected boolean hasRelativeMargin() {
        return this.hasRelativeMargin;
    }

    protected boolean hasRelativePadding() {
        return this.hasRelativePadding;
    }

    public boolean getVisibleDOM(Rectangle2D clip, DOMUtils.ResultMap result) {
        if (this instanceof ILayouted) {
            Layout layout;
            boolean hasVisibleChildren;
            double clipStart = clip.getY();
            double clipEnd = clip.getMaxY();
            if (this.getContentVerticalOffset() != 0) {
                clip = new Rectangle2D.Double(clip.getX(), clip.getY() - (double)this.getContentVerticalOffset(), clip.getWidth(), clip.getHeight());
            }
            DOMUtils.DOMVisibilityResult viewResult = new DOMUtils.DOMVisibilityResult(this, (hasVisibleChildren = (layout = ((ILayouted)((Object)this)).getLayout()).getVisibleElements(clip, result)) ? DOMUtils.Visibility.visible : DOMUtils.Visibility.dummy);
            viewResult.setAttribute((Object)CSS.Attribute.WIDTH, new LengthUnit(this.getContentWidth()));
            if (this.getTag() != HTML.Tag.HTML && this.getTag() != HTML.Tag.BODY) {
                viewResult.setAttribute((Object)CSS.Attribute.HEIGHT, new LengthUnit(this.getContentHeight()));
            }
            result.put(this.getElement(), viewResult);
            if (!hasVisibleChildren && this.isBlock() && clipStart < 0.0 && (double)this.getOuterHeight() > clipEnd) {
                result.setFirstClippedContentLocation(-clipStart);
                result.remove(this.getElement());
            }
            return hasVisibleChildren;
        }
        throw new IllegalStateException("getVisibleDOM requires a custom implementation for non-layouted views");
    }
}

