/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.InetHtmlDocument;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.image.AnimationObserver;
import com.inet.html.image.ImageCache;
import com.inet.html.image.RemoteImage;
import com.inet.html.parser.converter.BackgroundPosition;
import com.inet.html.parser.converter.BackgroundRepeat;
import com.inet.html.parser.converter.BackgroundSize;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.UriValue;
import com.inet.html.views.BoxView;
import com.inet.html.views.HtmlRootView;
import com.inet.html.views.IBackgroundPainter;
import com.inet.html.views.IBoxPainter;
import com.inet.html.views.RenderContext;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.Element;
import javax.swing.text.View;

public class BackgroundPainter
implements IBackgroundPainter {
    private BoxView view;
    private final Element elem;
    private ColorValue backgroundValue;
    private BackgroundSize backgroundSize;
    private boolean initDone = false;
    private int refX = Integer.MIN_VALUE;
    private int refY = Integer.MIN_VALUE;
    private ImageData imageData = null;
    private Rectangle lastPaint = new Rectangle();
    private RemoteImage fetcher;
    private RenderContext renderContext;

    public BackgroundPainter(Element elem, RenderContext renderContext) {
        this.elem = elem;
        this.renderContext = renderContext;
        this.init(true);
    }

    public BackgroundPainter(Element elem, BoxView startReference) {
        this.view = startReference;
        this.elem = elem;
        this.renderContext = startReference != null ? startReference.getRenderContext() : null;
        this.init(false);
    }

    private void init(boolean useMargins) {
        this.backgroundSize = StyleResolver.getAttributeValue(this.elem, AttributeFinder.BACKGROUND_SIZE);
        this.backgroundValue = StyleResolver.getAttributeValue(this.elem, AttributeFinder.BACKGROUND_COLOR);
        UriValue backgroundImage = StyleResolver.getAttributeValue(this.elem, AttributeFinder.BACKGROUND_IMAGE);
        if (backgroundImage != null && !backgroundImage.isNone()) {
            IBoxPainter box;
            View parent;
            this.imageData = new ImageData();
            this.imageData.backgroundImage = backgroundImage;
            BackgroundRepeat rep = StyleResolver.getAttributeValue(this.elem, AttributeFinder.BACKGROUND_REPEAT);
            if (rep != null) {
                this.imageData.repeat = rep.getRepeatType();
            }
            this.imageData.bgPosition = StyleResolver.getAttributeValue(this.elem, AttributeFinder.BACKGROUND_POSITION);
            View view = parent = this.view != null ? this.view.getParent() : null;
            if (parent instanceof HtmlRootView && (box = ((HtmlRootView)parent).getBox()) instanceof BackgroundPainter) {
                BackgroundPainter parentPainter = (BackgroundPainter)((Object)box);
                if (parentPainter.imageData != null && backgroundImage.equals(parentPainter.imageData.backgroundImage)) {
                    return;
                }
            }
            this.loadImage();
        }
    }

    private Dimension getImageSize(int viewWidth, int viewHeight) {
        float drawWidth;
        float drawHeight;
        int w = this.imageData.image.getWidth();
        int h = this.imageData.image.getHeight();
        if (this.backgroundSize == null || this.backgroundSize.isAuto()) {
            return new Dimension(w, h);
        }
        if (this.backgroundSize.isContain()) {
            double scale = Math.min((double)viewWidth / (double)w, (double)viewHeight / (double)h);
            return new Dimension((int)Math.round((double)w * scale), (int)Math.round((double)h * scale));
        }
        if (this.backgroundSize.isCover()) {
            double scale = Math.max((double)viewWidth / (double)w, (double)viewHeight / (double)h);
            return new Dimension((int)Math.round((double)w * scale), (int)Math.round((double)h * scale));
        }
        LengthUnit pX = this.backgroundSize.getPercentX();
        LengthUnit pY = this.backgroundSize.getPercentY();
        if (this.backgroundSize.getPercentX().isAuto()) {
            drawHeight = pY.calculateValue(viewHeight, this.getReferenceView());
            drawWidth = drawHeight / (float)h * (float)w;
        } else if (this.backgroundSize.getPercentY().isAuto()) {
            drawWidth = pX.calculateValue(viewWidth, this.getReferenceView());
            drawHeight = drawWidth / (float)w * (float)h;
        } else {
            drawWidth = pX.calculateValue(viewWidth, this.getReferenceView());
            drawHeight = pY.calculateValue(viewHeight, this.getReferenceView());
        }
        return new Dimension(Math.round(drawWidth), Math.round(drawHeight));
    }

    @Override
    public void paintBackground(Graphics g, int x, int y, int width, int height, BoxView currentView) {
        ColorValue backgroundValue;
        if (this.view == null) {
            this.view = currentView;
        }
        if (this.refX == Integer.MIN_VALUE && this.refY == Integer.MIN_VALUE) {
            this.view = currentView;
        }
        if (this.view != null && this.view.getElement() == currentView.getElement() && this.view.getStartOffset() == currentView.getStartOffset()) {
            this.refX = x;
            this.refY = y;
        }
        if ((backgroundValue = this.backgroundValue) != null && !backgroundValue.isTransparent()) {
            Color background = backgroundValue.getValue();
            g.setColor(background);
            g.fillRect(x, y, width, height);
        }
        Shape clip = g.getClip();
        boolean resetClip = false;
        if (this.imageData != null && this.imageData.image != null) {
            this.lastPaint.setBounds(new Rectangle(x, y, width, height));
            if (this.imageData.image != null && this.imageData.image.getWidth() > 0 && this.imageData.image.getHeight() > 0) {
                Rectangle bgClip = new Rectangle(x, y, width, height);
                Rectangle clipBounds = g.getClipBounds();
                if (clipBounds != null) {
                    bgClip = bgClip.intersection(clipBounds);
                }
                if (bgClip.height <= 0 || bgClip.getHeight() <= 0.0 || bgClip.width <= 0) {
                    return;
                }
                g.setClip(bgClip);
                resetClip = true;
                Dimension size = this.getImageSize(width, height);
                int w = size.width;
                int h = size.height;
                int positionX = this.refX;
                int positionY = this.refY;
                if (this.imageData.bgPosition != null) {
                    positionX = (int)((float)positionX + this.imageData.bgPosition.getPercentX().calculateValue(width - w, this.getReferenceView()));
                    positionY = (int)((float)positionY + this.imageData.bgPosition.getPercentY().calculateValue(height - h, this.getReferenceView()));
                }
                int rightBound = Math.min(x + width, bgClip.x + bgClip.width);
                int lowerBound = Math.min(y + height, bgClip.y + bgClip.height);
                int positionX0 = x - (x - positionX) % w;
                positionX0 += (bgClip.x - positionX0) / w * w;
                int positionY0 = y - (y - positionY) % h;
                positionY0 += (bgClip.y - positionY0) / h * h;
                switch (this.imageData.repeat) {
                    case 0: {
                        for (positionX = positionX0; positionX < rightBound; positionX += w) {
                            for (positionY = positionY0; positionY < lowerBound; positionY += h) {
                                g.drawImage(this.imageData.image.getContent(), positionX, positionY, w, h, this.imageData.imageObserver);
                            }
                        }
                        break;
                    }
                    case 1: {
                        while (positionX < rightBound) {
                            g.drawImage(this.imageData.image.getContent(), positionX, positionY, w, h, this.imageData.imageObserver);
                            positionX += w;
                        }
                        break;
                    }
                    case 2: {
                        while (positionY < lowerBound) {
                            g.drawImage(this.imageData.image.getContent(), positionX, positionY, w, h, this.imageData.imageObserver);
                            positionY += h;
                        }
                        break;
                    }
                    case 3: {
                        g.drawImage(this.imageData.image.getContent(), positionX, positionY, w, h, this.imageData.imageObserver);
                    }
                }
            }
        }
        if (resetClip) {
            g.setClip(clip);
        }
    }

    private void loadImage() {
        if (this.imageData == null) {
            this.imageData = new ImageData();
        }
        if (this.imageData.backgroundImage != null) {
            InetHtmlDocument document = (InetHtmlDocument)this.elem.getDocument();
            this.imageData.imageObserver = new ImageHandler(document.getProperty(InetHtmlDocument.PROPERTY_MEDIA) != "print");
            this.fetcher = ImageCache.getStaticInstance().getImage(this.imageData.backgroundImage.getResolver(), document.getTimeoutProvider(), false, this.imageData.imageObserver);
            RenderContext renderContext = this.renderContext != null ? this.renderContext : this.view.getRenderContext();
            this.imageData.image = this.fetcher;
            if (this.fetcher != null && this.fetcher.getStatus() <= 1) {
                renderContext.notifyImageLoad(this.fetcher);
            }
            if (this.imageData.image != null) {
                this.imageData.image.getHeight();
            }
        }
    }

    protected String getImageSrc() {
        if (this.elem.getAttributes().isDefined((Object)HTML.Attribute.BACKGROUND)) {
            return this.elem.getAttributes().getAttribute((Object)HTML.Attribute.BACKGROUND).toString();
        }
        if (this.elem.getAttributes().isDefined((Object)HTML.Attribute.BACKGROUND)) {
            return this.elem.getAttributes().getAttribute((Object)HTML.Attribute.BACKGROUND).toString();
        }
        return null;
    }

    private void repaint(long delay) {
        Container container;
        if (this.view != null && (container = this.view.getContainer()) != null && !this.lastPaint.isEmpty()) {
            container.repaint(delay, this.lastPaint.x, this.lastPaint.y, this.lastPaint.width, this.lastPaint.height);
        }
    }

    @Override
    public BoxView getReferenceView() {
        return this.view;
    }

    @Override
    public boolean isInitDone() {
        return this.initDone;
    }

    @Override
    public void setInitDone() {
        this.initDone = true;
    }

    @Override
    public ColorValue getBackgroundValue() {
        return this.backgroundValue;
    }

    @Override
    public void setBackgroundValue(ColorValue backgroundValue) {
        this.backgroundValue = backgroundValue;
    }

    @Override
    public void setReferenceView(BoxView view) {
        this.view = view;
    }

    @Override
    public Element getElement() {
        return this.elem;
    }

    @Override
    public Rectangle getLastPaint() {
        return this.lastPaint;
    }

    @Override
    public void setLastPaint(Rectangle lastPaint) {
        this.lastPaint = lastPaint;
    }

    @Override
    public boolean isRelevant() {
        return this.isBackgroundOpaque();
    }

    @Override
    public boolean isBackgroundOpaque() {
        if (this.backgroundValue != null && !this.backgroundValue.isTransparent()) {
            return true;
        }
        return this.imageData != null && this.imageData.backgroundImage != null && !this.imageData.backgroundImage.isNone();
    }

    @Override
    public void reset() {
    }

    private class ImageData {
        private AnimationObserver imageObserver;
        private RemoteImage image;
        private UriValue backgroundImage;
        private int repeat;
        private BackgroundPosition bgPosition;

        private ImageData() {
        }
    }

    private class ImageHandler
    implements AnimationObserver {
        private final boolean doAnimate;

        public ImageHandler(boolean doAnimate) {
            this.doAnimate = doAnimate;
        }

        @Override
        public boolean imageUpdate(Image img, int flags, int x, int y, int newWidth, int newHeight) {
            if (BackgroundPainter.this.view == null || BackgroundPainter.this.view.getParent() == null) {
                return false;
            }
            if ((flags & 0xC0) != 0) {
                BackgroundPainter.this.getReferenceView().getRenderContext().notifyImageLoadDone(BackgroundPainter.this.fetcher);
                BackgroundPainter.this.imageData.image = null;
                return false;
            }
            if ((flags & 0x30) != 0) {
                BackgroundPainter.this.getReferenceView().getRenderContext().notifyImageLoadDone(BackgroundPainter.this.fetcher);
                BackgroundPainter.this.repaint(10L);
            } else if ((flags & 8) != 0) {
                BackgroundPainter.this.repaint(100L);
            }
            return (flags & 0x20) == 0;
        }

        @Override
        public boolean doAnimate() {
            return this.doAnimate;
        }
    }
}

