/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.SingleAttributeValue;
import java.util.HashMap;
import java.util.Map;

public class TextDecoration
extends SingleAttributeValue {
    private int decoration;
    public static final int NONE = 0;
    public static final int UNDERLINE = 1;
    public static final int OVERLINE = 2;
    public static final int LINE_THROUGH = 4;
    private static final HashMap<Integer, String> KEY_MAP = new HashMap();
    static final TextDecoration PARSER = new TextDecoration();

    public TextDecoration() {
        this.setString(KEY_MAP.get(0));
    }

    public TextDecoration(int decoration) {
        this.decoration = decoration;
        this.setString(this.getCompleteString(decoration));
    }

    private String getCompleteString(int decoration) {
        if (decoration == 0) {
            return KEY_MAP.get(0);
        }
        StringBuilder b = new StringBuilder();
        if ((decoration & 1) != 0) {
            b.append(KEY_MAP.get(1)).append(" ");
        }
        if ((decoration & 2) != 0) {
            b.append(KEY_MAP.get(2)).append(" ");
        }
        if ((decoration & 4) != 0) {
            b.append(KEY_MAP.get(4)).append(" ");
        }
        if (b.length() > 0) {
            return b.toString().trim();
        }
        return KEY_MAP.get(0);
    }

    public int getDecoration() {
        return this.decoration;
    }

    @Override
    protected AttributeValue parseCssValue(String valueStr, boolean important) {
        if ("inherit".equals(valueStr = valueStr.toLowerCase())) {
            return AttributeValue.INHERIT;
        }
        TextDecoration value = new TextDecoration();
        int valueConst = 0;
        String[] parts = valueStr.split("\\s+");
        block0: for (Map.Entry<Integer, String> entry : KEY_MAP.entrySet()) {
            for (String part : parts) {
                if (!part.equals(entry.getValue())) continue;
                valueConst |= entry.getKey().intValue();
                continue block0;
            }
        }
        value.decoration = valueConst;
        value.setString(valueStr);
        return value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TextDecoration) {
            TextDecoration other = (TextDecoration)obj;
            if (other.getDecoration() != this.getDecoration()) {
                return false;
            }
            return other.isImportant() == this.isImportant();
        }
        return false;
    }

    static {
        KEY_MAP.put(0, "none");
        KEY_MAP.put(1, "underline");
        KEY_MAP.put(2, "overline");
        KEY_MAP.put(4, "line-through");
    }
}

