/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.SingleAttributeValue;
import java.util.Hashtable;

public class Position
extends SingleAttributeValue {
    public static final byte STATIC = 0;
    public static final byte RELATIVE = 1;
    public static final byte ABSOLUTE = 2;
    public static final byte FIXED = 3;
    private static final Hashtable<String, Position> MAP = new Hashtable();
    static final Position PARSER;
    private byte value;

    private static void factory(String strValue, byte intValue) {
        Position va = new Position();
        va.setString(strValue);
        va.value = intValue;
        MAP.put(strValue, va);
    }

    public static Position getPosition(byte position) {
        switch (position) {
            case 1: {
                return MAP.get("relative");
            }
            case 2: {
                return MAP.get("absolute");
            }
            case 3: {
                return MAP.get("fixed");
            }
        }
        return MAP.get("static");
    }

    public byte getPosition() {
        return this.value;
    }

    @Override
    protected AttributeValue parseCssValue(String valueStr, boolean important) {
        return MAP.get(valueStr.toLowerCase());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Position)) {
            return false;
        }
        Position other = (Position)obj;
        if (this.isImportant() != other.isImportant()) {
            return false;
        }
        return this.value == other.value;
    }

    static {
        Position.factory("static", (byte)0);
        Position.factory("relative", (byte)1);
        Position.factory("absolute", (byte)2);
        Position.factory("fixed", (byte)3);
        Position.factory("sticky", (byte)1);
        PARSER = MAP.get("static");
    }
}

