/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.InetHtmlDocument;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.HtmlAttribute;
import java.util.Hashtable;

public class ListStyleType
extends HtmlAttribute {
    public static final int DISC = 0;
    public static final int CIRCLE = 1;
    public static final int SQUARE = 2;
    public static final int DECIMAL = 3;
    public static final int DECIMAL_LEADING_ZERO = 4;
    public static final int LOWER_ROMAN = 5;
    public static final int UPPER_ROMAN = 6;
    public static final int HEBREW = 7;
    public static final int GEORGIAN = 8;
    public static final int ARMENIAN = 9;
    public static final int CJK_IDEOGRAPHIC = 10;
    public static final int HIRAGANA = 11;
    public static final int KATAKANA = 12;
    public static final int HIRAGANA_IROHA = 13;
    public static final int KATAKANA_IROHA = 14;
    public static final int LOWER_LATIN = 15;
    public static final int UPPER_LATIN = 16;
    public static final int LOWER_GREEK = 17;
    public static final int NONE = 18;
    private int type;
    private static final Hashtable<String, ListStyleType> MAP = new Hashtable();
    static final ListStyleType PARSER;

    private static void factory(String strValue, int intValue) {
        ListStyleType style = new ListStyleType();
        style.type = intValue;
        style.setString(strValue);
        MAP.put(strValue, style);
    }

    public int getType() {
        return this.type;
    }

    @Override
    protected AttributeValue parseCssValue(String valueStr, boolean important) {
        if ("inherit".equalsIgnoreCase(valueStr)) {
            return AttributeValue.INHERIT;
        }
        return MAP.get(valueStr);
    }

    @Override
    AttributeValue parseHtmlValue(InetHtmlDocument doc, String strValue) {
        int value;
        if ("disc".equalsIgnoreCase(strValue) || "disk".equalsIgnoreCase(strValue)) {
            value = 0;
        } else if ("circle".equalsIgnoreCase(strValue)) {
            value = 1;
        } else if ("square".equalsIgnoreCase(strValue)) {
            value = 2;
        } else if ("1".equals(strValue)) {
            value = 3;
        } else if ("a".equals(strValue)) {
            value = 15;
        } else if ("A".equals(strValue)) {
            value = 16;
        } else if ("i".equals(strValue)) {
            value = 5;
        } else if ("I".equals(strValue)) {
            value = 6;
        } else {
            return null;
        }
        ListStyleType listType = new ListStyleType();
        listType.type = value;
        listType.setString(strValue);
        return listType;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ListStyleType)) {
            return false;
        }
        ListStyleType other = (ListStyleType)obj;
        if (this.isImportant() != other.isImportant()) {
            return false;
        }
        return this.type == other.type;
    }

    static {
        ListStyleType.factory("disc", 0);
        ListStyleType.factory("circle", 1);
        ListStyleType.factory("square", 2);
        ListStyleType.factory("decimal", 3);
        ListStyleType.factory("decimal-leading-zero", 4);
        ListStyleType.factory("lower-roman", 5);
        ListStyleType.factory("upper-roman", 6);
        ListStyleType.factory("hebrew", 7);
        ListStyleType.factory("georgian", 8);
        ListStyleType.factory("armenian", 9);
        ListStyleType.factory("cjk-ideographic", 10);
        ListStyleType.factory("hiragana", 11);
        ListStyleType.factory("katakana", 12);
        ListStyleType.factory("hiragana-iroha", 13);
        ListStyleType.factory("katakana-iroha", 14);
        ListStyleType.factory("lower-latin", 15);
        ListStyleType.factory("lower-alpha", 15);
        ListStyleType.factory("upper-latin", 16);
        ListStyleType.factory("upper-alpha", 16);
        ListStyleType.factory("lower-greek", 17);
        ListStyleType.factory("none", 18);
        PARSER = MAP.get("decimal");
    }
}

