/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html;

import com.inet.annotations.PublicApi;
import com.inet.html.CssDocument;
import com.inet.html.InetHtmlConfiguration;
import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlParser;
import com.inet.html.css.CSS;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.css.Styles;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.finder.GenericFinder;
import com.inet.html.parser.CssParser;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.BorderStyleValue;
import com.inet.html.parser.converter.EmptyValue;
import com.inet.html.parser.converter.FontSize;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.UriValue;
import com.inet.html.parser.converter.UrlValue;
import com.inet.html.parser.converter.WhiteSpace;
import com.inet.html.utils.ElementUtils;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.text.AbstractWriter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

@PublicApi
public class InetHtmlWriter
extends AbstractWriter {
    private boolean wasHead;
    private boolean needEncoding;
    private boolean needSpacesEncoding;
    private boolean wasSpace = true;
    private boolean inlineMode = false;
    private boolean writeHierachie = true;
    private HTML.Tag styleContainer = HTML.Tag.DIV;
    private Element sharedParent;
    private boolean writeStyleSpanAfterBody = false;
    private boolean writeSelectedElementOnly = false;
    private Element styleSpanParent = null;
    private InetHtmlConfiguration currentConfig;
    private Map<String, String> imageReplaceMap = null;
    private Map<String, String> hrefReplaceMap = null;
    private AttributeFilter attributeFilter;
    private Map<HTML.Tag, Boolean> tagWritingOptionsMap;
    private int endOffset = 0;
    private int sharedParentStart;
    private int sharedParentEnd;
    private static boolean sortAttributes = false;
    private Document document;
    private boolean absolutePathMode;
    private String emptyBlockFiller = "&nbsp;";
    private static final Set<CSS.Attribute> BORDER_STYLES = new HashSet<CSS.Attribute>(){
        {
            this.add(CSS.Attribute.BORDER_BOTTOM_STYLE);
            this.add(CSS.Attribute.BORDER_TOP_STYLE);
            this.add(CSS.Attribute.BORDER_LEFT_STYLE);
            this.add(CSS.Attribute.BORDER_RIGHT_STYLE);
        }
    };
    private static final Set<CSS.Attribute> BORDER_WIDTH = new HashSet<CSS.Attribute>(){
        {
            this.add(CSS.Attribute.BORDER_BOTTOM_WIDTH);
            this.add(CSS.Attribute.BORDER_TOP_WIDTH);
            this.add(CSS.Attribute.BORDER_LEFT_WIDTH);
            this.add(CSS.Attribute.BORDER_RIGHT_WIDTH);
        }
    };
    private static final List<CSS.Attribute> STYLE_SPAN_ATTS = new ArrayList<CSS.Attribute>(){
        {
            this.add(CSS.Attribute.COLOR);
            this.add(CSS.Attribute.DIRECTION);
            this.add(CSS.Attribute.FONT_FAMILY);
            this.add(CSS.Attribute.FONT_SIZE);
            this.add(CSS.Attribute.FONT_STYLE);
            this.add(CSS.Attribute.FONT_VARIANT);
            this.add(CSS.Attribute.FONT_WEIGHT);
            this.add(CSS.Attribute.LETTER_SPACING);
            this.add(CSS.Attribute.LINE_HEIGHT);
            this.add(CSS.Attribute.TEXT_DECORATION);
            this.add(CSS.Attribute.TEXT_INDENT);
            this.add(CSS.Attribute.TEXT_TRANSFORM);
            this.add(CSS.Attribute.VERTICAL_ALIGN);
            this.add(CSS.Attribute.WHITE_SPACE);
            this.add(CSS.Attribute.WORD_SPACING);
        }
    };
    private boolean trustedImagePath;
    private boolean writeIfNoTextContent;

    public InetHtmlWriter(Writer out, Element element) {
        super(out, element.getDocument(), element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
        this.init(element.getDocument(), element.getStartOffset(), element.getEndOffset() - element.getStartOffset(), element);
    }

    public InetHtmlWriter(Writer out, Document doc, int pos, int len) {
        super(out, doc, pos, len);
        this.init(doc, pos, len, null);
    }

    private void init(Document doc, int pos, int len, Element parent) {
        this.document = doc;
        this.currentConfig = doc instanceof InetHtmlDocument ? ((InetHtmlDocument)doc).getConfiguration() : InetHtmlConfiguration.getBrowserConfig();
        this.setCanWrapLines(false);
        this.setCurrentLineLength(0);
        try {
            Number indentSpace = (Number)doc.getProperty(InetHtmlDocument.PROPERTY_INDENT_SPACE);
            if (indentSpace != null) {
                this.setIndentSpace(indentSpace.intValue());
            }
        }
        catch (Throwable indentSpace) {
            // empty catch block
        }
        this.endOffset = pos + len;
        if (this.endOffset == doc.getLength()) {
            ++this.endOffset;
        }
        if (pos > 0 || len < doc.getLength() || parent != null) {
            Object name;
            this.inlineMode = true;
            this.writeHierachie = Boolean.TRUE.equals(doc.getProperty(InetHtmlDocument.PROPERTY_WRITE_HIERARCHY));
            Element element = this.sharedParent = parent != null ? parent : ElementUtils.findSharedParagraph(pos, len, doc.getDefaultRootElement());
            block5: while (this.sharedParent != null && (name = this.sharedParent.getAttributes().getAttribute(StyleConstants.NameAttribute)) instanceof HTML.Tag) {
                switch ((HTML.Tag)((Object)name)) {
                    case TR: 
                    case TBODY: 
                    case THEAD: 
                    case TFOOT: {
                        this.sharedParent = this.sharedParent.getParentElement();
                        continue block5;
                    }
                }
            }
            if (parent == null) {
                boolean endMatchCondition;
                int endOffs = this.sharedParent.getEndOffset();
                boolean bl = endMatchCondition = this.endOffset == endOffs || InetHtmlDocument.isParagraph(this.sharedParent) && this.endOffset == endOffs - 1;
                while (this.sharedParent != null && this.sharedParent.getStartOffset() == pos && endMatchCondition) {
                    this.sharedParent = this.sharedParent.getParentElement();
                    endMatchCondition = this.endOffset == endOffs || InetHtmlDocument.isParagraph(this.sharedParent) && this.endOffset == endOffs + 1;
                }
            }
            this.sharedParentStart = this.sharedParent.getStartOffset();
            this.sharedParentEnd = this.sharedParent.getEndOffset();
            if (this.styleContainer != null) {
                name = this.sharedParent.getAttributes().getAttribute(StyleConstants.NameAttribute);
                this.writeStyleSpanAfterBody = name == HTML.Tag.HTML || name == HTML.Tag.BODY || this.writeHierachie;
                this.styleContainer = pos > 0 || len < doc.getLength() ? HTML.Tag.SPAN : HTML.Tag.DIV;
            }
        }
    }

    @Override
    public void write() throws BadLocationException, IOException {
        Object rootTag;
        String dt;
        Element root = this.getElementIterator().first();
        if (this.getStartOffset() + 1 <= this.getEndOffset() && this.isEmpty(root)) {
            if (!this.writeIfNoTextContent) {
                return;
            }
            Element body = null;
            if (root.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.BODY) {
                body = root;
            } else if (root.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.HTML) {
                for (int i = 0; i < root.getElementCount(); ++i) {
                    Element child = root.getElement(i);
                    if (child.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.BODY) continue;
                    body = child;
                    break;
                }
            }
            if (body != null) {
                if (body.getElementCount() == 0) {
                    return;
                }
                if (body.getElementCount() == 1 && ElementUtils.isEndMarker(body.getElement(0))) {
                    return;
                }
            }
        }
        if ((this.sharedParent == null || this.sharedParent.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.HTML) && this.document instanceof InetHtmlDocument && (dt = ((InetHtmlDocument)this.document).getDocType().getTypeString()) != null) {
            this.write(dt);
            this.writeLineSeparator();
        }
        if (this.writeSelectedElementOnly && this.sharedParent != null && (rootTag = this.sharedParent.getAttributes().getAttribute(StyleConstants.NameAttribute)) != HTML.Tag.HTML && rootTag != HTML.Tag.HEAD) {
            this.wasHead = true;
        }
        this.writeNode(root);
    }

    private boolean isEmpty(Element elem) {
        if (elem != null) {
            if (!this.inRange(elem)) {
                return true;
            }
            if (elem.isLeaf()) {
                AttributeSet attr = elem.getAttributes();
                Object name = attr.getAttribute(StyleConstants.NameAttribute);
                return name == HTML.Tag.CONTENT && attr.getAttribute("CR") != null;
            }
            for (int i = 0; i < elem.getElementCount(); ++i) {
                Element child = elem.getElement(i);
                if (this.isEmpty(child)) continue;
                return false;
            }
        }
        return true;
    }

    private void writeNode(Element elem) throws BadLocationException, IOException {
        if (elem != null && (elem.isLeaf() || elem.getElementCount() > 0)) {
            if (!this.inRange(elem)) {
                return;
            }
            if (elem.isLeaf()) {
                this.emptyTag(elem);
            } else {
                boolean isHead;
                boolean shouldWrite = this.isToWrite(elem);
                boolean bl = isHead = elem.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.HEAD;
                if (isHead && this.wasHead && !shouldWrite) {
                    return;
                }
                if (shouldWrite) {
                    boolean firstHead = !this.wasHead;
                    boolean bl2 = shouldWrite = !this.startTag(elem);
                    if (isHead && firstHead) {
                        return;
                    }
                }
                this.sharedParentStart(elem);
                for (int i = 0; i < elem.getElementCount(); ++i) {
                    Element child = elem.getElement(i);
                    if (shouldWrite) {
                        this.incrIndent();
                        this.writeNode(child);
                        this.decrIndent();
                        continue;
                    }
                    this.writeNode(child);
                }
                if (elem == this.styleSpanParent) {
                    this.addFormatLine();
                    this.write("</" + this.styleContainer.name().toLowerCase() + ">");
                    this.decrIndent();
                }
                if (shouldWrite) {
                    this.endTag(elem);
                }
            }
        }
    }

    private void sharedParentStart(Element elem) throws IOException {
        if (!this.inlineMode || this.sharedParent == null || this.styleSpanParent != null) {
            return;
        }
        if (this.writeStyleSpanAfterBody && this.styleContainer != null && elem.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.BODY) {
            this.writeStyleContainer(elem);
            this.styleSpanParent = elem;
        } else if (elem == this.sharedParent && this.styleContainer != null) {
            this.writeStyleContainer(elem);
            this.styleSpanParent = elem;
        }
    }

    private void writeStyleContainer(Element elem) throws IOException {
        if (this.styleContainer == null) {
            return;
        }
        this.incrIndent();
        this.addFormatLine();
        this.write("<" + this.styleContainer.name().toLowerCase());
        SimpleAttributeSet atts = new SimpleAttributeSet();
        for (CSS.Attribute att : STYLE_SPAN_ATTS) {
            Object value;
            AttributeFinder<AttributeValue> finder = GenericFinder.getFinder(att);
            if (finder == null || (value = att != CSS.Attribute.FONT_SIZE ? StyleResolver.getAttributeValue(elem, finder, att != CSS.Attribute.FONT_SIZE) : ((value = elem.getAttributes().getAttribute((Object)TemporaryStyle.Attribute.FONT_SIZE)) instanceof Float ? new FontSize(Math.round(LengthUnit.getPTforPX(((Float)value).floatValue()))) : null)) == null) continue;
            atts.addAttribute((Object)att, value);
        }
        this.writeAttributes(atts);
        this.write('>');
    }

    private boolean isToWrite(Element elem) {
        Object name = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (name == HTML.Tag.TBODY) {
            MutableAttributeSet relevantAtrributes = ElementUtils.removeNonessentialAttributes(elem.getAttributes(), elem.getParentElement());
            relevantAtrributes.removeAttribute(InetHtmlDocument.FLAG_INIT);
            relevantAtrributes.removeAttribute(StyleConstants.NameAttribute);
            if (relevantAtrributes.getAttributeCount() == 0) {
                return false;
            }
        }
        if (this.tagWritingOptionsMap != null && this.tagWritingOptionsMap.get(name) != null) {
            return this.tagWritingOptionsMap.get(name);
        }
        if (this.writeHierachie) {
            return true;
        }
        if (name == HTML.Tag.STYLE) {
            return true;
        }
        if (!this.writeHierachie && this.sharedParent == elem) {
            return false;
        }
        int elemStartOffset = elem.getStartOffset();
        int elemEndOffset = elem.getEndOffset();
        if (elemStartOffset >= this.sharedParentStart && elemEndOffset <= this.sharedParentEnd) {
            if (elemStartOffset == this.sharedParentStart && elemEndOffset == this.sharedParentEnd && ElementUtils.isRelated(this.sharedParent, elem)) {
                return false;
            }
            return elemStartOffset != elemEndOffset || elemStartOffset != this.sharedParentStart || ElementUtils.isRelated(elem, this.sharedParent);
        }
        return false;
    }

    protected void emptyTag(Element elem) throws BadLocationException, IOException {
        AttributeSet attr = elem.getAttributes();
        Object name = attr.getAttribute(StyleConstants.NameAttribute);
        if (name == HTML.Tag.CONTENT) {
            if (!attr.isDefined("CR")) {
                this.needEncoding = true;
                if (this.isPreformatted(elem)) {
                    String cr = this.getLineSeparator();
                    this.setLineSeparator("\r\n");
                    this.text(elem);
                    this.setLineSeparator(cr);
                } else {
                    this.needSpacesEncoding = true;
                    this.text(elem);
                }
                this.needSpacesEncoding = false;
                this.needEncoding = false;
            }
        } else {
            this.write('<');
            this.write(name.toString());
            this.writeAttributes(attr);
            this.write('>');
            this.wasSpace = false;
        }
    }

    protected boolean isBlockTag(Element elem) {
        return InetHtmlParser.breaksFlow(elem);
    }

    protected boolean startTag(Element elem) throws IOException {
        AttributeSet attrs = elem.getAttributes();
        Object name = attrs.getAttribute(StyleConstants.NameAttribute);
        if (name == HTML.Tag.HEAD && !this.wasHead) {
            this.writeHead(elem);
            return true;
        }
        if (name == HTML.Tag.BODY && !this.wasHead) {
            this.writeHead(null);
        }
        if (this.wasSpace && !this.isLineEmpty()) {
            if (!this.isPreformatted(elem)) {
                this.addFormatLine();
            }
        } else if (this.isBlockTag(elem)) {
            this.wasSpace = true;
        }
        this.write('<');
        this.write(name.toString());
        this.writeAttributes(attrs);
        this.write('>');
        return false;
    }

    private boolean fillIfEmpy(Element elem) {
        Object name = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (InetHtmlParser.TABLE_STRUCT_TAGS.contains(name)) {
            return false;
        }
        if (name instanceof HTML.Tag) {
            switch ((HTML.Tag)((Object)name)) {
                case HTML: 
                case HEAD: 
                case META: 
                case SCRIPT: 
                case BODY: {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    protected void endTag(Element elem) throws IOException {
        Element block;
        Element child;
        AttributeSet attrs = elem.getAttributes();
        Object name = attrs.getAttribute(StyleConstants.NameAttribute);
        boolean isBlock = this.isBlockTag(elem);
        if (this.currentConfig.isTransformEmptyBlocks() && elem.getElementCount() == 1 && (child = elem.getElement(0)).getAttributes().isDefined("CR") && this.fillIfEmpy(block = ElementUtils.findNextHigherBlock(child))) {
            this.write(this.emptyBlockFiller);
            if (isBlock) {
                this.wasSpace = false;
            }
        }
        if (this.wasSpace && isBlock) {
            if (!this.isPreformatted(elem)) {
                this.addFormatLine();
            }
        } else if (isBlock) {
            this.wasSpace = true;
        }
        this.write("</");
        this.write(name.toString());
        this.write('>');
    }

    @Override
    protected void writeAttributes(AttributeSet attrs) throws IOException {
        StringBuilder styles = new StringBuilder();
        Object nameObj = null;
        Element elem = null;
        if (this.attributeFilter != null && attrs instanceof Element) {
            nameObj = attrs.getAttribute(StyleConstants.NameAttribute);
            elem = (Element)((Object)attrs);
        }
        if (this.inlineMode && attrs instanceof Element) {
            if (this.attributeFilter == null && attrs instanceof Element) {
                nameObj = attrs.getAttribute(StyleConstants.NameAttribute);
                elem = (Element)((Object)attrs);
            }
            StyleResolver res = ((CssDocument)this.document).getStyleResolver();
            Styles defaultStyles = res.getStyleSheet("DEFAULT");
            Element parent = elem.getParentElement();
            MutableAttributeSet globalDefault = defaultStyles.getDefaultSet(nameObj);
            boolean writeSize = false;
            for (CSS.Attribute att : CSS.Attribute.values()) {
                AttributeValue parentValue;
                AttributeValue value;
                AttributeFinder<AttributeValue> finder = GenericFinder.getFinder(att);
                if (finder == null || (value = StyleResolver.getAttributeValue(elem, finder, att != CSS.Attribute.FONT_SIZE && finder.isInherited())) == null || finder.getHTMLAttribute() != null && value == elem.getAttributes().getAttribute((Object)finder.getHTMLAttribute())) continue;
                Object defaultValue = globalDefault != null ? globalDefault.getAttribute((Object)TemporaryStyle.getAttribute(att)) : null;
                AttributeValue defaultLocal = defaultStyles.getCssAttribute(elem, att, false);
                defaultValue = defaultLocal != null ? defaultLocal : defaultValue;
                boolean inherited = finder.isInherited();
                if (att == CSS.Attribute.TEXT_DECORATION || att == CSS.Attribute.LINE_HEIGHT) {
                    value = ((CssDocument)this.document).getStyleResolver().getAttributeValueNonInherit(elem, finder);
                    if (value == null) continue;
                    inherited = false;
                }
                if ((!finder.isInherited() || parent == null) && value.equals(defaultValue)) {
                    if (!BORDER_WIDTH.contains((Object)att)) continue;
                    if (!writeSize) {
                        writeSize = false;
                        continue;
                    }
                    writeSize = false;
                }
                if (inherited && (value.equals(defaultValue) || defaultValue == null && parent != null && value.equals(parentValue = StyleResolver.getAttributeValue(parent, finder)))) continue;
                if (BORDER_STYLES.contains((Object)att) && ((BorderStyleValue)value).getStyle() != 0) {
                    writeSize = true;
                }
                if (BORDER_WIDTH.contains((Object)att)) {
                    writeSize = false;
                }
                this.writeStyleAttribute(styles, (Object)att, value, nameObj, attrs, elem);
            }
            Enumeration<Object> keys = attrs.getAttributeNames();
            if (sortAttributes) {
                keys = this.getSortedEnumeration(keys);
            }
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                if (key instanceof HTML.Attribute && key != HTML.Attribute.STYLE || key instanceof HTML.UnknownAttribute) {
                    Object value = attrs.getAttribute(key);
                    this.writeAttribute(key, value, true, nameObj, attrs, elem);
                    continue;
                }
                if (!(key instanceof CSS.UnknownAttribute)) continue;
                Object value = attrs.getAttribute(key);
                this.writeStyleAttribute(styles, key, value, nameObj, attrs, elem);
            }
        } else {
            Enumeration<Object> keys = attrs.getAttributeNames();
            if (sortAttributes) {
                keys = this.getSortedEnumeration(keys);
            }
            while (keys.hasMoreElements()) {
                String newValue;
                Object key = keys.nextElement();
                if (key instanceof CSS.Attribute || key instanceof CSS.UnknownAttribute) {
                    this.writeStyleAttribute(styles, key, attrs.getAttribute(key), nameObj, attrs, elem);
                    continue;
                }
                if (key instanceof HTML.Tag || key instanceof StyleConstants || key instanceof TemporaryStyle.Attribute || key == HTML.Attribute.STYLE || "CR".equals(key) || "/".equals(key)) continue;
                Object value = attrs.getAttribute(key);
                boolean encode = true;
                if (key == HTML.Attribute.SRC && this.imageReplaceMap != null && (newValue = this.imageReplaceMap.get(value.toString())) != null) {
                    value = newValue;
                    boolean bl = encode = !this.trustedImagePath;
                }
                if (key == HTML.Attribute.HREF && this.hrefReplaceMap != null && (newValue = this.hrefReplaceMap.get(value.toString())) != null) {
                    value = newValue;
                    encode = !this.trustedImagePath;
                }
                this.writeAttribute(key, value, encode, nameObj, attrs, elem);
            }
        }
        if (styles.length() > 0) {
            this.writeAttribute("style", styles, true, nameObj, attrs, elem);
        }
        if (attrs.getAttribute("/") == Boolean.TRUE) {
            this.write('/');
        }
    }

    private void writeStyleAttribute(StringBuilder styles, Object att, Object value, Object elementName, AttributeSet elementAttributes, Element element) {
        if (this.attributeFilter != null && (value = this.attributeFilter.filterAttributeValue(elementName, att, value, elementAttributes, element)) == AttributeFilter.DONT_WRITE) {
            return;
        }
        styles.append(att);
        styles.append(':');
        String stringValue = value != null ? value.toString() : null;
        styles.append(stringValue != null ? stringValue.replace('\"', ' ').replace('\'', ' ') : "none");
        if (value instanceof AttributeValue && ((AttributeValue)value).isImportant()) {
            styles.append(" !important");
        }
        styles.append(';');
    }

    private void writeAttribute(Object name, Object value, boolean encode, Object elementName, AttributeSet elementAttributes, Element element) throws IOException {
        if (this.attributeFilter != null && (value = this.attributeFilter.filterAttributeValue(elementName, name, value, elementAttributes, element)) == AttributeFilter.DONT_WRITE) {
            return;
        }
        if (this.inlineMode && name == HTML.Attribute.CLASS) {
            return;
        }
        this.write(' ');
        this.write(name.toString());
        if (value instanceof EmptyValue) {
            return;
        }
        if (value instanceof AttributeValue && !((AttributeValue)value).isWriteValue()) {
            return;
        }
        if (this.absolutePathMode && value instanceof UrlValue) {
            URL urlValue;
            UrlValue url = (UrlValue)value;
            if (this.document instanceof InetHtmlDocument) {
                url.getResolver().setBase(((InetHtmlDocument)this.document).getBase());
            }
            if ((urlValue = url.getAbsoluteURL()) != null) {
                value = urlValue.toExternalForm();
            }
        }
        this.write("=\"");
        this.needEncoding = encode;
        this.write(value.toString());
        this.needEncoding = false;
        this.write('\"');
    }

    private void addFormatLine() throws IOException {
        if (this.getIndentSpace() > 0) {
            this.writeLineSeparator();
            this.indent();
        }
        this.wasSpace = true;
    }

    private void writeHead(Element elem) throws IOException {
        int i;
        this.wasHead = true;
        this.addFormatLine();
        this.write("<head>");
        this.incrIndent();
        this.addFormatLine();
        Element head = null;
        Element root = this.getDocument().getDefaultRootElement();
        for (i = 0; i < root.getElementCount(); ++i) {
            Element current = root.getElement(i);
            if (current.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.HEAD) continue;
            head = current;
            break;
        }
        if (head != null) {
            for (i = 0; i < head.getElementCount(); ++i) {
                Element child = head.getElement(i);
                try {
                    Object name = child.getAttributes().getAttribute(StyleConstants.NameAttribute);
                    if (name == HTML.Tag.STYLE || name == HTML.Tag.CONTENT) continue;
                    this.writeNode(child);
                    this.addFormatLine();
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        this.writeTitle();
        if (!this.inlineMode) {
            this.writeStyles();
        }
        this.decrIndent();
        this.addFormatLine();
        this.write("</head>");
    }

    private void writeTitle() throws IOException {
        Object title = this.document.getProperty("title");
        if (title != null && title.toString().length() > 0) {
            this.write("<title>");
            this.incrIndent();
            this.addFormatLine();
            this.needEncoding = true;
            this.write(title.toString());
            this.needEncoding = false;
            this.decrIndent();
            this.addFormatLine();
            this.write("</title>");
            this.addFormatLine();
        }
    }

    private void writeStyles() throws IOException {
        InetHtmlDocument doc = (InetHtmlDocument)this.getDocument();
        Styles styles = doc.getStyleResolver().getStyles();
        int count = styles.getRuleCount();
        if (count == 0) {
            return;
        }
        for (Object id : styles.getSourceIdentifiers()) {
            if (!styles.isExternal(id)) continue;
            this.addFormatLine();
            this.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
            this.write(id.toString());
            this.write("\">");
        }
        this.addFormatLine();
        this.write("<style>");
        this.incrIndent();
        for (Object id : styles.getSourceIdentifiers()) {
            List<Styles.StyleSheetEntry> entries;
            if (styles.isExternal(id)) continue;
            boolean isMedia = id instanceof CssParser.MediaSelector;
            if (isMedia) {
                this.addFormatLine();
                this.write(id.toString());
                this.write(" {");
                this.incrIndent();
            }
            if ((entries = styles.getEntries(id)) == null || entries.size() == 0) {
                if (!isMedia) continue;
                this.decrIndent();
                this.addFormatLine();
                this.write("}");
                continue;
            }
            for (Styles.StyleSheetEntry entry : entries) {
                this.addFormatLine();
                this.write(entry.getSelector());
                AttributeSet attrs = entry.getAttributess();
                if (attrs.getAttributeCount() == 0) continue;
                this.write(" { ");
                Enumeration<Object> keys = attrs.getAttributeNames();
                if (sortAttributes) {
                    keys = this.getSortedEnumeration(keys);
                }
                while (keys.hasMoreElements()) {
                    Object key = keys.nextElement();
                    if (!(key instanceof CSS.Attribute) && !(key instanceof CSS.UnknownAttribute)) continue;
                    Object value = attrs.getAttribute(key);
                    if (this.attributeFilter != null && (value = this.attributeFilter.filterAttributeValue(null, key, value, attrs, null)) == AttributeFilter.DONT_WRITE) continue;
                    this.write(key.toString());
                    this.write(':');
                    if (this.absolutePathMode) {
                        if (value instanceof UrlValue) {
                            URL urlValue;
                            UrlValue url = (UrlValue)value;
                            if (this.document instanceof InetHtmlDocument) {
                                url.getResolver().setBase(((InetHtmlDocument)this.document).getBase());
                            }
                            if ((urlValue = url.getAbsoluteURL()) != null) {
                                value = urlValue.toExternalForm();
                            }
                        }
                        if (value instanceof UriValue) {
                            UriValue uri = (UriValue)value;
                            value = "url(" + uri.getResolvedValue() + ")";
                        }
                    }
                    this.write(value.toString());
                    if (value instanceof AttributeValue && ((AttributeValue)value).isImportant()) {
                        this.write(" !important");
                    }
                    this.write("; ");
                }
                this.write("}");
            }
            if (!isMedia) continue;
            this.decrIndent();
            this.addFormatLine();
            this.write("}");
        }
        this.decrIndent();
        this.addFormatLine();
        this.write("</style>");
    }

    private Enumeration<? extends Object> getSortedEnumeration(Enumeration<?> e) {
        HashMap lexRefMap = new HashMap();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            String keyname = key.toString();
            while (lexRefMap.containsKey(keyname)) {
                keyname = keyname + "_";
            }
            lexRefMap.put(keyname, key);
        }
        TreeSet sorted = new TreeSet(lexRefMap.keySet());
        Vector list = new Vector(lexRefMap.size());
        for (String lexKey : sorted) {
            list.add(lexRefMap.get(lexKey));
        }
        return list.elements();
    }

    @Override
    protected void output(char[] chars, int start, int length) throws IOException {
        if (!this.needEncoding) {
            super.output(chars, start, length);
            return;
        }
        Writer out = this.getWriter();
        int last = start;
        int end = length + start;
        for (int i = start; i < end; ++i) {
            String encodedData = null;
            char ch = chars[i];
            switch (ch) {
                case '<': {
                    encodedData = "&lt;";
                    break;
                }
                case '>': {
                    encodedData = "&gt;";
                    break;
                }
                case '&': {
                    encodedData = "&amp;";
                    break;
                }
                case '\"': {
                    encodedData = "&quot;";
                    break;
                }
                case '\u00a0': {
                    encodedData = "&nbsp;";
                    break;
                }
                case ' ': {
                    if (!this.needSpacesEncoding || !this.wasSpace) break;
                    encodedData = "&nbsp;";
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    if (ch >= ' ' && ch <= '\u007f') break;
                    if (i > last) {
                        super.output(chars, last, i - last);
                    }
                    last = i + 1;
                    out.write("&#");
                    if (ch >= '\ud800' && ch <= '\udbff' && i + 1 < end) {
                        ++last;
                        char ch2 = chars[++i];
                        int unicode = ((ch & 0x3FF) << 10 | ch2 & 0x3FF) + 65536;
                        out.write(String.valueOf(unicode));
                    } else {
                        out.write(String.valueOf((int)ch));
                    }
                    out.write(59);
                }
            }
            if (encodedData != null) {
                if (i > last) {
                    super.output(chars, last, i - last);
                }
                last = i + 1;
                out.write(encodedData);
            }
            if (!this.needSpacesEncoding) continue;
            this.wasSpace = ch == ' ';
        }
        if (last < end) {
            super.output(chars, last, end - last);
        }
    }

    public void registerImageSRCreplace(Map<String, String> imageReplaceMap) {
        this.imageReplaceMap = imageReplaceMap;
    }

    public void registerLinkHREFreplace(Map<String, String> hrefReplaceMap) {
        this.hrefReplaceMap = hrefReplaceMap;
    }

    public void registerAttributeFilter(AttributeFilter filter) {
        this.attributeFilter = filter;
    }

    private boolean isPreformatted(Element elem) {
        WhiteSpace attributeValue = StyleResolver.getAttributeValue(elem, AttributeFinder.WHITE_SPACE);
        switch (attributeValue.getValue()) {
            case 1: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    public static void setSorted(boolean sorted) {
        sortAttributes = sorted;
    }

    public void setInlineMode(boolean inlineMode) {
        this.inlineMode = inlineMode;
    }

    public void setAbsolutePathMode(boolean absolutePathMode) {
        this.absolutePathMode = absolutePathMode;
    }

    public void setAllowStyleSpan(boolean allowStyleSpan) {
        this.styleContainer = allowStyleSpan ? HTML.Tag.SPAN : null;
        this.writeStyleSpanAfterBody &= allowStyleSpan;
    }

    public void setWriteSelectedElementOnly(boolean writeSelectedElementOnly) {
        this.writeSelectedElementOnly = writeSelectedElementOnly;
    }

    public void setWriteIfNoTextContent(boolean writeIfNoTextContent) {
        this.writeIfNoTextContent = writeIfNoTextContent;
    }

    public void setStyleContainer(HTML.Tag styleContainer) {
        this.styleContainer = styleContainer;
        this.writeStyleSpanAfterBody &= styleContainer != null;
    }

    public Map<HTML.Tag, Boolean> getTagWritingOptions() {
        return this.tagWritingOptionsMap;
    }

    public void setTagWritingOptions(Map<HTML.Tag, Boolean> tagWritingOptionsMap) {
        this.tagWritingOptionsMap = tagWritingOptionsMap;
    }

    public void setTrustedImagePath(boolean trustedImagePath) {
        this.trustedImagePath = trustedImagePath;
    }

    public void setEmptyBlockFiller(String emptyBlockFiller) {
        this.emptyBlockFiller = emptyBlockFiller != null ? emptyBlockFiller : "";
    }

    static {
        try {
            if ("true".equalsIgnoreCase(System.getProperty("sortAttributes"))) {
                sortAttributes = true;
            }
        }
        catch (SecurityException e) {
            sortAttributes = false;
        }
    }

    public static interface AttributeFilter {
        public static final Object DONT_WRITE = new Object();

        default public Object filterAttributeValue(Object elementName, Object key, Object value, AttributeSet elementAttributes, Element element) {
            return value;
        }
    }
}

