/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.BaseEditor;
import com.inet.editor.HtmlEditorUtils;
import com.inet.editor.SourceCodeDialog;
import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlEditorKit;
import com.inet.html.actions.InetHtmlAction;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public class SourceCodeAction
extends InetHtmlAction {
    private static final long serialVersionUID = 1L;

    public SourceCodeAction() {
        super("sourcecode");
        this.putValue("ShortDescription", HtmlEditorUtils.getTranslation("sourcecode"));
        this.putValue("Name", HtmlEditorUtils.getTranslation("sourcecode"));
        this.putValue("SmallIcon", HtmlEditorUtils.getResourceImage("sourcecode.gif"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(85, InetHtmlEditorKit.SHORTCUT_KEY_MASK));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof Component) {
            Frame frame;
            Component comp = (Component)source;
            JTextComponent text = null;
            if (comp instanceof Container) {
                Container parent = (Container)comp;
                while (parent != null && !(parent instanceof BaseEditor) && !(parent instanceof JTextComponent)) {
                    if (parent instanceof JPopupMenu) {
                        Component invoker = ((JPopupMenu)parent).getInvoker();
                        if (invoker instanceof Container) {
                            parent = (Container)invoker;
                            continue;
                        }
                        parent = null;
                        continue;
                    }
                    if (parent.getParent() == null) break;
                    parent = parent.getParent();
                }
                if (parent != null && parent instanceof BaseEditor) {
                    text = ((BaseEditor)parent).getEditor();
                }
                if (parent != null && parent instanceof JTextComponent) {
                    text = (JTextComponent)parent;
                }
            }
            if (text == null) {
                text = this.getEditor(e);
            }
            if (text == null) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
                return;
            }
            SourceCodeDialog sourceCodeDialog = null;
            Window windowForComponent = SwingUtilities.getWindowAncestor(text);
            if (windowForComponent instanceof JFrame) {
                frame = (JFrame)windowForComponent;
                sourceCodeDialog = new SourceCodeDialog((JFrame)frame);
            }
            if (windowForComponent instanceof JDialog) {
                JDialog dialog = (JDialog)windowForComponent;
                sourceCodeDialog = new SourceCodeDialog(dialog);
            }
            if (windowForComponent instanceof Frame) {
                frame = (Frame)windowForComponent;
                sourceCodeDialog = new SourceCodeDialog(frame);
            }
            if (sourceCodeDialog != null) {
                sourceCodeDialog.setEditor(text);
                text.getDocument().putProperty(InetHtmlDocument.PROPERTY_INDENT_SPACE, new Integer(4));
                sourceCodeDialog.setSourceCode(text.getText());
                text.getDocument().putProperty(InetHtmlDocument.PROPERTY_INDENT_SPACE, new Integer(0));
                sourceCodeDialog.showDialog();
            }
        }
    }
}

